/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter {
    private static final DatatypeFactory _df;

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date.getTime());
        return _df.newXMLGregorianCalendar(gc);
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(String date) throws DatatypeConfigurationException {
        if (date == null) {
            return null;
        }
        return _df.newXMLGregorianCalendar(date);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }

    static {
        try {
            _df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Exception while obtaining DatatypeFactory instance", dce);
        }
    }
}

