/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.updater;

import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XPPatchDownloader {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.XPPatchDownloader");
    private static final String PROPERTY_BUILD_NUMBER = "ponton.buildnumber";
    private static final String PROPERTY_PATCH_SIZE = "ponton.patchsize";
    private static final String PROPERTY_XP_VERSION = "ponton.version";
    private static final String PROPERTY_XP_MIN_VERSION = "ponton.min.version";
    private static final String PROPERTY_JAVA_MIN_VERSION = "java.min.version";
    private final HttpProvider _httpProvider;
    private final String _patchFileURI;
    private final String _patchPropertiesURI;
    private final long _buildNumber;
    private final String _installedXpVersion;
    private long _patchSize;
    private String _patchVersion;

    public XPPatchDownloader(HttpProvider httpProvider, String patchFielURI, String patchPropertiesURI, String installedXpVersion, long buildNumber) {
        this._httpProvider = httpProvider;
        this._patchFileURI = patchFielURI;
        this._patchPropertiesURI = patchPropertiesURI;
        this._installedXpVersion = installedXpVersion;
        this._buildNumber = buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isPatchAvailable() {
        File propertiesFile = this.download(this._patchPropertiesURI);
        if (propertiesFile != null && propertiesFile.isFile()) {
            String buildNumber;
            String xpVersion;
            Properties properties;
            BufferedInputStream in;
            block22: {
                String javaMinVersion;
                block21: {
                    String xpMinVersion;
                    block20: {
                        in = null;
                        in = new BufferedInputStream(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));
                        properties = new Properties();
                        properties.load(in);
                        xpVersion = properties.getProperty(PROPERTY_XP_VERSION);
                        buildNumber = properties.getProperty(PROPERTY_BUILD_NUMBER);
                        xpMinVersion = properties.getProperty(PROPERTY_XP_MIN_VERSION);
                        javaMinVersion = properties.getProperty(PROPERTY_JAVA_MIN_VERSION);
                        if (!StringUtils.isBlank((CharSequence)xpMinVersion) && !StringUtils.isBlank((CharSequence)javaMinVersion) && !StringUtils.isBlank((CharSequence)xpVersion) && !StringUtils.isBlank((CharSequence)buildNumber)) break block20;
                        boolean bl = false;
                        IOUtil.closeStreamQuietly(in);
                        try {
                            propertiesFile.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return bl;
                    }
                    long patchBuildNumber = Long.parseLong(properties.getProperty(PROPERTY_BUILD_NUMBER));
                    if (this.checkPatchVersion(xpMinVersion, xpVersion, patchBuildNumber)) break block21;
                    boolean bl = false;
                    IOUtil.closeStreamQuietly(in);
                    try {
                        propertiesFile.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                if (this.checkJavaVersion(javaMinVersion)) break block22;
                boolean bl = false;
                IOUtil.closeStreamQuietly(in);
                try {
                    propertiesFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
            this._patchSize = Long.parseLong(properties.getProperty(PROPERTY_PATCH_SIZE));
            this._patchVersion = xpVersion + " (Build " + buildNumber + ")";
            boolean bl = true;
            IOUtil.closeStreamQuietly(in);
            try {
                propertiesFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
            catch (Exception e) {
                boolean bl2;
                try {
                    _log.warn((Object)("Error occurred while checking for messenger updates: " + e.getMessage()));
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtil.closeStreamQuietly(in);
                    try {
                        propertiesFile.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                IOUtil.closeStreamQuietly(in);
                try {
                    propertiesFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl2;
            }
        }
        return false;
    }

    private boolean checkJavaVersion(String javaMinVersion) {
        String[] runningJavaVersion = System.getProperty("java.version").split("_");
        String[] requiredMinVersion = javaMinVersion.split("_");
        switch (Util.compareVersions(runningJavaVersion[0], requiredMinVersion[0])) {
            case -1: {
                return false;
            }
            case 0: {
                if (requiredMinVersion.length <= 1) break;
                return Integer.parseInt(runningJavaVersion[1]) >= Integer.parseInt(requiredMinVersion[1]);
            }
        }
        return true;
    }

    private boolean checkPatchVersion(String xpMinVersion, String patchVersion, long patchBuildNumber) {
        if (Util.compareVersions(this._installedXpVersion, xpMinVersion) < 0) {
            return false;
        }
        switch (Util.compareVersions(this._installedXpVersion, patchVersion)) {
            case 1: {
                return false;
            }
            case 0: {
                if (patchBuildNumber > this._buildNumber) break;
                return false;
            }
        }
        return true;
    }

    public File downloadPatch() {
        return this.download(this._patchFileURI);
    }

    private File download(String uriAsString) {
        File file;
        block7: {
            file = null;
            URI uri = null;
            try {
                uri = new URI(uriAsString);
                file = File.createTempFile("PontonPathDownloader", "file");
                ProviderResponse response = this._httpProvider.getData(file, null, uri, null, null, null, null, 60);
                if (response.isFailed() || response.isAuthorizationFailed()) {
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                _log.warn((Object)("Could not download file '" + uriAsString + "': " + e.getMessage()));
                if (file == null) break block7;
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return file;
    }

    public long getPatchSize() {
        return this._patchSize;
    }

    public String getPatchVersion() {
        return this._patchVersion;
    }
}

