/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.updater;

import de.pontonconsulting.common.file.FileUtils;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportProviderFactory;
import de.pontonconsulting.xmlpipe.security.PontonAuthenticator;
import de.pontonconsulting.xmlpipe.updater.XPPatchDownloader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatchDownloadThread
extends Thread {
    private static final String DEFAULT_PATCH_URI = "http://www.ponton.de/downloads/xp/3.3/updates";
    private static final String PROPERTY_PATCH = "ponton.update.download";
    private static final String EVENT_ID = "patch";
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.PatchDownloadThread");
    private boolean _keepRunning;
    private final XPPatchDownloader _downloader;
    private final IServerConfigBean _serverConfig;
    private final MessengerConfig _messengerConfig;
    private final EventLog _eventLog;
    private final PontonAuthenticator _authenticator;
    private final IMessengerProperties _messengerProperties;
    private boolean _patchAvailable;
    private long _patchSize;

    public PatchDownloadThread(TransportProviderFactory transportProviderFactory, IServerConfigBean serverConfig, MessengerConfig messengerConfig, EventLog eventLog, PontonAuthenticator authenticator, IMessengerProperties messengerProperties) {
        super("PatchDownloadThread");
        this._serverConfig = serverConfig;
        this._messengerConfig = messengerConfig;
        this._eventLog = eventLog;
        this._authenticator = authenticator;
        this.setDaemon(true);
        _log.debug((Object)"Starting up the PatchDownloadThread.");
        this._keepRunning = true;
        this._messengerProperties = messengerProperties;
        this._downloader = new XPPatchDownloader((HttpProvider)transportProviderFactory.getTransportProvider(this.getPatchFileURI()), this.getPatchFileURI(), this.getPatchPropertiesURI(), Constants.getXP_VERSION(), Constants.getBuildNumber());
    }

    @Override
    public void run() {
        while (this._keepRunning) {
            try {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Checking for an update.");
                    }
                    if (this._downloader.isPatchAvailable()) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"An update for PontonXP is available.");
                        }
                        this._patchAvailable = true;
                        this._eventLog.writeOK(EVENT_ID + this._downloader.getPatchVersion(), "Messenger", "updater.updater_available", "", new String[0], this.getPatchNotesURI());
                    } else if (_log.isTraceEnabled()) {
                        _log.trace((Object)"No update for PontonXP available.");
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e.getMessage());
                }
                PatchDownloadThread.sleep(86400000L);
            }
            catch (InterruptedException ie) {
                _log.debug((Object)"sleep was interrupted");
            }
        }
    }

    public void shutdown() {
        this._keepRunning = false;
        this.interrupt();
    }

    public boolean downloadPatch() throws IOException {
        this._patchSize = 0L;
        if (this._downloader.isPatchAvailable()) {
            _log.debug((Object)"starting download of patch");
            File tmpPatch = this._downloader.downloadPatch();
            if (tmpPatch == null) {
                return false;
            }
            File patch = new File(this._serverConfig.getXpHome().getParentFile(), "updater/ponton-patch.jar");
            if (patch.exists()) {
                patch.delete();
            }
            FileUtils.move(tmpPatch, patch);
            _log.info((Object)"download of patch completed.");
            this._patchSize = patch.length();
            return true;
        }
        return false;
    }

    public boolean isPatchAvailable() {
        return this._patchAvailable;
    }

    public long getPatchSize() {
        return this._patchSize;
    }

    public long getExpectedPatchSize() {
        return this._downloader.getPatchSize();
    }

    public String getPatchVersion() {
        return this._downloader.getPatchVersion();
    }

    public String getPatchFileURI() {
        return this._messengerProperties.getProperty(PROPERTY_PATCH, DEFAULT_PATCH_URI) + "/ponton-patch.jar";
    }

    public String getPatchPropertiesURI() {
        return this._messengerProperties.getProperty(PROPERTY_PATCH, DEFAULT_PATCH_URI) + "/ponton-patch.properties";
    }

    public String getPatchNotesURI() {
        return this._messengerProperties.getProperty(PROPERTY_PATCH, DEFAULT_PATCH_URI) + "/ponton-patch.html";
    }
}

