/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ProcessingDirectives
extends HeaderExtension {
    private static final String EBXML_DIRECTIVE_VALUE = "Value";
    private static final String EBXML_DIRECTIVE_TYPE = "type";
    private final HashMap<String, String> _directives;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProcessingDirectives(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        this._directives = new HashMap();
        Name elementName = elem.getElementName();
        if (this.compare(elementName, "ProcessingDirectives", "http://www.ponton-consulting.de/xmlpipe/processing-directives")) {
            Iterator it = elem.getChildElements();
            SOAPElement element = null;
            Name typeName = env.createName(EBXML_DIRECTIVE_TYPE, "xp", "http://www.ponton-consulting.de/xmlpipe/processing-directives");
            while (it.hasNext()) {
                Name name;
                Object subElement = it.next();
                if (!(subElement instanceof SOAPElement) || !this.compareXP(name = (element = (SOAPElement)subElement).getElementName(), EBXML_DIRECTIVE_VALUE)) continue;
                String key = element.getAttributeValue(typeName);
                String value = element.getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                this._directives.put(key, value);
            }
            return;
        } else {
            try {
                String ebXmlParameter;
                Document doc = this.buildDocument(elem.toString());
                Node firstNode = doc.getFirstChild();
                NamedNodeMap attributes = firstNode.getAttributes();
                String mustUnderstandName = env.getPrefix() + ":mustUnderstand";
                if (attributes.getNamedItem(mustUnderstandName) != null) {
                    attributes.removeNamedItem(mustUnderstandName);
                    String soapNSName = "xmlns:" + env.getPrefix();
                    if (attributes.getNamedItem(soapNSName) != null) {
                        attributes.removeNamedItem(soapNSName);
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(ebXmlParameter = this.nodeToString(doc)))) return;
                this._directives.put("EbXMLParameter", ebXmlParameter);
                return;
            }
            catch (Exception e) {
                throw new SOAPException("Could not read ebXML parameters.", (Throwable)e);
            }
        }
    }

    public ProcessingDirectives(HashMap<String, String> data) {
        this._directives = data;
    }

    private Document buildDocument(String node) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(new ByteArrayInputStream(node.getBytes()));
    }

    private String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer t = transformerFactory.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("indent", "no");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public void generateSOAP(SOAPHeader ebHeader, SOAPEnvelope envelope) throws SOAPException {
        if (this._directives != null && this._directives.size() > 0) {
            String ebXmlParameter = this._directives.get("EbXMLParameter");
            if (ebXmlParameter != null) {
                try {
                    Document doc = this.buildDocument(ebXmlParameter);
                    Node node = doc.getFirstChild();
                    Name rootName = envelope.createName(node.getLocalName(), node.getPrefix(), node.getNamespaceURI());
                    SOAPHeaderElement ebHeaderElement = ebHeader.addHeaderElement(rootName);
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node attribute = attributes.item(i);
                        ebHeaderElement.addAttribute(envelope.createName(attribute.getLocalName(), attribute.getPrefix(), attribute.getNamespaceURI()), attribute.getNodeValue());
                    }
                    this.setMustUnderstand(false);
                    this.generateMustUnderstand(ebHeaderElement, envelope);
                    node = ebHeaderElement.getOwnerDocument().importNode(node, true);
                    NodeList nodeList = node.getChildNodes();
                    int length = nodeList.getLength();
                    while ((length = nodeList.getLength()) > 0) {
                        Node subNode = nodeList.item(0);
                        if (subNode instanceof Comment) {
                            node.removeChild(subNode);
                        } else if (subNode instanceof Text) {
                            ebHeaderElement.addTextNode(subNode.getTextContent());
                            node.removeChild(subNode);
                        } else {
                            ebHeaderElement.appendChild(subNode);
                        }
                        if (length != nodeList.getLength()) continue;
                        throw new Exception("Detect an endless recursion by writing ebXML parameters.");
                    }
                }
                catch (Exception e) {
                    throw new SOAPException("Could not write ebXML parameters.", (Throwable)e);
                }
            } else {
                SOAPHeaderElement ebHeaderElement = ebHeader.addHeaderElement(envelope.createName("ProcessingDirectives", "xp", "http://www.ponton-consulting.de/xmlpipe/processing-directives"));
                this.setMustUnderstand(false);
                this.generateMustUnderstand(ebHeaderElement, envelope);
                Name valueName = envelope.createName(EBXML_DIRECTIVE_VALUE, "xp", "http://www.ponton-consulting.de/xmlpipe/processing-directives");
                Name typeName = envelope.createName(EBXML_DIRECTIVE_TYPE, "xp", "http://www.ponton-consulting.de/xmlpipe/processing-directives");
                for (String key : this._directives.keySet()) {
                    String value = this._directives.get(key);
                    SOAPElement valueElement = ebHeaderElement.addChildElement(valueName);
                    valueElement.addTextNode(value);
                    valueElement.addAttribute(typeName, key);
                }
            }
        }
    }

    public HashMap<String, String> getDirectives() {
        return this._directives;
    }

    protected final boolean compareXP(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase("http://www.ponton-consulting.de/xmlpipe/processing-directives");
    }

    private final boolean compare(Name got, String localName, String nameSpaceURI) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase(nameSpaceURI);
    }
}

