/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.header.PartyId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class Party {
    private String _role;
    public static final String EBXML_ROLE = "Role";
    private HashMap<String, String> _partyId = new HashMap();
    public static final String EBXML_PARTY_ID = "PartyId";

    public Party() {
    }

    public Party(HashMap<String, String> parties) {
        this._partyId = (HashMap)parties.clone();
    }

    public Party(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        Iterator it = elem.getChildElements();
        Name name = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            elem = (SOAPElement)subElement;
            name = elem.getElementName();
            if (this.compare(name, EBXML_PARTY_ID)) {
                PartyId temp = new PartyId(elem, env);
                if (temp.getValue() == null || temp.getValue().trim().length() == 0) continue;
                this._partyId.put(temp.getType(), temp.getValue());
                continue;
            }
            if (!this.compare(name, EBXML_ROLE)) continue;
            this._role = elem.getValue();
        }
    }

    public String getRole() {
        return this._role;
    }

    public void setRole(String role) {
        this._role = role;
    }

    public HashMap<String, String> getPartyIds() {
        return this._partyId;
    }

    public void addPartyId(PartyId partyId) {
        this._partyId.put(partyId.getType(), partyId.getValue());
    }

    public void addPartyId(String partyId, String partyIdType) {
        this._partyId.put(partyIdType, partyId);
    }

    public void removePartyId(PartyId partyId) {
        this._partyId.remove(partyId.getType());
    }

    public void generateSOAP(SOAPElement element, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        Set<String> keys = this._partyId.keySet();
        for (String key : keys) {
            String partyIdValue = this._partyId.get(key);
            if (partyIdValue != null && partyIdValue.trim().length() == 0) continue;
            name = envelope.createName(EBXML_PARTY_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebPartyId = element.addChildElement(name);
            PartyId partyId = new PartyId(partyIdValue, key);
            partyId.generateSOAP(ebPartyId, envelope);
        }
        if (this._role != null) {
            name = envelope.createName(EBXML_ROLE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebRole = element.addChildElement(name);
            ebRole.addTextNode(this._role);
        }
    }

    protected final boolean compare(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase("http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
    }
}

