/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.body;

import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.body.BodyExtension;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class StatusResponse
extends BodyExtension {
    private String _refToMessageId;
    public static final String EBXML_REF_TO_MESSAGE_ID = "RefToMessageId";
    private Date _timestamp;
    public static final String EBXML_TIMESTAMP = "Timestamp";
    private String _messageStatus;
    public static final String EBXML_MESSAGE_STATUS = "messageStatus";
    public static final String EBXML_MESSAGE_STATUS_UNAUTHORIZED = "UnAuthorized";
    public static final String EBXML_MESSAGE_STATUS_NOT_RECOGNIZED = "NotRecognized";
    public static final String EBXML_MESSAGE_STATUS_RECEIVED = "Received";
    public static final String EBXML_MESSAGE_STATUS_PROCESSED = "Processed";
    public static final String EBXML_MESSAGE_STATUS_FORWARDED = "Forwarded";

    public StatusResponse(String refToMessageId, String status, Date timestamp) {
        this._refToMessageId = refToMessageId;
        this._messageStatus = status;
        this._timestamp = timestamp;
    }

    public StatusResponse(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Name name = env.createName(EBXML_MESSAGE_STATUS, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        this._messageStatus = elem.getAttributeValue(name);
        Iterator it = elem.getChildElements();
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            elem = (SOAPElement)subElement;
            name = elem.getElementName();
            if (this.compare(name, EBXML_REF_TO_MESSAGE_ID)) {
                this._refToMessageId = elem.getValue();
                continue;
            }
            if (!this.compare(name, EBXML_TIMESTAMP)) continue;
            try {
                this._timestamp = DateTime.parseDate(elem.getValue());
            }
            catch (ParseException e) {
                throw new SOAPException("Timestamp Element in StatusResponse has an invalid format:" + String.valueOf(e));
            }
        }
    }

    public String getRefToMessageId() {
        return this._refToMessageId;
    }

    public void setRefToMessageId(String refToMessageId) {
        this._refToMessageId = refToMessageId;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    public String getMessageStatus() {
        return this._messageStatus;
    }

    public void setMessageStatus(String messageStatus) {
        this._messageStatus = messageStatus;
    }

    public void generateSOAP(SOAPBodyElement ebBody, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebBody.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebBody.addAttribute(name, this.getVersion());
        name = envelope.createName(EBXML_MESSAGE_STATUS, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebBody.addAttribute(name, this._messageStatus);
        name = envelope.createName(EBXML_REF_TO_MESSAGE_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebRefTo = ebBody.addChildElement(name);
        ebRefTo.addTextNode(this._refToMessageId);
        if (this._timestamp != null) {
            name = envelope.createName(EBXML_TIMESTAMP, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebTimestamp = ebBody.addChildElement(name);
            ebTimestamp.addTextNode(DateTime.formatDate(this._timestamp));
        }
    }

    public void validate() throws EbXmlException {
        if (this._refToMessageId == null) {
            throw new EbXmlException(30044, "Error", "OtherXml", "StatusResponse must contain RefToMessageId Element");
        }
    }
}

