/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.server;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.server.ILoggingSystem;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

public class LoggingSystem
implements ILoggingSystem {
    private static final String LOG4J_CATEGORY_TEST_ADAPTER = "TestAdapter";
    private static final String LOG4J_CATEGORY_HOTFOLDER = "HotFolder";
    private static final String LOG4J_CATEGORY_HTTP_ADAPTER = "de.ponton.xmlpipe.httpadapter";
    private static final String LOG4J_CATEGORY_JDBC = "JDBC";
    private static final String LOG4J_CATEGORY_LISTENER = "Listener";
    private static final String LOG4J_CATEGORY_MESSENGER = "Messenger";
    private static final String LOG4J_CATEGORY_Audit = "Audit";
    private static final String LOG4J_CATEGORY_HIBERNATE_SQL = "org.hibernate.SQL";
    private static final String LOG4J_CATEGORY_HIBERNATE_SQL_JDBC_EXTRACT = "org.hibernate.orm.jdbc.extract";
    private final IServerConfigBean serverConfig;
    private final File logFolder;

    public LoggingSystem(IServerConfigBean serverConfig) throws IOException {
        this.serverConfig = serverConfig;
        this.logFolder = serverConfig.getRealFile(serverConfig.getLogFolder()).getCanonicalFile();
        if (!this.logFolder.exists()) {
            this.logFolder.mkdirs();
        }
        System.setProperty("LOG_FOLDER", this.logFolder.getCanonicalPath());
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        loggerContext.reconfigure();
        this.updateLogConfig();
        Logger log = LogManager.getLogger((String)LOG4J_CATEGORY_MESSENGER);
        log.info("****************************************************************************");
        log.info("Messenger V" + Constants.getXP_VERSION() + " Init started");
    }

    @Override
    public void updateLogConfig() {
        Configurator.setLevel((String)LOG4J_CATEGORY_MESSENGER, (Level)Level.valueOf((String)this.serverConfig.getMessengerLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_JDBC, (Level)Level.valueOf((String)this.serverConfig.getJDBCLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_TEST_ADAPTER, (Level)Level.valueOf((String)this.serverConfig.getMessengerLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_HOTFOLDER, (Level)Level.valueOf((String)this.serverConfig.getMessengerLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_HTTP_ADAPTER, (Level)Level.valueOf((String)this.serverConfig.getMessengerLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_LISTENER, (Level)Level.valueOf((String)this.serverConfig.getMessengerLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_Audit, (Level)Level.INFO);
        Configurator.setLevel((String)LOG4J_CATEGORY_HIBERNATE_SQL, (Level)Level.valueOf((String)this.serverConfig.getJDBCLogLevel()));
        Configurator.setLevel((String)LOG4J_CATEGORY_HIBERNATE_SQL_JDBC_EXTRACT, (Level)Level.valueOf((String)this.serverConfig.getJDBCLogLevel()));
    }

    @Override
    public File getLogFolder() {
        return this.logFolder;
    }
}

