/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.server;

import de.ponton.application.update.api.SystemOutLogger;
import de.ponton.application.update.applicationpart.PatchProcessor;
import de.pontonconsulting.xmlpipe.config.AddOn;
import de.pontonconsulting.xmlpipe.config.AddOnInfoReader;
import de.pontonconsulting.xmlpipe.server.Startup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class ApplicationUpdater {
    private static final SystemOutLogger SYSTEM_OUT_LOG = new SystemOutLogger(Startup.class);
    private static final String UPDATE_FOLDERNAME = "update";
    private static final String PATCH_FILENAME = "patch.jar";
    private static final String PONTONCA_CERT = "pontonca.cer";
    private static final String XP_ROOT_CA = "XPRootCA-chain.pem";
    private static final String APP_ID = "PONTON_XP";
    private static final String API_VERSION = "3.7.0";
    private static final String CONFIG_VERSION = "3.7.0";
    private final AddOnInfoReader addOnInfoReader;

    public ApplicationUpdater(AddOnInfoReader addOnInfoReader) {
        this.addOnInfoReader = addOnInfoReader;
    }

    void execute() {
        try {
            String currentAppVersion;
            List<X509Certificate> certList;
            File updateFolder;
            try {
                updateFolder = this.determineUpdateFolder();
            }
            catch (URISyntaxException e) {
                SYSTEM_OUT_LOG.logError("Could not determine the update folder: " + e.toString());
                return;
            }
            try {
                certList = this.getRootCAs();
            }
            catch (IOException | CertificateException e) {
                SYSTEM_OUT_LOG.logError("Could not get Root CA Certificate: " + e.toString());
                return;
            }
            try {
                currentAppVersion = this.determineCurrentAppVersion();
            }
            catch (Exception e) {
                SYSTEM_OUT_LOG.logError("Could not determine Application Version: " + e.toString());
                return;
            }
            PatchProcessor patchProcessor = new PatchProcessor(updateFolder, PATCH_FILENAME, certList, APP_ID, currentAppVersion, "3.7.0", "3.7.0", this.getInstalledAddOns());
            patchProcessor.execute();
        }
        catch (Exception e) {
            SYSTEM_OUT_LOG.logError("Could not check for update. " + String.valueOf(e));
            e.printStackTrace(System.err);
        }
    }

    private Map<String, String> getInstalledAddOns() {
        List<AddOn> addOns = this.addOnInfoReader.getAddOnInfos();
        HashMap<String, String> installedAddOns = new HashMap<String, String>(addOns.size());
        for (AddOn addOn : addOns) {
            installedAddOns.put(addOn.getName(), addOn.getVersion());
            SYSTEM_OUT_LOG.logInfo(String.format("Found installed addon (id: %s, version: %s)", addOn.getName(), addOn.getVersion()));
        }
        return installedAddOns;
    }

    private String determineCurrentAppVersion() throws Exception {
        Properties properties = new Properties();
        URL mesengerVersionUrl = Startup.class.getClassLoader().getResource("ponton-messenger-version.properties");
        if (mesengerVersionUrl == null) {
            throw new FileNotFoundException("Could not find resource 'ponton-messenger-version.properties' in classpath.");
        }
        try (InputStream inputStream = mesengerVersionUrl.openStream();){
            properties.load(inputStream);
            String version = properties.getProperty("ponton.version");
            Objects.requireNonNull(version, "No version property found.");
            String string = version;
            return string;
        }
    }

    private List<X509Certificate> getRootCAs() throws IOException, CertificateException {
        ArrayList<X509Certificate> rootCAs = new ArrayList<X509Certificate>();
        for (String ca : new String[]{PONTONCA_CERT, XP_ROOT_CA}) {
            URL rootCaUrl = Startup.class.getClassLoader().getResource(ca);
            if (rootCaUrl == null) {
                throw new FileNotFoundException("Could not find resource '" + ca + "' in classpath.");
            }
            try (InputStream inputStream = rootCaUrl.openStream();){
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                rootCAs.add(certificate);
            }
        }
        return rootCAs;
    }

    private File determineUpdateFolder() throws URISyntaxException {
        URL jarUrl = Startup.class.getProtectionDomain().getCodeSource().getLocation();
        Path path = Paths.get(jarUrl.toURI());
        File jarFile = path.toFile();
        File appHome = jarFile.isFile() ? jarFile.getParentFile().getParentFile() : jarFile.getParentFile();
        return new File(appHome, UPDATE_FOLDERNAME);
    }
}

