/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.smime;

import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEHandler;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;

public class SMIMESigner
extends SMIMEHandler {
    private static final String BASE64 = "base64";

    public SMIMESigner() {
        this.initiate();
    }

    public MimeMultipart createSignedMimeMessage(MimeBodyPart mimeBody, Session session, PrivateKey privateKey, Certificate[] signerCertificateChain, String signatureAlgorithm) throws CertificateEncodingException, OperatorCreationException, IOException, SMIMEException {
        return this.createSignedMimeMessage(mimeBody, session, privateKey, signerCertificateChain, signatureAlgorithm, BASE64);
    }

    public MimeMultipart createSignedMimeMessage(MimeBodyPart mimeBody, Session session, PrivateKey privateKey, Certificate[] signerCertificateChain, String signatureAlgorithm, String contentTransferEncoding) throws CertificateEncodingException, OperatorCreationException, IOException, SMIMEException {
        SMIMESignedGenerator signerGen = CryptoUtil.createSMIMESignedGenerator(privateKey, (X509Certificate)signerCertificateChain[0], signatureAlgorithm, contentTransferEncoding);
        MimeMultipart mp = signerGen.generate(mimeBody);
        return mp;
    }
}

