/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.ldap;

import java.net.URI;
import java.net.URISyntaxException;

public class LdapServer {
    public static final String LDAPS = "ldaps";
    public static final String LDAP = "ldap";
    private final String host;
    private final int port;
    private final String name;
    private final String url;
    private final String baseDN;
    private final boolean enabled;
    private long timeout;

    public LdapServer(String name, String url, String baseDN, boolean enabled, long timeout) throws URISyntaxException {
        this.name = name;
        this.url = url;
        this.baseDN = baseDN;
        this.enabled = enabled;
        URI uri = new URI(url);
        this.host = uri.getHost();
        if (uri.getScheme() == null || !LDAP.equalsIgnoreCase(uri.getScheme()) && !LDAPS.equalsIgnoreCase(uri.getScheme())) {
            throw new URISyntaxException(url, "unknown scheme defined " + uri.getScheme());
        }
        this.port = uri.getPort() != -1 ? uri.getPort() : (LDAPS.equalsIgnoreCase(uri.getScheme()) ? 636 : 389);
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getTimeoutInMilliseconds() {
        return this.timeout;
    }

    public String toString() {
        return "LdapServer{host='%s', port=%d, name='%s', url='%s', baseDN='%s', enabled=%s}".formatted(this.host, this.port, this.name, this.url, this.baseDN, this.enabled);
    }
}

