/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.ldap;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.ldap.sdk.PruneUnneededConnectionsLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.security.ldap.LdapProxySocketFactory;
import de.pontonconsulting.xmlpipe.security.ldap.LdapSSLSocketFactory;
import de.pontonconsulting.xmlpipe.security.ldap.LdapServer;
import de.pontonconsulting.xmlpipe.security.ldap.ProxyNameResolver;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapConnectionPool {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + LdapConnectionPool.class.getName()));
    private final CertificateFactory certificateFactory;
    private final LdapSSLSocketFactory ldapSSLSocketFactory;
    private final MessengerConfig messengerConfig;
    private final Map<String, LDAPConnectionPool> ldapPools = new ConcurrentHashMap<String, LDAPConnectionPool>();
    private static final String DEFAULT_CN = "*.EMT.MAK*";
    private static final int LDAP_PAGE_SIZE = 9;

    public LdapConnectionPool(LdapSSLSocketFactory ldapSSLSocketFactory, MessengerConfig messengerConfig) throws CertificateException, NoSuchProviderException {
        this.certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        this.ldapSSLSocketFactory = ldapSSLSocketFactory;
        this.messengerConfig = messengerConfig;
    }

    public Collection<X509Certificate> getCertificates(LdapServer server, String ou) throws JAXBException {
        return this.getCertificates(server, ou, DEFAULT_CN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509Certificate> getCertificates(LdapServer server, String ou, String cn) throws JAXBException {
        ArrayList<X509Certificate> foundCertificates = new ArrayList<X509Certificate>();
        LOG.trace("connect to {} {}", (Object)server.getName(), (Object)server.getUrl());
        long start = System.currentTimeMillis();
        LDAPConnectionPool pool = this.ldapPools.get(server.getHost());
        if (pool == null) {
            try {
                LDAPConnection ldapConnection = this.getLdapConnection(server);
                pool = new LDAPConnectionPool(ldapConnection, 1, 5);
                pool.setCreateIfNecessary(true);
                pool.setConnectionPoolName(server.getName());
                pool.setHealthCheckIntervalMillis(TimeUnit.MINUTES.toMillis(1L));
                pool.setHealthCheck((LDAPConnectionPoolHealthCheck)new PruneUnneededConnectionsLDAPConnectionPoolHealthCheck(0, TimeUnit.MINUTES.toMillis(2L)));
                pool.setMaxConnectionAgeMillis(TimeUnit.MINUTES.toMillis(2L));
                this.ldapPools.put(server.getHost(), pool);
            }
            catch (LDAPException e) {
                LOG.error("could not create a connection pool for {} error: {}", (Object)server.getHost(), (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
        LDAPConnection connection = null;
        try {
            boolean moreResults;
            RootDSE rootDSE;
            connection = pool.getConnection();
            if (LOG.isTraceEnabled() && (rootDSE = connection.getRootDSE()) != null) {
                for (int i = 0; i < rootDSE.getNamingContextDNs().length; ++i) {
                    LOG.trace("RootDSE of {}: {}", (Object)server.getName(), (Object)rootDSE.getNamingContextDNs()[i]);
                }
            }
            StringBuilder filter = new StringBuilder();
            filter.append("(&(usercertificate;binary=*)");
            if (Objects.nonNull(ou)) {
                filter.append("(ou=").append(ou).append(")");
            }
            if (Objects.nonNull(cn)) {
                filter.append("(cn=").append(cn).append(")");
            }
            filter.append(")");
            SearchRequest searchRequest = new SearchRequest(server.getBaseDN(), SearchScope.SUB, Filter.create((String)filter.toString()), new String[0]);
            searchRequest.setControls(new Control[]{new SimplePagedResultsControl(9, null)});
            do {
                SearchResult searchResult = connection.search(searchRequest);
                this.addValidCertificatesFromEntryToList(searchResult, foundCertificates, ou, cn);
                SimplePagedResultsControl responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
                moreResults = responseControl.moreResultsToReturn();
                if (!moreResults) continue;
                LOG.info("Found {} certificates. Start search on next page", (Object)searchResult.getEntryCount());
                searchRequest.setControls(new Control[]{new SimplePagedResultsControl(9, responseControl.getCookie())});
            } while (moreResults);
        }
        catch (LDAPException e) {
            LOG.error("LDAP search [ou={} / cn={}] failed: {}", (Object)ou, (Object)cn, (Object)e.getExceptionMessage(true, false));
            pool.releaseDefunctConnection(connection);
        }
        finally {
            pool.releaseConnection(connection);
        }
        long end = System.currentTimeMillis();
        LOG.trace("lookup time on {} [ou={} / cn={}]: {}ms ", (Object)server.getName(), (Object)ou, (Object)cn, (Object)(end - start));
        return foundCertificates;
    }

    private LDAPConnection getLdapConnection(LdapServer server) throws JAXBException, LDAPException {
        return this.getLdapConnection(server.getHost(), server.getPort(), true);
    }

    private LDAPConnection getLdapConnection(String host, int port, boolean tlsConnection) throws JAXBException, LDAPException {
        LDAPConnection ldapConnection;
        LdapSSLSocketFactory sslSocketFactory;
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        if (tlsConnection) {
            sslSocketFactory = this.ldapSSLSocketFactory;
            connectionOptions.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
        } else {
            sslSocketFactory = null;
        }
        String proxyHost = this.messengerConfig.getLdapProxyHost();
        if (proxyHost != null && !proxyHost.trim().isEmpty()) {
            int proxyPort = this.messengerConfig.getLdapProxyPort();
            LOG.trace("Ldap over proxy with host {} and port {}", (Object)proxyHost, (Object)proxyPort);
            connectionOptions.setNameResolver((NameResolver)new ProxyNameResolver());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            LdapProxySocketFactory ldapProxySocketFactory = new LdapProxySocketFactory(proxy, 10000, sslSocketFactory);
            ldapConnection = new LDAPConnection((SocketFactory)ldapProxySocketFactory, connectionOptions, host, port);
        } else {
            ldapConnection = new LDAPConnection((SocketFactory)sslSocketFactory, connectionOptions, host, port);
        }
        return ldapConnection;
    }

    private void addValidCertificatesFromEntryToList(SearchResult searchResult, Collection<X509Certificate> certificateList, String ou, String cn) {
        for (SearchResultEntry resultEntry : searchResult.getSearchEntries()) {
            byte[][] certificates = resultEntry.getAttributeValueByteArrays("usercertificate;binary");
            if (certificates == null) continue;
            for (byte[] bytes : certificates) {
                try {
                    X509Certificate certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                    certificate.checkValidity();
                    certificateList.add(certificate);
                    LOG.debug("Found valid certificate with subject distinguished name {} and serial no {}", (Object)certificate.getSubjectX500Principal(), (Object)certificate.getSerialNumber());
                }
                catch (CertificateException ex) {
                    LOG.warn("ignoring invalid certificate [ou={} / cn={}]: {}", (Object)ou, (Object)cn, (Object)ex.getMessage());
                }
            }
        }
    }

    public X509CRL getX509CRL(String URL2) throws CRLException, LDAPException, JAXBException {
        X509CRL x509CRL;
        block9: {
            LDAPURL url = new LDAPURL(URL2);
            String dn = url.getBaseDN().toString();
            LDAPConnection connection = this.getLdapConnection(url.getHost(), url.getPort(), url.getScheme().equalsIgnoreCase("ldaps"));
            try {
                SearchResultEntry searchEntry = connection.getEntry(dn, new String[]{"certificateRevocationList;binary"});
                if (searchEntry == null) {
                    throw new CRLException("CRL not found on server: " + URL2);
                }
                ByteArrayInputStream inStream = new ByteArrayInputStream(searchEntry.getAttributeValueBytes("certificateRevocationList;binary"));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                x509CRL = (X509CRL)cf.generateCRL(inStream);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CertificateException e) {
                    throw new CRLException(e.getMessage(), e);
                }
            }
            connection.close();
        }
        return x509CRL;
    }

    public void resetConnections() {
        for (LDAPConnectionPool pool : this.ldapPools.values()) {
            pool.close();
        }
        this.ldapPools.clear();
    }
}

