/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.security.acegi.UserCredentialsExpiredException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;

public class PostAuthenticationChecks
implements UserDetailsChecker {
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + PostAuthenticationChecks.class.getName()));

    public void check(UserDetails user) {
        if (!user.isCredentialsNonExpired()) {
            AUDIT.info("{'{}', '{}' -> '{}'} Login failed: Password is expired (expiration time: '{}').", (Object)user.getUsername(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)((MessengerUser)user).getExpiration());
            throw new UserCredentialsExpiredException("User credentials have expired", user);
        }
    }
}

