/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEventNotifier;
import de.pontonconsulting.xmlpipe.security.acegi.BruteForceLoginAttackModel;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureCredentialsExpiredEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationEvents {
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + AuthenticationEvents.class.getName()));
    private static final int THRESHOLD = 100;
    private static final int THRESHOLD_TIME = 30000;
    private final PontonUserDetailsServiceImpl userDetailsService;
    private final IServerConfigBean serverConfig;
    private final SystemEventNotifier systemEventNotifier;
    private final ReferenceDateTask referenceDateTask;
    private final ReentrantLock lock = new ReentrantLock();
    private BruteForceLoginAttackModel bruteForceLoginAttackModel;

    public AuthenticationEvents(PontonUserDetailsServiceImpl userDetailsService, IServerConfigBean serverConfig, SystemEventNotifier systemEventNotifier, ReferenceDateTask referenceDateTask) {
        this.userDetailsService = userDetailsService;
        this.serverConfig = serverConfig;
        this.systemEventNotifier = systemEventNotifier;
        this.referenceDateTask = referenceDateTask;
    }

    @EventListener
    public void onSuccess(AuthenticationSuccessEvent success) {
        Authentication authentication = success.getAuthentication();
        MessengerUser principal = (MessengerUser)authentication.getPrincipal();
        principal.resetFailedAttemptCount();
        this.userDetailsService.save(principal);
        AUDIT.info("{'{}', '{}' -> '{}'} user successfully logged in.", (Object)principal.getUsername(), (Object)this.getRemoteAddress((AbstractAuthenticationEvent)success), (Object)RequestUtils.getLocalAddress());
    }

    @EventListener
    public void onFailure(AbstractAuthenticationFailureEvent failures) {
        Authentication authentication = failures.getAuthentication();
        String principal = Objects.isNull(authentication.getPrincipal()) ? null : authentication.getPrincipal().toString();
        MessengerUser user = null;
        if (StringUtils.isNotBlank((CharSequence)principal)) {
            try {
                user = this.userDetailsService.loadUserByUsername(principal);
            }
            catch (Exception ex) {
                AUDIT.info("{'{}', '{}' -> '{}'} Login failed: Unknown user tried to log in.", (Object)principal, (Object)this.getRemoteAddress((AbstractAuthenticationEvent)failures), (Object)RequestUtils.getLocalAddress());
                this.checkForBruteForceLoginAttack();
            }
        }
        AbstractAuthenticationFailureEvent abstractAuthenticationFailureEvent = failures;
        Objects.requireNonNull(abstractAuthenticationFailureEvent);
        AbstractAuthenticationFailureEvent abstractAuthenticationFailureEvent2 = abstractAuthenticationFailureEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationFailureBadCredentialsEvent.class, AuthenticationFailureLockedEvent.class, AuthenticationFailureCredentialsExpiredEvent.class}, (Object)abstractAuthenticationFailureEvent2, n)) {
            case 0: {
                AuthenticationFailureBadCredentialsEvent authenticationFailureBadCredentialsEvent = (AuthenticationFailureBadCredentialsEvent)abstractAuthenticationFailureEvent2;
                if (!StringUtils.isNotBlank((CharSequence)principal) || user == null) break;
                user.increaseFailedAttemptCount();
                this.userDetailsService.save(user);
                if (user.getFailedLoginAttempts() >= this.serverConfig.getMaxFailedLoginAttempts()) {
                    user.setLockedUntil(this.referenceDateTask.getReferenceOffsetDateTime().plusMinutes(this.serverConfig.getUserAccountLockDuration()));
                    this.userDetailsService.save(user);
                    AUDIT.info("{'{}', '{}' -> '{}'} Login failed: Password was incorrect (attempts: {}). User is locked until '{}'", (Object)user.getUsername(), (Object)this.getRemoteAddress((AbstractAuthenticationEvent)failures), (Object)RequestUtils.getLocalAddress(), (Object)user.getFailedLoginAttempts(), (Object)user.getLockedUntil());
                    this.checkForBruteForceLoginAttack();
                    break;
                }
                AUDIT.info("{'{}', '{}' -> '{}'} Login failed: Password was incorrect (attempts: {}).", (Object)user.getUsername(), (Object)this.getRemoteAddress((AbstractAuthenticationEvent)failures), (Object)RequestUtils.getLocalAddress(), (Object)user.getFailedLoginAttempts());
                this.checkForBruteForceLoginAttack();
                break;
            }
            case 1: {
                AuthenticationFailureLockedEvent authenticationFailureLockedEvent = (AuthenticationFailureLockedEvent)abstractAuthenticationFailureEvent2;
                if (!StringUtils.isNotBlank((CharSequence)principal) || user == null) break;
                AUDIT.info("{'{}', '{}' -> '{}'} Login failed: User is locked until '{}'", (Object)user.getUsername(), (Object)this.getRemoteAddress((AbstractAuthenticationEvent)failures), (Object)RequestUtils.getLocalAddress(), (Object)user.getLockedUntil());
                this.checkForBruteForceLoginAttack();
                break;
            }
            case 2: {
                AuthenticationFailureCredentialsExpiredEvent authenticationFailureCredentialsExpiredEvent = (AuthenticationFailureCredentialsExpiredEvent)abstractAuthenticationFailureEvent2;
                if (!StringUtils.isNotBlank((CharSequence)principal) || user == null) break;
                AUDIT.info("{'{}', '{}' -> '{}'} Login failed: Password is expired (expiration time: '{}').", (Object)user.getUsername(), (Object)this.getRemoteAddress((AbstractAuthenticationEvent)failures), (Object)RequestUtils.getLocalAddress(), (Object)user.getExpiration());
                this.checkForBruteForceLoginAttack();
                break;
            }
        }
    }

    private String getRemoteAddress(AbstractAuthenticationEvent authenticationEvent) {
        Object details;
        String remoteAddress = RequestUtils.getRemoteAddress();
        if (!"[unknown]".equals(remoteAddress)) {
            return remoteAddress;
        }
        Object source = authenticationEvent.getSource();
        if (source instanceof UsernamePasswordAuthenticationToken && (details = ((UsernamePasswordAuthenticationToken)source).getDetails()) instanceof WebAuthenticationDetails) {
            return ((WebAuthenticationDetails)details).getRemoteAddress();
        }
        return remoteAddress;
    }

    private void checkForBruteForceLoginAttack() {
        this.lock.lock();
        try {
            if (this.bruteForceLoginAttackModel == null || this.isThresholdTimeExceeded()) {
                this.bruteForceLoginAttackModel = new BruteForceLoginAttackModel();
            } else {
                this.bruteForceLoginAttackModel.increaseCounter();
                if (this.bruteForceLoginAttackModel.getCounter() >= 100) {
                    this.sendNotification();
                    this.bruteForceLoginAttackModel = new BruteForceLoginAttackModel();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isThresholdTimeExceeded() {
        return this.referenceDateTask.getReferenceDate().after(new Date(this.bruteForceLoginAttackModel.getStartTime().getTime() + 30000L));
    }

    private void sendNotification() {
        AUDIT.info("Sending email notification for BRUTE_FORCE_LOGIN_ATTACK.");
        this.systemEventNotifier.sendNotification(SystemEvent.BRUTE_FORCE_LOGIN_ATTACK, "The messenger has detected potential brute force login attack.\nFor details please see the audit log file.");
    }
}

