/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class SignatureVerifier {
    public static final String PKCS7 = "pkcs7";
    public static final String SMIME = "smime";
    private final File _payloadFile;
    private final File _signatureFile;
    private Signature _signature;
    private final X509Certificate _cert;
    private final PublicKey _publicKey;
    private final boolean _smime;
    private final boolean _pkcs7;
    private final SMIMEVerifier _smimeVerifier;

    public SignatureVerifier(SMIMEVerifier smimeVerifier, File payloadFile, File signatureFile, File certFile, String signatureAlgorithm) throws SecurityException {
        this._smimeVerifier = smimeVerifier;
        this._payloadFile = payloadFile;
        this._signatureFile = signatureFile;
        this._signature = null;
        CertificateFactory certFactory = null;
        this._smime = SMIME.equals(signatureAlgorithm);
        this._pkcs7 = PKCS7.equals(signatureAlgorithm);
        try {
            if (!this._smime && !this._pkcs7) {
                this._signature = Signature.getInstance(signatureAlgorithm, "BC");
            }
            certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SecurityException(41001, "Signature algorithm not found.", nsae);
        }
        catch (CertificateException ce) {
            throw new SecurityException(41002, (Throwable)ce);
        }
        catch (NoSuchProviderException nspe) {
            throw new SecurityException(41002, (Throwable)nspe);
        }
        try (BufferedInputStream in = new BufferedInputStream((InputStream)new TFileInputStream(certFile));){
            this._cert = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (IOException ioe) {
            throw new SecurityException(41003, (Throwable)ioe);
        }
        catch (CertificateException ce) {
            throw new SecurityException(41003, (Throwable)ce);
        }
        finally {
            if (certFile instanceof TFile) {
                try {
                    this.unmountFile((TFile)certFile.getParentFile());
                }
                catch (FsSyncException e) {
                    throw new SecurityException(41003, (Throwable)e);
                }
            }
        }
        this._publicKey = this._cert.getPublicKey();
    }

    public X509Certificate getCertificate() {
        return this._cert;
    }

    public boolean verify() throws SecurityException {
        try {
            if (this._smime) {
                boolean bl = this.verifySmime();
                return bl;
            }
            if (this._pkcs7) {
                boolean bl = this.verifyPkcs7();
                return bl;
            }
            boolean bl = this.verifyRaw();
            return bl;
        }
        finally {
            if (this._payloadFile instanceof TFile) {
                try {
                    this.unmountFile((TFile)this._payloadFile.getParentFile());
                }
                catch (FsSyncException e) {
                    throw new SecurityException(41003, (Throwable)e);
                }
            }
        }
    }

    private boolean verifyPkcs7() throws SecurityException {
        boolean signatureIsOk = false;
        try (BufferedInputStream sigStream = new BufferedInputStream((InputStream)new TFileInputStream(this._signatureFile));
             BufferedInputStream dataStream = new BufferedInputStream((InputStream)new TFileInputStream(this._payloadFile));){
            CMSTypedStream cmsDataStream = new CMSTypedStream((InputStream)dataStream);
            CMSSignedDataParser sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), cmsDataStream, (InputStream)sigStream);
            sp.getSignedContent().drain();
            sp.getCertificates();
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                SignerId id = signer.getSID();
                if (!this._cert.getSerialNumber().equals(id.getSerialNumber())) continue;
                signatureIsOk = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(this._cert));
                break;
            }
        }
        catch (CMSException cms) {
            throw new SecurityException(41005, (Throwable)cms);
        }
        catch (IOException io) {
            throw new SecurityException(41004, (Throwable)io);
        }
        catch (Exception se) {
            throw new SecurityException(41005, (Throwable)se);
        }
        return signatureIsOk;
    }

    private boolean verifySmime() {
        try (TFileInputStream in = new TFileInputStream(this._signatureFile);){
            MimeMessage msg = new MimeMessage(null, (InputStream)in);
            this._smimeVerifier.verifySignature((MimePart)msg, this._cert);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean verifyRaw() throws SecurityException {
        if (this._publicKey != null) {
            try (TFileInputStream payloadIn = new TFileInputStream(this._payloadFile);){
                boolean bl;
                try (TFileInputStream sigIn = new TFileInputStream(this._signatureFile);){
                    this._signature.initVerify(this._publicKey);
                    int length = 0;
                    byte[] buffer = new byte[8192];
                    while ((length = payloadIn.read(buffer)) != -1) {
                        this._signature.update(buffer, 0, length);
                    }
                    ByteArrayOutputStream sigData = new ByteArrayOutputStream();
                    while ((length = sigIn.read(buffer)) != -1) {
                        sigData.write(buffer, 0, length);
                    }
                    if (!this._signature.verify(sigData.toByteArray())) {
                        throw new SecurityException(41005, "Signature is not valid.");
                    }
                    bl = true;
                }
                return bl;
            }
            catch (InvalidKeyException ike) {
                throw new SecurityException(41001, (Throwable)ike);
            }
            catch (IOException ioe) {
                throw new SecurityException(41004, (Throwable)ioe);
            }
            catch (SignatureException se) {
                throw new SecurityException(41005, (Throwable)se);
            }
        }
        return false;
    }

    private void unmountFile(TFile sourceFile) throws FsSyncException {
        if (sourceFile.isArchive()) {
            TVFS.umount((TFile)sourceFile);
        } else if (sourceFile.isDirectory()) {
            TFile[] files;
            for (TFile file : files = sourceFile.listFiles()) {
                if (!file.isArchive()) continue;
                TVFS.umount((TFile)file);
            }
        }
    }
}

