/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.security.CertificateReader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PontonKeystore {
    private static final String SUFFIX_CERT = ".cert";
    private static final String SUFFIX_SMIME = ".smime";
    private static final String SUFFIX_PRIVATE_KEY = ".key";
    public static final String ALIAS_MAIN_CA = "1.2.840.113549.1.9.1=#1619696e666f40706f6e746f6e2d636f6e73756c74696e672e6465,cn=ponton root ca,ou=network service,o=ponton consulting gmbh,l=hamburg,c=de";
    public static final String ALIAS_MAIN_CA_OLD = "oid.1.2.840.113549.1.9.1=info@ponton-consulting.de, cn=ponton root ca, ou=network service, o=ponton consulting gmbh, l=hamburg, c=de";
    public static final String ALIAS_ACTIVATION_CA = "xp.activation.ca";
    public static final String ALIAS_LICENSE_CA = "xp.license.ca";
    private static final String ALIAS_LICENSE = "xp.license";
    private static final String ALIAS_PRODUCT_PK = "xp.productkey";
    private static final String ALIAS_ACTIVATION = "xp.activation";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.Keystore");
    public static final String PKCS_12 = "PKCS12";
    private final Lock _readLockForKeyStore;
    private final Lock _writeLockForKeyStore;
    private final KeyStore _keystore;
    private final CertificateReader _certificate;
    private final HashMap<String, X509Certificate[]> _chainCache = new HashMap();
    private final Supplier<Date> dateSupplier;
    private final Consumer<byte[]> storeKeystore;
    private final String password;

    public PontonKeystore(byte[] bytes, String password, String keystoreType, CertificateReader certificate, Supplier<Date> dateSupplier, Consumer<byte[]> storeKeystore) throws GeneralSecurityException {
        this._certificate = certificate;
        this.dateSupplier = dateSupplier;
        this.storeKeystore = storeKeystore;
        ReentrantReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock();
        this._readLockForKeyStore = rwLockForKeyStore.readLock();
        this._writeLockForKeyStore = rwLockForKeyStore.writeLock();
        this.password = password;
        this._keystore = "JKS".equals(keystoreType) ? KeyStore.getInstance(keystoreType, "SUN") : KeyStore.getInstance(keystoreType, "BC");
        if (password == null || password.isEmpty()) {
            throw new KeyStoreException("Password for keystore required.");
        }
        if (bytes.length > 0) {
            this.loadKeystore(bytes, password, this._keystore);
        } else {
            try {
                this._keystore.load(null, password.toCharArray());
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this._keystore.store(byteArrayOutputStream, password.toCharArray());
                    storeKeystore.accept(byteArrayOutputStream.toByteArray());
                }
            }
            catch (Exception e) {
                KeyStoreException ke = new KeyStoreException(e.getMessage());
                ke.setStackTrace(e.getStackTrace());
                throw ke;
            }
        }
    }

    public PontonKeystore(byte[] bytes, String password, CertificateReader certificate, Supplier<Date> dateSupplier, Consumer<byte[]> storeKeystore) throws GeneralSecurityException {
        this(bytes, password, "JKS", certificate, dateSupplier, storeKeystore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration<X509Certificate> certificates() {
        this._readLockForKeyStore.lock();
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(this._keystore.size());
            Enumeration<String> aliases = this._keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this._keystore.isCertificateEntry(alias)) continue;
                certs.add((X509Certificate)this._keystore.getCertificate(alias));
            }
            Enumeration<X509Certificate> enumeration = Collections.enumeration(certs);
            return enumeration;
        }
        catch (KeyStoreException e) {
            Enumeration<X509Certificate> enumeration = Collections.enumeration(new ArrayList());
            return enumeration;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration<String> certificatesIds() {
        this._readLockForKeyStore.lock();
        try {
            ArrayList<String> certs = new ArrayList<String>(this._keystore.size());
            Enumeration<String> aliases = this._keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this._keystore.isCertificateEntry(alias)) continue;
                certs.add(alias);
            }
            Enumeration<String> enumeration = Collections.enumeration(certs);
            return enumeration;
        }
        catch (KeyStoreException e) {
            Enumeration<String> enumeration = Collections.enumeration(new ArrayList());
            return enumeration;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public Enumeration<String> caCertificateIds() {
        ArrayList<String> caIds = new ArrayList<String>();
        Enumeration<String> certIds = this.certificatesIds();
        while (certIds.hasMoreElements()) {
            String certId = certIds.nextElement();
            if (certId.endsWith(SUFFIX_CERT) || certId.endsWith(SUFFIX_SMIME) || certId.endsWith(SUFFIX_PRIVATE_KEY) || certId.startsWith(ALIAS_ACTIVATION) || certId.startsWith(ALIAS_LICENSE) || certId.equals(ALIAS_ACTIVATION_CA) || certId.equals(ALIAS_LICENSE_CA)) continue;
            caIds.add(certId);
        }
        return Collections.enumeration(caIds);
    }

    public X509Certificate getCertificate(String localId) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Getting certificate for localId '{}'", (Object)localId);
        }
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(this.buildAliasForCertificate(localId));
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate getSMIMECertificate(String email) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Getting SMIME certificate for '{}'", (Object)email);
        }
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(this.buildAliasForSMIME(email));
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate getCA(String id) throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(id);
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getPrivateKey(String localId, char[] password) throws GeneralSecurityException {
        if (_log.isTraceEnabled()) {
            _log.trace("Getting private key for localId '{}'", (Object)localId);
        }
        String id = this.buildAliasForPrivateKey(localId);
        this._readLockForKeyStore.lock();
        try {
            PrivateKey privateKey = (PrivateKey)this._keystore.getKey(id, password);
            return privateKey;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate[] getCertificateChainForPrivateKey(String localId) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Getting certificate chain of private key for localId '{}'", (Object)localId);
        }
        return this.getCertificateChainForKey(this.buildAliasForPrivateKey(localId));
    }

    private X509Certificate[] getCertificateChainForKey(String keyAlias) throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            Certificate[] chain = this._keystore.getCertificateChain(keyAlias);
            if (chain == null || chain.length < 1) {
                throw new KeyStoreException("No certificate chain found for '" + keyAlias + "'.");
            }
            try {
                X509Certificate[] x509CertificateArray = this.getCertificateChain((X509Certificate)chain[0]);
                return x509CertificateArray;
            }
            catch (CertificateException e) {
                throw new KeyStoreException("invalid certificate chain for '" + keyAlias + "'.", e);
            }
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public String addCA(X509Certificate caCert) throws KeyStoreException, CertificateException {
        try {
            this.checkCertificate(caCert);
        }
        catch (GeneralSecurityException e) {
            CertificateException ce = new CertificateException(e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        String alias = this.buildAliasForCA(caCert);
        if (_log.isTraceEnabled()) {
            _log.trace("Adding ca certificate '{}'", (Object)alias);
        }
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.setCertificateEntry(alias, caCert);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
            this._chainCache.clear();
        }
        catch (Exception e) {
            this._keystore.deleteEntry(alias);
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
        return alias;
    }

    public String addNewCA(X509Certificate caCert) throws KeyStoreException, CertificateException {
        X509Certificate ca;
        String alias = this.buildAliasForCA(caCert);
        if (_log.isTraceEnabled()) {
            _log.trace("Adding ca certificate '{}'", (Object)alias);
        }
        if ((ca = this.getCA(alias)) == null) {
            return this.addCA(caCert);
        }
        return alias;
    }

    void addCertificate(String localId, X509Certificate cert) throws KeyStoreException, CertificateException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding certificate for localId '{}'", (Object)localId);
        }
        String alias = this.buildAliasForCertificate(localId);
        this.addCertificateWithAlias(alias, cert);
    }

    public void addLicenseCert(X509Certificate cert) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding license certificate.");
        }
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.setCertificateEntry(ALIAS_LICENSE, cert);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            this._keystore.deleteEntry(ALIAS_LICENSE);
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    public void addInstanceActivationCert(X509Certificate cert, String instance) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding activation certificate.");
        }
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.setCertificateEntry("xp.activation_" + instance, cert);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            this._keystore.deleteEntry("xp.activation_" + instance);
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    public void deleteLicenseCert() throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Deleting license certificate,");
        }
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.deleteEntry(ALIAS_LICENSE);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    public X509Certificate getLicenseCert() throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(ALIAS_LICENSE);
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate getLicenseCA() throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(ALIAS_LICENSE_CA);
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate getActivationCert() throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate(ALIAS_ACTIVATION);
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public X509Certificate getInstanceActivationCert(String instance) throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this._keystore.getCertificate("xp.activation_" + instance);
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public boolean containsLegacyProductKey() throws KeyStoreException {
        return this._keystore.containsAlias(ALIAS_PRODUCT_PK);
    }

    @Deprecated
    public void addProductKey(PrivateKey pk, char[] password, X509Certificate cert) throws KeyStoreException, CertificateException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding product key.");
        }
        this.storePrivateKey(pk, password, cert, ALIAS_PRODUCT_PK);
    }

    public void addInstanceProductKey(PrivateKey pk, char[] password, String instance, X509Certificate cert) throws KeyStoreException, CertificateException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding product key for instance {}", (Object)instance);
        }
        this.storePrivateKey(pk, password, cert, "xp.productkey_" + instance);
    }

    @Deprecated
    public PrivateKey getProductKey(char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this._readLockForKeyStore.lock();
        try {
            PrivateKey privateKey = (PrivateKey)this._keystore.getKey(ALIAS_PRODUCT_PK, password);
            return privateKey;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    public void deleteLegacyProductKey() throws KeyStoreException {
        this.deleteEntry(ALIAS_PRODUCT_PK);
    }

    public void deleteInstanceProductKey(String instance) throws KeyStoreException {
        this.deleteEntry("xp.productkey_" + instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getInstanceProductKey(char[] password, String instance) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this._readLockForKeyStore.lock();
        try {
            PrivateKey privateKey = (PrivateKey)this._keystore.getKey("xp.productkey_" + instance, password);
            return privateKey;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    @Deprecated
    public X509Certificate getProductCert() throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            Certificate[] chain = this._keystore.getCertificateChain(ALIAS_PRODUCT_PK);
            if (chain == null || chain.length == 0) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = (X509Certificate)chain[0];
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getInstanceProductCert(String instance) throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            Certificate[] chain = this._keystore.getCertificateChain("xp.productkey_" + instance);
            if (chain == null || chain.length == 0) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = (X509Certificate)chain[0];
            return x509Certificate;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    private void addCertificateWithAlias(String alias, X509Certificate cert) throws CertificateException, KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Adding certificate with alias '{}'", (Object)alias);
        }
        try {
            this.checkCertificate(cert);
        }
        catch (GeneralSecurityException e) {
            CertificateException ce = new CertificateException(e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.setCertificateEntry(alias, cert);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            this._keystore.deleteEntry(alias);
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    private void checkValidity(X509Certificate certificate) throws CertificateException {
        try {
            _log.trace("checks validity of the certificate: {}", (Object)certificate.getSubjectX500Principal().getName());
            certificate.checkValidity(this.dateSupplier.get());
        }
        catch (CertificateExpiredException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is out of date" + (String)msg;
            CertificateException ce = new CertificateException((String)msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        catch (CertificateNotYetValidException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is not valid" + (String)msg;
            CertificateException ce = new CertificateException((String)msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    public void addPrivateKey(String localID, PrivateKey privateKey, char[] password, X509Certificate certificate) throws KeyStoreException, CertificateException {
        String alias = this.buildAliasForPrivateKey(localID);
        if (_log.isTraceEnabled()) {
            _log.trace("Adding private key for localId '{}'", (Object)localID);
        }
        this.storePrivateKey(privateKey, password, certificate, alias);
    }

    private void storePrivateKey(PrivateKey privateKey, char[] password, X509Certificate certificate, String alias) throws KeyStoreException, CertificateException {
        X509Certificate[] certChain = this.getCertificateChain(certificate);
        this.storePrivateKey(privateKey, password, certChain, alias);
    }

    private void storePrivateKey(PrivateKey privateKey, char[] password, X509Certificate[] certChain, String alias) throws CertificateException, KeyStoreException {
        this.checkCertificateChain(certChain);
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.setKeyEntry(alias, privateKey, password, certChain);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            this._keystore.deleteEntry(alias);
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCA(String id) throws KeyStoreException {
        if (_log.isTraceEnabled()) {
            _log.trace("Deleting ca certificate '{}'", (Object)id);
        }
        this.deleteEntry(id);
        HashMap<String, X509Certificate[]> hashMap = this._chainCache;
        synchronized (hashMap) {
            this._chainCache.clear();
        }
    }

    private void deleteEntry(String alias) throws KeyStoreException {
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.deleteEntry(alias);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    boolean containsCA(String id) throws KeyStoreException {
        return this.containsAlias(id);
    }

    private boolean containsAlias(String alias) throws KeyStoreException {
        this._readLockForKeyStore.lock();
        try {
            boolean bl = this._keystore.containsAlias(alias);
            return bl;
        }
        finally {
            this._readLockForKeyStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getCertificateChain(X509Certificate cert) throws CertificateException {
        X509Certificate[] certChain;
        String certId = String.valueOf(cert.getSerialNumber()) + "-" + cert.getIssuerX500Principal().hashCode();
        HashMap<String, X509Certificate[]> hashMap = this._chainCache;
        synchronized (hashMap) {
            certChain = this._chainCache.get(certId);
            if (certChain == null) {
                certChain = this.createNewCertChain(cert, certId);
            }
        }
        return certChain;
    }

    private X509Certificate[] createNewCertChain(X509Certificate certificate, String certId) throws CertificateException {
        X509Certificate cert = certificate;
        ArrayList<X509Certificate> v = new ArrayList<X509Certificate>();
        v.add(cert);
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (!issuer.equals(subject)) {
            X509Certificate issuerCert = this.getIssuerCertificate(cert);
            if (issuerCert == null) {
                throw new CertificateException("No certificate for CA '" + issuer.getName() + "' found.");
            }
            v.add(issuerCert);
            subject = issuerCert.getSubjectX500Principal();
            issuer = issuerCert.getIssuerX500Principal();
            cert = issuerCert;
        }
        X509Certificate[] certChain = new X509Certificate[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            certChain[i] = (X509Certificate)v.get(i);
        }
        this._chainCache.put(certId, certChain);
        return certChain;
    }

    private X509Certificate getIssuerCertificate(X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        Enumeration<X509Certificate> certificates = this.certificates();
        while (certificates.hasMoreElements()) {
            X509Certificate aCert = certificates.nextElement();
            if (!aCert.getSubjectX500Principal().equals(issuer)) continue;
            return aCert;
        }
        return null;
    }

    public void storeKeystore(File keystoreFile, KeyStore keystore, String password) throws KeyStoreException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(Files.newOutputStream(keystoreFile.toPath(), new OpenOption[0]));
            keystore.store(out, password.toCharArray());
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
            msg = "Unable to store keystore" + (String)msg;
            KeyStoreException ke = new KeyStoreException((String)msg);
            ke.setStackTrace(e.getStackTrace());
            throw ke;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void reloadKeystore(byte[] keystoreBytes) throws KeyStoreException {
        this.loadKeystore(keystoreBytes, this.password, this._keystore);
    }

    private void loadKeystore(byte[] bytes, String password, KeyStore keyStore) throws KeyStoreException {
        ByteArrayInputStream fis = null;
        try {
            fis = new ByteArrayInputStream(bytes);
            keyStore.load(fis, password.toCharArray());
        }
        catch (Exception e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
            msg = "Unable to load keystore" + (String)msg;
            KeyStoreException ke = new KeyStoreException((String)msg);
            ke.setStackTrace(e.getStackTrace());
            throw ke;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkCertificateSignature(X509Certificate certificate, X509Certificate caCertificate) throws CertificateException {
        try {
            certificate.verify(caCertificate.getPublicKey(), "BC");
        }
        catch (SignatureException e) {
            String msg = "Signing CA '" + caCertificate.getSubjectX500Principal().getName() + "' is not issuer of certificate '" + certificate.getSubjectX500Principal().getName() + "'";
            throw new CertificateException(msg, e);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            _log.error("could not verify certificate signature.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void checkCertificate(X509Certificate certificate) throws CertificateException {
        this.checkCertificateChain(this.getCertificateChain(certificate));
    }

    private void checkCertificateChain(X509Certificate[] certChain) throws CertificateException {
        for (int i = 0; i < certChain.length; ++i) {
            X509Certificate certificate = certChain[i];
            this.checkValidity(certificate);
            if (i + 1 < certChain.length) {
                this.checkCertificateSignature(certificate, certChain[i + 1]);
                continue;
            }
            this.checkCertificateSignature(certificate, certChain[i]);
        }
    }

    private String buildAliasForPrivateKey(String localID) {
        return localID + SUFFIX_PRIVATE_KEY;
    }

    public String buildAliasForSMIME(X509Certificate cert) throws CertificateException {
        String email = this._certificate.retrieveEmail(cert);
        return this.buildAliasForSMIME(email);
    }

    private String buildAliasForSMIME(String email) {
        return email + SUFFIX_SMIME;
    }

    public String buildAliasForCA(X509Certificate caCertificate) {
        return caCertificate.getSubjectX500Principal().getName("CANONICAL");
    }

    private String buildAliasForCertificate(String localID) {
        return localID + SUFFIX_CERT;
    }

    public void deleteInstanceActivation(String instanceId) throws KeyStoreException {
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.deleteEntry("xp.activation_" + instanceId);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    public void deleteLegacyActivation() throws KeyStoreException {
        this._writeLockForKeyStore.lock();
        try {
            this._keystore.deleteEntry(ALIAS_ACTIVATION);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                this._keystore.store(byteArrayOutputStream, this.password.toCharArray());
                this.storeKeystore.accept(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        finally {
            this._writeLockForKeyStore.unlock();
        }
    }

    public void verifyCertificateIssuer(X509Certificate certificate) throws CertificateException {
        X500Principal issuer = certificate.getIssuerX500Principal();
        X509Certificate issuerCert = this.getIssuerCertificate(certificate);
        if (issuerCert == null) {
            throw new CertificateException("Certificate Issuer  '" + issuer.getName() + "' is not trusted.");
        }
        this.checkValidity(certificate);
        try {
            this.checkCertificateSignature(certificate, issuerCert);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException(e);
        }
    }
}

