/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.IssuerAndSerial;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import de.pontonconsulting.xmlpipe.security.XpWSSecurityException;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.crypto.CryptoBase;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;

public abstract class PartnerCrypto
extends CryptoBase {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + PartnerCrypto.class.getSimpleName()));
    private final Map<String, X509Certificate[]> certificateIdentifiers = new HashMap<String, X509Certificate[]>();
    private final Map<ByteBuffer, X509Certificate[]> skiBytesMap = new HashMap<ByteBuffer, X509Certificate[]>();
    private final Map<IssuerAndSerial, X509Certificate[]> issuerAndSerial = new HashMap<IssuerAndSerial, X509Certificate[]>();
    private final Map<String, PrivateKey> privateKeys = new HashMap<String, PrivateKey>();
    private final CertificateUtility certificateUtility;
    private final KeystoreBean keystoreBean;
    private final ReferenceDateTask referenceDateTask;

    private PartnerCrypto(CertificateUtility certificateUtility, KeystoreBean keystoreBean, ReferenceDateTask referenceDateTask) {
        this.certificateUtility = certificateUtility;
        this.keystoreBean = keystoreBean;
        this.referenceDateTask = referenceDateTask;
    }

    PartnerCrypto(CertificateUtility certificateUtility, KeystoreBean keystoreBean, List<SignCertInfo> signCertInfos, ReferenceDateTask referenceDateTask) {
        this(certificateUtility, keystoreBean, referenceDateTask);
        try {
            for (SignCertInfo signCertInfo : signCertInfos) {
                PrivateKey privateKey = signCertInfo.getPrivateKey();
                X509Certificate[] chain = signCertInfo.getCertificateChain();
                X509Certificate x509Certificate = chain[0];
                try {
                    this.privateKeys.put(certificateUtility.buildAlias(x509Certificate), privateKey);
                    this.certificateIdentifiers.put(certificateUtility.buildAlias(x509Certificate), chain);
                    this.issuerAndSerial.put(new IssuerAndSerial(x509Certificate), chain);
                    byte[] skiBytes = certificateUtility.getSKIBytesFromCert(x509Certificate);
                    this.skiBytesMap.put(ByteBuffer.wrap(skiBytes), chain);
                }
                catch (WSSecurityException e) {
                    LOGGER.warn("Could not build caching id for certificate '{}': {}", (Object)x509Certificate.getSubjectX500Principal().getName(), (Object)e.toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not rebuild certificate cache.", (Throwable)e);
        }
    }

    PartnerCrypto(List<X509Certificate> certificates, CertificateUtility certificateUtility, KeystoreBean keystoreBean, ReferenceDateTask referenceDateTask) {
        this(certificateUtility, keystoreBean, referenceDateTask);
        try {
            for (X509Certificate x509Certificate : certificates) {
                X509Certificate[] x509CertificateChain;
                try {
                    x509CertificateChain = keystoreBean.getKeystore().getCertificateChain(x509Certificate);
                }
                catch (CertificateException e) {
                    LOGGER.trace("could not create certificate chain for {}", (Object)x509Certificate.getSubjectX500Principal().getName());
                    x509CertificateChain = new X509Certificate[]{x509Certificate};
                }
                try {
                    this.certificateIdentifiers.put(certificateUtility.buildAlias(x509Certificate), x509CertificateChain);
                    this.issuerAndSerial.put(new IssuerAndSerial(x509Certificate), x509CertificateChain);
                    byte[] skiBytes = certificateUtility.getSKIBytesFromCert(x509Certificate);
                    this.skiBytesMap.put(ByteBuffer.wrap(skiBytes), x509CertificateChain);
                }
                catch (WSSecurityException e) {
                    LOGGER.warn("Could not build caching id for certificate '{}': {}", (Object)x509Certificate.getSubjectX500Principal().getName(), (Object)e.toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not rebuild certificate cache.", (Throwable)e);
        }
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        switch (cryptoType.getType()) {
            case ISSUER_SERIAL: {
                String issuer = cryptoType.getIssuer();
                BigInteger serial = cryptoType.getSerial();
                if (issuer != null && serial != null) {
                    try {
                        X509Certificate[] x509CertificateChain = this.issuerAndSerial.get(new IssuerAndSerial(issuer, serial));
                        if (x509CertificateChain != null) {
                            return x509CertificateChain;
                        }
                        String certificateAlias = this.certificateUtility.serialNr2String(serial) + " (" + String.valueOf(serial) + ") , Issuer: " + issuer;
                        LOGGER.warn("Could not find certificate serial: {}", (Object)certificateAlias);
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Issuer: {} or serial: {} is broken", (Object)issuer, (Object)serial, (Object)e);
                    }
                    break;
                }
                LOGGER.warn("noCertsFound: issuer or serial is null");
                break;
            }
            case ALIAS: {
                String alias = cryptoType.getAlias();
                try {
                    X509Certificate[] x509CertificateChainAlias = this.certificateIdentifiers.get(alias);
                    if (x509CertificateChainAlias != null) {
                        return x509CertificateChainAlias;
                    }
                    LOGGER.warn("Could not find certificate for alias '{}'.", (Object)alias);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Alias: {} is broken", (Object)alias, (Object)e);
                }
                break;
            }
            case SKI_BYTES: {
                byte[] skiBytes = cryptoType.getBytes();
                try {
                    X509Certificate[] x509CertificateChainSKI = this.skiBytesMap.get(ByteBuffer.wrap(skiBytes));
                    if (x509CertificateChainSKI != null) {
                        return x509CertificateChainSKI;
                    }
                    String newAlias = "no alias found.";
                    if (StringUtils.isNotBlank((CharSequence)cryptoType.getAlias())) {
                        newAlias = cryptoType.getAlias();
                    }
                    LOGGER.warn("noSKIHandling: SKI bytes is null, Alias: {}", (Object)newAlias);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("SkiBytes: {} is broken", (Object)skiBytes, (Object)e);
                }
                break;
            }
            default: {
                LOGGER.warn("unsupportedKeyInfo");
            }
        }
        return null;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        return this.certificateUtility.buildAlias(cert);
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        return this.getPrivateKey(this.getX509Identifier(certificate), null);
    }

    public PrivateKey getPrivateKey(PublicKey publicKey, CallbackHandler callbackHandler) throws WSSecurityException {
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "method org.apache.wss4j.common.crypto.Crypto#getPrivateKey(java.security.PublicKey, javax.security.auth.callback.CallbackHandler) is not implemented");
    }

    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        PrivateKey privateKey;
        String[] issuerAndSerial = this.certificateUtility.getIssuerAndSerialForAlias(identifier);
        String issuer = issuerAndSerial[0];
        String serial = issuerAndSerial[1];
        X509Certificate[] x509Certificate = this.certificateIdentifiers.get(identifier);
        if (x509Certificate != null && (privateKey = this.privateKeys.get(identifier)) != null) {
            return privateKey;
        }
        String errorMsg = "No private key found for certificate serial: " + this.certificateUtility.serialNr2String(new BigInteger(serial)) + " (" + serial + ") , Issuer: " + issuer + ", Identifier: " + identifier + ".";
        throw new XpWSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, "empty", new String[]{errorMsg});
    }

    public void verifyTrust(X509Certificate[] certs, boolean enableRevocation, Collection<Pattern> subjectCertConstraints, Collection<Pattern> issuerCertConstraints) throws WSSecurityException {
        Object issuer;
        AtomicBoolean trusted = new AtomicBoolean(false);
        try {
            certs[0].checkValidity(this.referenceDateTask.getReferenceDate());
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            String issuer2 = this.getIssuer(certs[0]);
            BigInteger serial = certs[0].getSerialNumber();
            String identifier = this.getX509Identifier(certs[0]);
            String errorMsg = "Certificate is Expired or not yet Valid: " + this.certificateUtility.serialNr2String(serial) + " (" + String.valueOf(serial) + ") , Issuer: " + issuer2 + ", Identifier: " + identifier + ".";
            throw new XpWSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new String[]{errorMsg});
        }
        try {
            issuer = Arrays.stream(this.getAllCaCertificates()).filter(c -> c.getSubjectX500Principal().equals(certs[0].getIssuerX500Principal())).findFirst();
            if (((Optional)issuer).isPresent()) {
                try {
                    certs[0].verify(((Optional)issuer).get().getPublicKey());
                    trusted.set(true);
                }
                catch (GeneralSecurityException issuer2) {}
            }
        }
        catch (KeyStoreException e) {
            throw new XpWSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new String[]{"Could not get all CA certificates"});
        }
        if (!trusted.get()) {
            issuer = this.getIssuer(certs[0]);
            BigInteger serial = certs[0].getSerialNumber();
            String identifier = this.getX509Identifier(certs[0]);
            X509Certificate[] x509Certificate = this.certificateIdentifiers.get(identifier);
            if (x509Certificate == null) {
                String errorMsg = "Not known certificate serial: " + this.certificateUtility.serialNr2String(serial) + " (" + String.valueOf(serial) + ") , Issuer: " + (String)issuer + ", Identifier: " + identifier + ".";
                throw new XpWSSecurityException(this.getErrorCode(), "empty", new String[]{errorMsg});
            }
        }
    }

    abstract WSSecurityException.ErrorCode getErrorCode();

    private X509Certificate[] getAllCaCertificates() throws KeyStoreException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        PontonKeystore keystore = this.keystoreBean.getKeystore();
        Enumeration<String> ids = keystore.caCertificateIds();
        while (ids.hasMoreElements()) {
            certificateList.add(keystore.getCA(ids.nextElement()));
        }
        return certificateList.toArray(new X509Certificate[0]);
    }

    private String getIssuer(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().getName();
    }

    public void verifyTrust(PublicKey publicKey) throws WSSecurityException {
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "org.apache.wss4j.common.crypto.Crypto.verifyTrust(java.security.PublicKey) is not implemented");
    }
}

