/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.registry;

import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.integration.WebDavIntegration;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryProfileCleanUp {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.RegistryProfileCleanUp");
    private final PartnerProfileDAO partnerProfileDAO;
    private final Profiles profiles;
    private final Agreements agreements;
    private final WebDavIntegration webDavIntegration;

    public RegistryProfileCleanUp(PartnerProfileDAO partnerProfileDAO, Profiles profiles, Agreements agreements, WebDavIntegration webDavIntegration) {
        this.partnerProfileDAO = partnerProfileDAO;
        this.profiles = profiles;
        this.agreements = agreements;
        this.webDavIntegration = webDavIntegration;
    }

    public void cleanUpDeletedProfiles() throws RegistryException {
        Map<String, IndexRecord> indexRecords = this.webDavIntegration.getRegistryIndex(true);
        if (indexRecords == null) {
            return;
        }
        for (PartnerProfile remotePartner : this.partnerProfileDAO.getAllRemotePartnerProfiles()) {
            if (remotePartner.getRegistryPath() == null || remotePartner.getRegistryPath().isBlank()) continue;
            if (indexRecords.containsKey(remotePartner.getRegistryPath())) {
                LOGGER.debug("Won't delete Remote Partner with local id '{}'.", (Object)remotePartner.getPartnerId());
                continue;
            }
            LOGGER.info("Delete Remote Partner with local id '{}' now!", (Object)remotePartner.getPartnerId());
            try {
                this.agreements.removeAgreementsOfPartner(remotePartner.getPartnerId());
                this.profiles.deleteProfile(remotePartner.getPartnerId());
            }
            catch (ProfileException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }
}

