/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.common.log.LogPrintStream;
import de.pontonconsulting.common.mail.MimeMessage;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IMessengerConfigAware;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmtpSender
implements IMessengerConfigAware {
    private static final String TRUST_ALL_HOSTS = "*";
    private static final String EMAIL_SEPARATOR = ";";
    private static final String MAIL_SMTP_SSL_ENABLE = "mail.smtp.ssl.enable";
    private static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    private static final String MAIL_SMTP_SSL_TRUST = "mail.smtp.ssl.trust";
    private static final String MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY = "mail.smtp.ssl.checkserveridentity";
    private static final String PROTOCOL_SMTP_STARTTLS = "smtp+starttls";
    private static final String PROTOCOL_SMTPS = "smtps";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String BASE64 = "base64";
    private static final String SMTP_DEFAULT_PORT = "25";
    private static final String SMTPS_DEFAULT_PORT = "465";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String SMTP_HOST_PROPERTY = "mail.smtp.host";
    private static final String SMTP_PORT_PROPERTY = "mail.smtp.port";
    private static final String SMTP_AUTH_PROPERTY = "mail.smtp.auth";
    private static Logger _log = LogManager.getLogger((String)"Messenger.SmtpSender");
    private MessengerConfig messengerConfig;
    private Session _session;
    private String _from;
    private String _smtpServer;
    private String _smtpPort;
    private String _protocol;
    private String _user;
    private String _password;

    public SmtpSender() {
        this(null, null, null, null, null);
    }

    public SmtpSender(String from) {
        this(from, null, null, null, null);
    }

    public SmtpSender(String from, String smtpServer, String protocol, String user, String password) {
        this._from = from;
        this._smtpServer = smtpServer;
        this._protocol = protocol;
        this._user = user;
        this._password = password;
    }

    public void initialize() throws TransportException {
        try {
            if (this._from == null) {
                this._from = this.messengerConfig.getSmtpFromAddress();
            }
            if (this._smtpServer == null) {
                this._smtpServer = this.messengerConfig.getSmtpServerHost();
            }
            if (this._protocol == null) {
                this._protocol = this.messengerConfig.getSmtpServerProtocol();
            }
            if (this._user == null) {
                this._user = this.messengerConfig.getSmtpUser();
            }
            if (this._password == null) {
                this._password = this.messengerConfig.getSmtpPassword();
            }
            Properties props = new Properties();
            this._smtpPort = SMTP_DEFAULT_PORT;
            int index = this._smtpServer.indexOf(58);
            if (index > 0) {
                this._smtpPort = this._smtpServer.substring(index + 1);
                this._smtpServer = this._smtpServer.substring(0, index);
            } else if (PROTOCOL_SMTPS.equals(this._protocol)) {
                this._smtpPort = SMTPS_DEFAULT_PORT;
            }
            props.setProperty(MAIL_SMTP_STARTTLS_ENABLE, FALSE);
            props.setProperty(MAIL_SMTP_SSL_TRUST, TRUST_ALL_HOSTS);
            if (PROTOCOL_SMTPS.equals(this._protocol)) {
                _log.debug("Using SMTPS to send the email message.");
                props.setProperty(MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY, TRUE));
                props.setProperty(MAIL_SMTP_SSL_ENABLE, TRUE);
            } else if (PROTOCOL_SMTP_STARTTLS.equals(this._protocol)) {
                _log.debug("Using SMTP+STARTTLS to send the email message.");
                props.setProperty(MAIL_SMTP_STARTTLS_ENABLE, TRUE);
                props.setProperty(MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY, this.messengerConfig.getProperty(MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY, TRUE));
                props.setProperty(MAIL_SMTP_STARTTLS_REQUIRED, TRUE);
            } else {
                _log.debug("Using SMTP to send the email message.");
            }
            props.put(SMTP_HOST_PROPERTY, this._smtpServer);
            props.put(SMTP_PORT_PROPERTY, this._smtpPort);
            MyAuthenticator auth = null;
            if (this._user != null && this._user.length() > 0) {
                _log.debug("Using authentication for SMTP server");
                auth = new MyAuthenticator(this, this._user, this._password);
                props.put(SMTP_AUTH_PROPERTY, TRUE);
            } else {
                props.put(SMTP_AUTH_PROPERTY, FALSE);
            }
            this._session = Session.getInstance((Properties)props, auth);
            if (_log.isTraceEnabled()) {
                LogPrintStream logStream = new LogPrintStream(_log);
                this._session.setDebugOut((PrintStream)logStream);
                this._session.setDebug(true);
            }
        }
        catch (Exception e) {
            throw new TransportException(25000, e);
        }
    }

    public void sendMessage(MimeMessage message) throws MessagingException {
        if (_log.isDebugEnabled()) {
            _log.debug("Sending MimeMessage");
        }
        try {
            message.setHeader("X-Mailer", Constants.getXP_VENDOR() + " " + Constants.getXP_NAME() + " " + Constants.getXP_VERSION());
            Transport.send((Message)message);
        }
        catch (MessagingException me) {
            Exception ex = me.getNextException();
            if (ex != null) {
                if (ex instanceof MessagingException) {
                    throw (MessagingException)((Object)ex);
                }
                MessagingException me2 = new MessagingException(me.getMessage() + ":" + String.valueOf(ex));
                me2.setStackTrace(me.getStackTrace());
                throw me2;
            }
            throw me;
        }
    }

    public void sendMessage(String receiver, String subject, String text) throws MessagingException {
        this.sendMessage(receiver, subject, text, new ArrayList<File>(0));
    }

    public void sendMessage(String receiver, String subject, String text, File file) throws MessagingException {
        ArrayList<File> attachments = new ArrayList<File>();
        if (file != null) {
            attachments.add(file);
        }
        this.sendMessage(receiver, subject, text, attachments);
    }

    public void sendMessage(String receiver, String subject, String text, List<File> attachments) throws MessagingException {
        if (_log.isDebugEnabled()) {
            _log.debug("Sending text message.");
        }
        MimeMessage msg = new MimeMessage(this._session);
        msg.setFrom((Address)new InternetAddress(this._from));
        String[] receivers = receiver.split(EMAIL_SEPARATOR);
        InternetAddress[] address = new InternetAddress[receivers.length];
        for (int i = 0; i < receivers.length; ++i) {
            address[i] = new InternetAddress(receivers[i], true);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setText(text);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        if (attachments != null) {
            for (File attachment : attachments) {
                if (!attachment.exists()) continue;
                MimeBodyPart mbpAttachment = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(attachment);
                mbpAttachment.setDataHandler(new DataHandler((DataSource)fds));
                mbpAttachment.setFileName(fds.getName());
                mbpAttachment.addHeader(CONTENT_TRANSFER_ENCODING, BASE64);
                mp.addBodyPart((BodyPart)mbpAttachment);
            }
        }
        msg.setContent((Multipart)mp);
        this.sendMessage(msg);
    }

    public String getFrom() {
        return this._from;
    }

    public Session getSession() {
        return this._session;
    }

    @Override
    public void setMessengerConfig(MessengerConfig messengerConfig) {
        this.messengerConfig = messengerConfig;
    }

    private class MyAuthenticator
    extends Authenticator {
        private final String _user;
        private final String _password;

        public MyAuthenticator(SmtpSender smtpSender, String user, String password) {
            this._user = user;
            this._password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this._user, this._password);
        }
    }
}

