/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.config.uiconfig.OptionType;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.RequestAcknowledgementUIOption;
import de.pontonconsulting.xmlpipe.uioption.UIOption;

public class EbXml20UIOptions {
    public static final String PACKAGE_ID = "EbXml20";
    public static final String REQUEST_ACK = "/RequestAck";
    public static final String SYNC_REPLY = "/SyncReply";
    public static final String DUPLICATE_ELIMINATION = "/DuplicateElimination";
    public static final String XML_SIGNATURE = "/XmlSignature";
    public static final String XML_ENCRYPTION = "/XmlEncryption";
    public static final String SERVICE = "/Service";
    public static final String SERVICE_TYPE = "/Service/Type";
    public static final String ACTION = "/Action";
    public static final String CPA_ID = "/CpaId";
    public static final String ROLE_FROM = "/RoleFrom";
    public static final String ROLE_TO = "/RoleTo";
    public static final String ATTACHMENT_ROLE_PAYLOAD = "/AttachmentRolePayload";
    public static final String ATTACHMENT_ROLE_SIGNATURE = "/AttachmentRoleSignature";
    public static final String ATTACHMENT_ROLE_OTHER = "/AttachmentRoleOther";
    private static final String UNSIGNED = "unsigned";
    private static final String SIGNED = "signed";
    private static final String TRUE = "true";
    private final UIConfig _uiConfig;
    private final UIOption[] _uiOptions;
    private final String _defaultCpaId;
    private final String _defaultAction;
    private final String _defaultService;
    private final String _defaultServiceType;
    private final String _defaultAttachmentRolePayload;
    private final String _defaultAttachmentRoleSignature;
    private final String _defaultAttachmentRoleOther;

    public EbXml20UIOptions(UIConfig uiConfig) {
        this._uiConfig = uiConfig;
        this._defaultCpaId = this.getDefaultOptionValue(PACKAGE_ID, CPA_ID);
        this._defaultAction = this.getDefaultOptionValue(PACKAGE_ID, ACTION);
        this._defaultService = this.getDefaultOptionValue(PACKAGE_ID, SERVICE);
        this._defaultServiceType = this.getDefaultOptionValue(PACKAGE_ID, SERVICE_TYPE);
        this._defaultAttachmentRolePayload = this.getDefaultOptionValue(PACKAGE_ID, ATTACHMENT_ROLE_PAYLOAD);
        this._defaultAttachmentRoleSignature = this.getDefaultOptionValue(PACKAGE_ID, ATTACHMENT_ROLE_SIGNATURE);
        this._defaultAttachmentRoleOther = this.getDefaultOptionValue(PACKAGE_ID, ATTACHMENT_ROLE_OTHER);
        this._uiOptions = this.initUIOptions();
    }

    private UIOption[] initUIOptions() {
        UIOption xmlSignature = new UIOption("packagingOption.ebxml2.use_xml_signature", XML_SIGNATURE, "boolean", TRUE, "hilfe_header_xmlsignature", "packagingOption.ebxml2.use_xml_signature", "packagingOption.agreement.help.ebxml2.use_xml_signature", "packagingOption.profile.help.ebxml2.use_xml_signature", UIOption.BOTH_PARTNERS, TRUE, "senderCertificate");
        RequestAcknowledgementUIOption requestAck = new RequestAcknowledgementUIOption("packagingOption.ebxml2.request.acknowledgements", REQUEST_ACK, "list", "unsigned,signed", "hilfe_header_ack", "packagingOption.ebxml2.request.acknowledgements", "packagingOption.agreement.help.ebxml2.request.acknowledgements", "packagingOption.profile.help.ebxml2.request.acknowledgements", UIOption.RECEIVER);
        requestAck.setValuesForValidation(new String[]{SIGNED});
        requestAck.setVisibility(UIOption.VISIBILITY.BOTH);
        UIOption service = new UIOption("packagingOption.ebxml2.service", SERVICE, "string", this._defaultService, "hilfe_header_service", "packagingOption.ebxml2.service", "packagingOption.agreement.help.ebxml2.service", "packagingOption.profile.help.ebxml2.service", UIOption.NONE, false);
        service.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption serviceType = new UIOption("packagingOption.ebxml2.servicetype", SERVICE_TYPE, "string", this._defaultServiceType, "hilfe_header_servicetype", "packagingOption.ebxml2.servicetype", "packagingOption.agreement.help.ebxml2.servicetype", "packagingOption.profile.help.ebxml2.servicetype", UIOption.NONE, false, true);
        serviceType.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption action = new UIOption("packagingOption.ebxml2.action", ACTION, "string", this._defaultAction, "hilfe_header_action", "packagingOption.ebxml2.action", "packagingOption.agreement.help.ebxml2.action", "packagingOption.profile.help.ebxml2.action", UIOption.NONE, false);
        action.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption duplicateElimination = new UIOption("packagingOption.ebxml2.duplicateelimination", DUPLICATE_ELIMINATION, "boolean", TRUE, "hilfe_header_duplicateelimination", "packagingOption.ebxml2.duplicateelimination", "packagingOption.agreement.help.ebxml2.duplicateelimination", "packagingOption.profile.help.ebxml2.duplicateelimination", UIOption.RECEIVER);
        duplicateElimination.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption syncReply = new UIOption("packagingOption.ebxml2.syncreply", SYNC_REPLY, "boolean", TRUE, "hilfe_header_syncreply", "packagingOption.ebxml2.syncreply", "packagingOption.agreement.help.ebxml2.syncreply", "packagingOption.profile.help.ebxml2.syncreply", UIOption.RECEIVER);
        syncReply.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption cpaId = new UIOption("packagingOption.ebxml2.cpaid", CPA_ID, "string", this._defaultCpaId, "hilfe_header_cpaid", "packagingOption.ebxml2.cpaid", "packagingOption.agreement.help.ebxml2.cpaid", "packagingOption.profile.help.ebxml2.cpaid", UIOption.NONE, false);
        cpaId.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption roleFrom = new UIOption("packagingOption.ebxml2.role.from", ROLE_FROM, "string", "", "hilfe_header_role", "packagingOption.ebxml2.role", "packagingOption.agreement.help.ebxml2.role", null, UIOption.NONE, false, true);
        roleFrom.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption roleTo = new UIOption("packagingOption.ebxml2.role.to", ROLE_TO, "string", "", "hilfe_header_role", "packagingOption.ebxml2.role", "packagingOption.agreement.help.ebxml2.role", null, UIOption.NONE, false, true);
        roleTo.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption attachmentRolePayload = new UIOption("packagingOption.ebxml2.attachment.role.payload", ATTACHMENT_ROLE_PAYLOAD, "string", this._defaultAttachmentRolePayload, "hilfe_header_role_attachment", "packagingOption.ebxml2.attachment.role", "packagingOption.agreement.help.ebxml2.attachment.role", null, UIOption.NONE, false, true);
        UIOption attachmentRoleSignature = new UIOption("packagingOption.ebxml2.attachment.role.signature", ATTACHMENT_ROLE_SIGNATURE, "string", this._defaultAttachmentRoleSignature, "hilfe_header_role_attachment", "packagingOption.ebxml2.attachment.role", "packagingOption.agreement.help.ebxml2.attachment.role", null, UIOption.NONE, false, true);
        UIOption attachmentRoleOther = new UIOption("packagingOption.ebxml2.attachment.role.other", ATTACHMENT_ROLE_OTHER, "string", this._defaultAttachmentRoleOther, "hilfe_header_role_attachment", "packagingOption.ebxml2.attachment.role", "packagingOption.agreement.help.ebxml2.attachment.role", null, UIOption.NONE, false, true);
        return new UIOption[]{xmlSignature, requestAck, service, serviceType, action, duplicateElimination, syncReply, cpaId, roleFrom, roleTo, attachmentRolePayload, attachmentRoleSignature, attachmentRoleOther};
    }

    private String getDefaultOptionValue(String packageId, String optionPath) {
        OptionType optionType = this._uiConfig.getPackageOptionConfig(packageId, optionPath);
        if (optionType != null) {
            return optionType.getDefaultValue();
        }
        return null;
    }

    public UIOption[] getUIOptions() {
        return this._uiOptions;
    }

    public String getDefaultCpaId() {
        return this._defaultCpaId;
    }

    public String getDefaultAction() {
        return this._defaultAction;
    }

    public String getDefaultService() {
        return this._defaultService;
    }

    public String getDefaultServiceType() {
        return this._defaultServiceType;
    }

    public String getDefaultAttachmentRolePayload() {
        return this._defaultAttachmentRolePayload;
    }

    public String getDefaultAttachmentRoleSignature() {
        return this._defaultAttachmentRoleSignature;
    }

    public String getDefaultAttachmentRoleOther() {
        return this._defaultAttachmentRoleOther;
    }
}

