/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.PartyId;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import de.pontonconsulting.xmlpipe.listener.EbXmlResponseException;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.listener.SoapListener;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlMessage;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EbXml20
extends BasePackager {
    private static final String PROPERTY_INCLUDE_PROCESSING_DIRECTIVES = "ponton.ebxml2.include.processing.directives";
    private static final String DEFAULT_INCLUDE_PROCESSING_DIRECTIVES = "true";
    public static final String PACKAGERNAME = "EbXml20";
    private static final String EN = "en";
    private static final String BASE64 = "base64";
    private static final String BINARY = "binary";
    public static final String UNSIGNED = "unsigned";
    public static final String SIGNED = "signed";
    private static final String FALSE = "false";
    private static final String ENGLISH = "en";
    private static final boolean EBXML_ATTACHMENT_FILENAME;
    private static final Logger _log;
    public static final String EBXML_PREQUEUE_FILE_NAME = "ebxmlData.dat";
    private SOAPMessage _message;
    private EbXmlMessage _eb;
    private MimeHeaders _headers;
    private XpMessage _xpMessage;
    private long _ttl = -1L;

    public EbXml20(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, messageWorkDataDAO);
    }

    private boolean includeProcessingDirectives() {
        String value = this.getMessengerProperties().getProperty(PROPERTY_INCLUDE_PROCESSING_DIRECTIVES, DEFAULT_INCLUDE_PROCESSING_DIRECTIVES);
        return Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToStream(File outFile, OutputStream outHeaders) throws SOAPException, IOException {
        try (OutputStream out = null;
             BufferedOutputStream messageDat = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
             ObjectOutputStream oos = new ObjectOutputStream(outHeaders);){
            Map<String, String> header2 = MimeMultipartUtils.convertMimeHeadersToHashMap(this._headers);
            Optional.ofNullable(this._xpMessage.getProcessingDirective("X-CopyOf")).ifPresent(value -> header2.put("X-CopyOf", (String)value));
            Optional.ofNullable(this._xpMessage.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> header2.put("X-OriginalReceiver", (String)value));
            if (this._message.countAttachments() == 0 && BASE64.equalsIgnoreCase(this._eb.getTransferEncoding())) {
                out = new Base64Encoder((OutputStream)messageDat, true);
                header2.put("Content-Transfer-Encoding", BASE64);
            } else {
                out = messageDat;
            }
            String originalFilename = this._xpMessage.getProcessingDirective("OriginalFilename");
            if (StringUtils.isNotEmpty((CharSequence)originalFilename)) {
                String encoded = "";
                try {
                    encoded = MimeUtility.encodeText((String)originalFilename.trim());
                }
                catch (UnsupportedEncodingException ex) {
                    _log.warn(ex.getMessage());
                    encoded = originalFilename.trim();
                }
                header2.put("X-Original-Filename", encoded);
            }
            String contentType = this._message.getMimeHeaders().getHeader("Content-Type")[0];
            header2.put("Content-Type", contentType);
            this._message.writeTo(out);
            out.flush();
            long size = outFile.length();
            header2.put("Content-Length", Long.toString(size));
            if (!header2.containsKey("Message-Id")) {
                header2.put("Message-Id", this._xpMessage.getMessageId());
            }
            oos.writeObject(header2);
        }
    }

    @Override
    public void storePrequeueingFormat(XpMessage message, File messageFile, File messageHeaderFile) throws PackagingException {
        this._xpMessage = message;
        this.checkPartnerValidity();
        this.checkTransportValidity();
        try {
            this.checkSecureDependencies();
        }
        catch (SOAPException e) {
            throw new PackagingException(24005, (Throwable)e);
        }
        if (!message.isAckRequested()) {
            try {
                this._xpMessage.getCommunication().getPackagingOptionValue("/RequestAck");
                this._xpMessage.setAckRequested(true);
            }
            catch (OptionNotFoundException e) {
                this._xpMessage.setAckRequested(false);
            }
        }
        XpMessage preMessage = new XpMessage();
        preMessage.setMessageId(message.getMessageId());
        preMessage.setDatabaseId(message.getDatabaseId());
        preMessage.setConversationId(message.getConversationId());
        preMessage.setConversationDatabaseId(message.getConversationDatabaseId());
        preMessage.setReferenceId(message.getReferenceId());
        preMessage.setReferenceDatabaseId(message.getReferenceDatabaseId());
        preMessage.setProcessingDirectives(new HashMap<String, String>(message.getProcessingDirectives()));
        if (message.getCurrentContentReference() != null) {
            preMessage.setCurrentContentReference(message.getCurrentContentReference());
        }
        preMessage.setCurrentContentType(message.getCurrentContentType());
        preMessage.setSchemaSet(message.getSchemaSet());
        preMessage.setSchemaLocation(message.getSchemaLocation());
        preMessage.setMessageType(message.getMessageType());
        preMessage.setMessageVersion(message.getMessageVersion());
        preMessage.setAttachments(message.getAttachments());
        if (message.getSequenceNumber() > -1) {
            preMessage.setSequenceNumber(message.getSequenceNumber());
        }
        preMessage.setSequenceReset(message.isSequenceReset());
        preMessage.setSenderLocalId(message.getSenderLocalId());
        preMessage.setSenderInternalId(message.getSenderInternalId());
        preMessage.setReceiverLocalId(message.getReceiverLocalId());
        preMessage.setReceiverInternalId(message.getReceiverInternalId());
        preMessage.setTestMessage(message.isTestMessage());
        preMessage.setAckRequested(message.isAckRequested());
        preMessage.setMessageTimestamp(message.getMessageTimestamp());
        File work = new File(this.getFolders().getWorkOutboundFolder(), String.valueOf(message.getDatabaseId()));
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(new File(work, EBXML_PREQUEUE_FILE_NAME).toPath(), new OpenOption[0])));){
            oos.writeObject(preMessage);
        }
        catch (Exception e) {
            _log.error("Could not store ebxmlData.dat: {}", (Object)e.getMessage());
            throw new PackagingException(24013, (Throwable)e);
        }
    }

    @Override
    public void storePostqueueingFormat(Communication communication, long ttl, File work) throws PackagingException {
        try {
            this._ttl = ttl;
            File messageFile = new File(work, "xp_message.dat");
            File messageHeaderFile = new File(work, "xp_message_header.dat");
            File serialized = new File(work, EBXML_PREQUEUE_FILE_NAME);
            if (!serialized.exists() && messageFile.exists() && messageHeaderFile.exists()) {
                return;
            }
            try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(serialized.toPath(), new OpenOption[0]));
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                this._xpMessage = (XpMessage)ois.readObject();
                Agreement agreement = communication.getAgreement();
                this._xpMessage.setAgreement(agreement);
                this._xpMessage.setOwnPartner(this.getProfiles().getProfileForLocalId(agreement.getOwnPartner().getId(), true));
                this._xpMessage.setCommunicationPartner(this.getProfiles().getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
                this._xpMessage.setCommunication(communication);
            }
            this.prepareFormat();
            this.storeTransmissionFormat(messageFile, messageHeaderFile);
            this.getMessageWorkDataDAO().uploadMessageArtifactToDB(this._xpMessage.getDatabaseId(), messageFile);
            this.getMessageWorkDataDAO().uploadMessageArtifactToDB(this._xpMessage.getDatabaseId(), messageHeaderFile);
            this.getMessageWorkDataDAO().uploadMessageArtifactToDB(this._xpMessage.getDatabaseId(), new File(messageFile.getParentFile(), "packaging_envelope.xml"));
        }
        catch (PackagingException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw new PackagingException(24005, (Throwable)e);
        }
        catch (Exception e) {
            throw new PackagingException(24014, (Throwable)e);
        }
        finally {
            if (this._eb != null) {
                try {
                    this._eb.closeAttachmentStreams();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PartyId[] getSenderPartyIds(XpMessage xpMessage) throws PackagingException {
        try {
            PartyId[] senderIds = xpMessage.getSender().getPartyIds(PACKAGERNAME);
            if (senderIds == null || senderIds.length == 0) {
                _log.error("No Party Ids are defined for the sender '{}'.", (Object)xpMessage.getSenderInternalId());
                throw new PackagingException(-1, "No Party Ids are defined for the sender '" + xpMessage.getSenderInternalId() + "'.");
            }
            return senderIds;
        }
        catch (ProfileException e) {
            throw new PackagingException(-1, "Could not determine Party Ids for the sender '" + xpMessage.getSenderInternalId() + "'. " + e.toString());
        }
    }

    private PartyId[] getReceiverPartyIds(XpMessage xpMessage) throws PackagingException {
        try {
            PartyId[] receiverIds = xpMessage.getReceiver().getPartyIds(PACKAGERNAME);
            if (receiverIds == null || receiverIds.length == 0) {
                _log.error("No Party Ids are defined for the receiver '{}'.", (Object)xpMessage.getReceiverInternalId());
                throw new PackagingException(-1, "No Party Ids are defined for the receiver '" + xpMessage.getReceiverInternalId() + "'.");
            }
            return receiverIds;
        }
        catch (ProfileException e) {
            throw new PackagingException(-1, "Could not determine Party Ids for the receiver '" + xpMessage.getReceiverLocalId() + "'. " + e.toString());
        }
    }

    private void checkPartnerValidity() throws PackagingException {
        this.getSenderPartyIds(this._xpMessage);
        this.getReceiverPartyIds(this._xpMessage);
    }

    private void checkTransportValidity() throws PackagingException {
        String url = this._xpMessage.getCommunication().getTransportURL().toLowerCase();
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("mailto:") || url.startsWith("smime:") || url.startsWith("ftp:") || url.startsWith("ftps:"))) {
            throw new PackagingException(24012, "EbXml20-Packager only supports http(s) and smtp/smime transport.");
        }
    }

    private void checkSecureDependencies() throws SOAPException {
        String ebXmlSignature = null;
        try {
            ebXmlSignature = this._xpMessage.getCommunication().getPackagingOptionValue("/XmlSignature");
        }
        catch (OptionNotFoundException e) {
            ebXmlSignature = FALSE;
        }
        if (DEFAULT_INCLUDE_PROCESSING_DIRECTIVES.equals(ebXmlSignature) && !"PING".equals(this._xpMessage.getMessageType())) {
            try {
                this._xpMessage.getCommunication().getPackagingSignKey();
            }
            catch (CertificateIdNotFoundException | GeneralSecurityException e) {
                this.getMessengerLog().log2db(521, this._xpMessage.getDatabaseId(), e.toString());
                throw new SOAPException("Cannot get private key for localId '" + this._xpMessage.getSenderLocalId() + "': " + e.getMessage());
            }
            catch (Exception e) {
                this.getMessengerLog().log2db(521, this._xpMessage.getDatabaseId(), e.getMessage());
                _log.error("unexpected error", (Throwable)e);
                throw new SOAPException("Undefined Problem while signing: " + e.getMessage());
            }
        }
    }

    private void storeTransmissionFormat(File messageFile, File messageHeaderFile) throws PackagingException {
        try (BufferedOutputStream messageDatHeader = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));){
            this.writeToStream(messageFile, messageDatHeader);
            this.writeEbXmlEnvelope(new File(messageFile.getParentFile(), "packaging_envelope.xml"));
        }
        catch (SOAPException e) {
            throw new PackagingException(24005, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new PackagingException(24006, (Throwable)e);
        }
        catch (IOException e) {
            throw new PackagingException(24007, (Throwable)e);
        }
        finally {
            this._eb.closeAttachmentStreams();
        }
    }

    private void writeEbXmlEnvelope(File file) throws SOAPException, IOException {
        try (BufferedOutputStream ebxmlOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), 16384);){
            this._message.removeAllAttachments();
            this._message.writeTo((OutputStream)ebxmlOutputStream);
        }
    }

    private void prepareFormat() throws SOAPException, PackagingException {
        _log.debug("preparing EbXml 2.0 message");
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)DEFAULT_INCLUDE_PROCESSING_DIRECTIVES);
        msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
        this._eb = new EbXmlMessage(msg, this.getReferenceDate());
        this._eb.prepareMinimalMessage();
        if (this._xpMessage.getMessageType().equals("PING")) {
            this._eb.setService("urn:oasis:names:tc:ebxml-msg:service", null);
            this._eb.setAction("Ping");
            this._xpMessage.setAckRequested(true);
        } else if (this._xpMessage.getMessageType().equals("StatusRequest")) {
            this.getMessengerLog().log2dbWithHref(92, this._xpMessage.getDatabaseId(), this._xpMessage.getReferenceId(), this._xpMessage.getReferenceId(), this._xpMessage.getReferenceDatabaseId(), true);
            this.getMessengerLog().log2dbWithHref(94, this._xpMessage.getReferenceDatabaseId(), this._xpMessage.getMessageId(), this._xpMessage.getMessageId(), this._xpMessage.getDatabaseId(), false);
            this._eb.setService("urn:oasis:names:tc:ebxml-msg:service", null);
            this._eb.setAction("StatusRequest");
            this._eb.setStatusRequest(this._xpMessage.getReferenceId());
            this._xpMessage.setAckRequested(true);
        } else {
            this.setService();
            this.setAction();
        }
        this.setTransferEncoding();
        this.setPartyIds(this._eb, this._xpMessage);
        this.setRoles();
        this._eb.setMessageId(this._xpMessage.getMessageId());
        this._eb.setConversationId(this._xpMessage.getConversationId());
        if (this._xpMessage.getSequenceNumber() > -1) {
            this._eb.setSequenceNumber(String.valueOf(this._xpMessage.getSequenceNumber()), this._xpMessage.isSequenceReset());
        }
        this.setCpaId();
        this._eb.setMessageTimestamp(this._xpMessage.getMessageTimestamp());
        this.setTimeToLive();
        this.setDuplicateElimination();
        this.setSyncReply();
        if (!"PING".equals(this._xpMessage.getMessageType()) && !"StatusRequest".equals(this._xpMessage.getMessageType())) {
            this.setBusinessData();
        }
        this._message = this._eb.getMessage();
        if (this._message.saveRequired()) {
            this._message.saveChanges();
        }
        _log.debug("message creation completed");
        this._headers = this._message.getMimeHeaders();
        this._headers.removeHeader("Content-Transfer-Encoding");
        try {
            String[] cTypes = this._headers.getHeader("Content-Type");
            if (cTypes == null || cTypes.length == 0) {
                ContentType contentType = new ContentType("text/xml");
                contentType.setParameter("charset", "utf-8");
                this._headers.setHeader("Content-Type", contentType.toString());
            }
        }
        catch (Exception e) {
            _log.warn("Could not update Content-Type:{}", (Object)e.getMessage());
        }
        _log.debug("messageheader creation completed");
    }

    private void setRoles() {
        try {
            String fromRole = this._xpMessage.getCommunication().getPackagingOptionValue("/RoleFrom");
            if (fromRole != null && fromRole.length() > 0) {
                this._eb.setFromRole(fromRole);
            }
        }
        catch (OptionNotFoundException fromRole) {
            // empty catch block
        }
        try {
            String toRole = this._xpMessage.getCommunication().getPackagingOptionValue("/RoleTo");
            if (toRole != null && toRole.length() > 0) {
                this._eb.setToRole(toRole);
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
    }

    private void setSyncReply() {
        try {
            String ebXmlSyncReply = this._xpMessage.getCommunication().getPackagingOptionValue("/SyncReply");
            this._eb.setSyncReply(Boolean.valueOf(ebXmlSyncReply));
        }
        catch (OptionNotFoundException e3) {
            this._eb.setSyncReply(false);
        }
        if (this._xpMessage.getSequenceNumber() != -1 && this._eb.isSyncReplyRequested()) {
            _log.warn("SyncReply is ON in agreement but is switched OFF due to MessageOrdering.");
            this._eb.setSyncReply(false);
        }
    }

    private void setDuplicateElimination() {
        try {
            String ebXmlDuplicateElimination = this._xpMessage.getCommunication().getPackagingOptionValue("/DuplicateElimination");
            this._eb.setDuplicateElimination(Boolean.valueOf(ebXmlDuplicateElimination));
        }
        catch (OptionNotFoundException e2) {
            this._eb.setDuplicateElimination(false);
        }
        if (this._xpMessage.getSequenceNumber() != -1 && !this._eb.isDuplicateElmination()) {
            _log.warn("Duplicate Elimination is OFF in agreement but is enforced due to MessageOrdering.");
            this._eb.setDuplicateElimination(true);
        }
    }

    private void setTimeToLive() {
        if (!(this._xpMessage.isAck() || "PING".equals(this._xpMessage.getMessageType()) && "ponton".equals(this._xpMessage.getSchemaSet()))) {
            if (this._ttl == -1L) {
                long timestamp = this._xpMessage.getMessageTimestamp().getTime();
                List<Integer> retryIntervals = this._xpMessage.getCommunication().getRetryIntervals();
                int numberOfRetries = this._xpMessage.getCommunication().getNumberOfRetries();
                this._ttl = timestamp + Util.calculateTTL(numberOfRetries, retryIntervals) * 1000L;
            }
            this._eb.setTimeToLive(new Date(this._ttl));
        }
    }

    private void setCpaId() {
        String ebXmlCpaId = this.getCPAId(this._xpMessage);
        this._eb.setCPAId(ebXmlCpaId);
    }

    private void setService() {
        String ebXmlService = null;
        String ebXmlServiceType = null;
        try {
            ebXmlService = this._xpMessage.getCommunication().getPackagingOptionValue("/Service");
            ebXmlServiceType = this._xpMessage.getCommunication().getPackagingOptionValue("/Service/Type");
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (this.isEmpty(ebXmlService)) {
            ebXmlService = this.getEbXml20UIOptions().getDefaultService();
        }
        String defaultServiceType = this.getEbXml20UIOptions().getDefaultServiceType();
        if (ebXmlServiceType == null && this.isNotEmpty(defaultServiceType)) {
            ebXmlServiceType = defaultServiceType;
        }
        this._eb.setService(this.replaceWildcardValues(this._xpMessage, ebXmlService), this.replaceWildcardValues(this._xpMessage, ebXmlServiceType));
    }

    private void setAction() {
        String ebXmlAction = null;
        try {
            ebXmlAction = this._xpMessage.getCommunication().getPackagingOptionValue("/Action");
            if (this.isEmpty(ebXmlAction)) {
                ebXmlAction = this.getEbXml20UIOptions().getDefaultAction();
            }
        }
        catch (OptionNotFoundException e2) {
            ebXmlAction = this.getEbXml20UIOptions().getDefaultAction();
        }
        this._eb.setAction(this.replaceWildcardValues(this._xpMessage, ebXmlAction));
    }

    private void setTransferEncoding() {
        try {
            String transferEncoding = this._xpMessage.getCommunication().getTransportOptionValue("/TransferEncoding");
            this._eb.setTransferEncoding(transferEncoding);
        }
        catch (TransportIdNotFoundException e1) {
            if (this._xpMessage.getCommunication().getTransportURL().toLowerCase().startsWith("http")) {
                this._eb.setTransferEncoding(BINARY);
            }
            this._eb.setTransferEncoding(BASE64);
        }
    }

    private void setPartyIds(EbXmlMessage eb, XpMessage xpMessage) throws PackagingException {
        PartyId[] receiverIds = this.getReceiverPartyIds(xpMessage);
        for (int i = 0; i < receiverIds.length; ++i) {
            eb.addToId(receiverIds[i].getValue(), receiverIds[i].getType());
        }
        PartyId[] senderIds = this.getSenderPartyIds(xpMessage);
        for (int i = 0; i < senderIds.length; ++i) {
            eb.addFromId(senderIds[i].getValue(), senderIds[i].getType());
        }
    }

    private void setBusinessData() throws SOAPException {
        Object contentId;
        block34: {
            if (this.includeProcessingDirectives() && this._xpMessage.getProcessingDirectives().size() > 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug("included processing directives");
                }
                this._eb.setProcessingDirectives(this._xpMessage.getProcessingDirectives());
            }
            contentId = "payload-" + System.currentTimeMillis();
            try {
                if (this._xpMessage.getCurrentContentReference() != null) {
                    String attachmentRole;
                    block33: {
                        String contentType;
                        if (_log.isDebugEnabled()) {
                            _log.debug("adding payload");
                        }
                        if (this.isEmpty(contentType = this._xpMessage.getCurrentContentType())) {
                            contentType = "application/octet-stream";
                        }
                        Object filename = this._xpMessage.getCurrentContentReference().getName();
                        String processedOriginalFilename = this._xpMessage.getProcessingDirective("ProcessedOriginalFilename");
                        if (EBXML_ATTACHMENT_FILENAME) {
                            String fileExtension = "";
                            int index = ((String)filename).lastIndexOf(46);
                            if (index > -1) {
                                fileExtension = ((String)filename).substring(index);
                            }
                            filename = this._xpMessage.getMessageId() + fileExtension;
                        } else if (StringUtils.isNotBlank((CharSequence)processedOriginalFilename)) {
                            filename = processedOriginalFilename;
                        }
                        this._eb.addAttachment((String)contentId, contentType, this._xpMessage.getCurrentContentReference(), (String)filename);
                        attachmentRole = null;
                        try {
                            attachmentRole = this._xpMessage.getCommunication().getPackagingOptionValue("/AttachmentRolePayload");
                        }
                        catch (OptionNotFoundException e) {
                            String defaultAttachmentRolePayload = this.getEbXml20UIOptions().getDefaultAttachmentRolePayload();
                            if (!this.isNotEmpty(defaultAttachmentRolePayload)) break block33;
                            attachmentRole = defaultAttachmentRolePayload;
                        }
                    }
                    this._eb.addReference((String)contentId, attachmentRole);
                    this._eb.addSchemaToCurrentReference(this._xpMessage.getSchemaLocation(), this._xpMessage.getMessageVersion());
                    this._eb.addDescriptionToCurrentReference("Payload", "en");
                    break block34;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("no payload defined");
                }
            }
            catch (IOException e) {
                _log.fatal("Payload not found:{}", (Object)e.getMessage());
                throw new SOAPException("Payload file not found:" + e.getMessage());
            }
            catch (URISyntaxException e) {
                _log.fatal("Attachment ContentId is not valid: {} {}", contentId, (Object)e.getMessage());
                throw new SOAPException("Attachment ContentId is not valid: " + (String)contentId);
            }
        }
        Iterator<XpMessageAttachment> attachments = this._xpMessage.getAttachmentIterator();
        while (attachments.hasNext()) {
            if (_log.isDebugEnabled()) {
                _log.debug("adding attachment");
            }
            XpMessageAttachment element = attachments.next();
            contentId = element.getAttachment().getName();
            try {
                this._eb.addAttachment((String)contentId, element.getType(), element.getAttachment());
                if ("xp-signature".equals(element.getRole())) {
                    block35: {
                        attachmentRole = null;
                        try {
                            attachmentRole = this._xpMessage.getCommunication().getPackagingOptionValue("/AttachmentRoleSignature");
                        }
                        catch (OptionNotFoundException e) {
                            String defaultAttachmentRoleSignature = this.getEbXml20UIOptions().getDefaultAttachmentRoleSignature();
                            if (!this.isNotEmpty(defaultAttachmentRoleSignature)) break block35;
                            attachmentRole = defaultAttachmentRoleSignature;
                        }
                    }
                    this._eb.addReference((String)contentId, attachmentRole);
                } else {
                    block36: {
                        attachmentRole = null;
                        try {
                            attachmentRole = this._xpMessage.getCommunication().getPackagingOptionValue("/AttachmentRoleOther");
                        }
                        catch (OptionNotFoundException e) {
                            String defaultAttachmentRoleOther = this.getEbXml20UIOptions().getDefaultAttachmentRoleOther();
                            if (!this.isNotEmpty(defaultAttachmentRoleOther)) break block36;
                            attachmentRole = defaultAttachmentRoleOther;
                        }
                    }
                    this._eb.addReference((String)contentId, attachmentRole);
                    if ("text/xml".equals(element.getType())) {
                        this._eb.addSchemaToCurrentReference(this._xpMessage.getSchemaLocation(), this._xpMessage.getMessageVersion());
                    }
                }
                if (element.getDescription() == null) continue;
                this._eb.addDescriptionToCurrentReference(element.getDescription(), "en");
            }
            catch (IOException fnfe) {
                _log.fatal("Attachment not found:{}", (Object)fnfe.getMessage());
                throw new SOAPException("Attachment file not found:" + fnfe.getMessage());
            }
            catch (URISyntaxException e) {
                _log.fatal("Attachment ContentId is not valid: {} {}", contentId, (Object)e.getMessage());
                throw new SOAPException("Attachment ContentId is not valid: " + (String)contentId);
            }
        }
        String ebXmlAckRequested = null;
        try {
            ebXmlAckRequested = this._xpMessage.getCommunication().getPackagingOptionValue("/RequestAck");
            boolean signedAck = SIGNED.equalsIgnoreCase(ebXmlAckRequested);
            if (_log.isDebugEnabled()) {
                if (signedAck) {
                    _log.debug("a signed ACK is requested");
                } else {
                    _log.debug("an ACK is requested");
                }
            }
            this._eb.setAckRequested(signedAck, null);
            this._xpMessage.setAckRequested(true);
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (this._xpMessage.getSequenceNumber() != -1 && !this._eb.isAckRequested()) {
            _log.warn("AckRequested is OFF in agreement but is switched ON due to MessageOrdering.");
            this._eb.setAckRequested(false, null);
            this._xpMessage.setAckRequested(true);
        }
        this.signMessage();
        this.encryptMessage();
    }

    private void signMessage() throws SOAPException {
        String ebXmlSignature = null;
        try {
            ebXmlSignature = this._xpMessage.getCommunication().getPackagingOptionValue("/XmlSignature");
        }
        catch (OptionNotFoundException e) {
            ebXmlSignature = FALSE;
        }
        if (DEFAULT_INCLUDE_PROCESSING_DIRECTIVES.equalsIgnoreCase(ebXmlSignature)) {
            if (_log.isDebugEnabled()) {
                _log.debug("xml signature needs to be generated");
            }
            this.signMessage(this._xpMessage, this._eb);
        }
    }

    private void signMessage(XpMessage xpMessage, EbXmlMessage eb) throws SOAPException {
        try {
            SignCertInfo signCertInfo = xpMessage.getCommunication().getPackagingSignKey();
            X509Certificate cert = signCertInfo.getCertificateChain()[0];
            if (_log.isDebugEnabled()) {
                _log.debug(this.getCertificateUtility().toUsingInfoText(cert, "used certificate"));
            }
            eb.sign(signCertInfo.getPrivateKey(), signCertInfo.getCertificateChain());
            this.getMessengerLog().log2db(73, xpMessage.getDatabaseId(), this.getCertificateUtility().toUsingInfoText(cert, "used certificate"));
        }
        catch (CertificateIdNotFoundException | GeneralSecurityException e) {
            this.getMessengerLog().log2db(521, xpMessage.getDatabaseId(), e.toString());
            throw new SOAPException("Cannot get private key for localId '" + xpMessage.getSenderLocalId() + "': " + e.getMessage());
        }
        catch (Exception e) {
            this.getMessengerLog().log2db(521, xpMessage.getDatabaseId(), e.getMessage());
            _log.error("unexpected error", (Throwable)e);
            throw new SOAPException("Undefined Problem while signing: " + e.getMessage());
        }
    }

    private void encryptMessage() throws SOAPException {
        String ebXmlEncryption = null;
        try {
            ebXmlEncryption = this._xpMessage.getCommunication().getPackagingOptionValue("/XmlEncryption");
        }
        catch (OptionNotFoundException e) {
            ebXmlEncryption = "unencrypted";
        }
        if (!"unencrypted".equalsIgnoreCase(ebXmlEncryption)) {
            _log.debug("message will be encrypted using xml encryption '{}'", (Object)ebXmlEncryption);
            try {
                this.getMessengerLog().log2db(90, this._xpMessage.getDatabaseId(), null);
            }
            catch (Exception e) {
                this.getMessengerLog().log2db(541, this._xpMessage.getDatabaseId(), e.getMessage());
                _log.error("unexpected error", (Throwable)e);
                throw new SOAPException("Undefined Problem while encrypting: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean handleTransmissionResponse(long messageDataId, ProviderResponse response) {
        byte[] message = response.getResponseMessage();
        String protocol = response.getProtocol();
        Map<String, String> header = response.getHeaders();
        if (header != null && message != null && message.length > 0) {
            SyncReply reply = new SyncReply(messageDataId, header, message, protocol);
            return reply.process();
        }
        _log.trace("sync response contained no content !");
        return !response.isFailed();
    }

    @Override
    public UIOption[] getUIOptions() {
        return this.getEbXml20UIOptions().getUIOptions();
    }

    private String getCPAId(XpMessage xpMessage) {
        String ebXmlCpaId = null;
        try {
            ebXmlCpaId = xpMessage.getCommunication().getPackagingOptionValue("/CpaId");
        }
        catch (OptionNotFoundException e2) {
            ebXmlCpaId = this.getEbXml20UIOptions().getDefaultCpaId();
        }
        return ebXmlCpaId;
    }

    @Override
    public XpMessage createErrorResponse(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)DEFAULT_INCLUDE_PROCESSING_DIRECTIVES);
            msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            EbXmlMessage ebXmlResponse = new EbXmlMessage(msg, this.getReferenceDate());
            ebXmlResponse.prepareErrorMessage(xpResponse.getReferenceId());
            ebXmlResponse.setCPAId(this.getCPAId(xpResponse));
            ebXmlResponse.setConversationId(xpResponse.getConversationId());
            this.setPartyIds(ebXmlResponse, xpResponse);
            ebXmlResponse.setMessageId(xpResponse.getMessageId());
            ebXmlResponse.setMessageTimestamp(xpResponse.getMessageTimestamp());
            this.mapErrorCodes(result, ebXmlResponse);
            this.getMessengerLog().log2db(79, xpResponse.getDatabaseId(), PACKAGERNAME);
            if (signed) {
                _log.debug("sender requested a signed ACK");
                try {
                    this.signMessage(xpResponse, ebXmlResponse);
                }
                catch (Exception e) {
                    _log.warn("Ack could not be signed: " + String.valueOf(e));
                }
            }
            this.storeResponse(xpResponse.getCurrentContentReferenceFolder(), ebXmlResponse, xpResponse);
            File messageFile = new File(xpResponse.getCurrentContentReferenceFolder(), "xp_message.dat");
            File messageHeaderFile = new File(xpResponse.getCurrentContentReferenceFolder(), "xp_message_header.dat");
            this._eb = ebXmlResponse;
            this._xpMessage = xpResponse;
            this._message = this._eb.getMessage();
            this._headers = this._message.getMimeHeaders();
            this.storeTransmissionFormat(messageFile, messageHeaderFile);
        }
        catch (SOAPException e) {
            throw new PackagingException(24010, (Throwable)e);
        }
        catch (EbXmlResponseException e) {
            throw new PackagingException(24010, e.getMessage(), e);
        }
        return xpResponse;
    }

    private void mapErrorCodes(List<ProcessingResult> result, EbXmlMessage response) {
        if (result.size() > 0) {
            for (ProcessingResult procResult : result) {
                int code = procResult.getResultCode();
                if (procResult.getResultCode() == 0) continue;
                switch (code) {
                    case 2: 
                    case 4: {
                        response.addError("Error", "SecurityFailure", procResult.getLocation());
                        break;
                    }
                    case 5: 
                    case 6: {
                        response.addError("Error", "Unknown", procResult.getLocation());
                        break;
                    }
                    case 1: {
                        response.addError("Error", "OtherXml", procResult.getLocation());
                        break;
                    }
                    case 8: {
                        response.addError("Error", "TimeToLiveExpired", procResult.getLocation());
                        break;
                    }
                    default: {
                        response.addError("Warning", "Unknown", procResult.getLocation());
                    }
                }
                response.setDescriptionToCurrentError(procResult.getDescription(), "en");
            }
        }
    }

    private void storeResponse(File folder, EbXmlMessage message, XpMessage xpMessage) throws EbXmlResponseException {
        try {
            _log.debug("storing ebxml response");
            message.saveEbXmlToDisk(folder);
        }
        catch (Exception e) {
            _log.error("problem while storing ebxml response to disk: {}", (Object)e.getMessage());
            throw new EbXmlResponseException(e.toString());
        }
    }

    @Override
    public XpMessage createAsyncAck(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        try {
            SOAPMessage msg = MessageFactory.newInstance().createMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)DEFAULT_INCLUDE_PROCESSING_DIRECTIVES);
            msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            _log.debug("creating ebXML-ACK from processing results");
            EbXmlMessage ebXmlResponse = new EbXmlMessage(msg, this.getReferenceDate());
            ebXmlResponse.prepareAcknowledgment(xpResponse.getReferenceId(), xpResponse.getMessageTimestamp(), null);
            ebXmlResponse.setCPAId(this.getCPAId(xpResponse));
            ebXmlResponse.setConversationId(xpResponse.getConversationId());
            this.setPartyIds(ebXmlResponse, xpResponse);
            ebXmlResponse.setMessageId(xpResponse.getMessageId());
            ebXmlResponse.setMessageTimestamp(xpResponse.getMessageTimestamp());
            this.mapErrorCodes(result, ebXmlResponse);
            this.getMessengerLog().log2db(79, xpResponse.getDatabaseId(), PACKAGERNAME);
            if (signed) {
                _log.debug("sender requested a signed ACK");
                try {
                    this.signMessage(xpResponse, ebXmlResponse);
                }
                catch (Exception e) {
                    _log.warn("Ack could not be signed: " + String.valueOf(e));
                }
            }
            this.storeResponse(xpResponse.getCurrentContentReferenceFolder(), ebXmlResponse, xpResponse);
            File messageFile = new File(xpResponse.getCurrentContentReferenceFolder(), "xp_message.dat");
            File messageHeaderFile = new File(xpResponse.getCurrentContentReferenceFolder(), "xp_message_header.dat");
            this._eb = ebXmlResponse;
            this._xpMessage = xpResponse;
            this._message = this._eb.getMessage();
            this._headers = this._message.getMimeHeaders();
            this.storeTransmissionFormat(messageFile, messageHeaderFile);
        }
        catch (SOAPException e) {
            throw new PackagingException(24011, (Throwable)e);
        }
        catch (EbXmlResponseException e) {
            throw new PackagingException(24011, e.getMessage(), e);
        }
        return xpResponse;
    }

    @Override
    public String getPackagingSignPath() {
        return "/XmlSignature";
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    static {
        _log = LogManager.getLogger((String)"Messenger.EbXml20");
        String ebxmlAttachmentFilename = System.getProperty("ebxml.attachment.filename", FALSE);
        EBXML_ATTACHMENT_FILENAME = Boolean.parseBoolean(ebxmlAttachmentFilename);
    }

    class SyncReply {
        final Map<String, String> _headers;
        final byte[] _syncReplyMessage;
        final String _protocol;
        final long _referenceDatabaseId;

        SyncReply(long referenceDatabaseId, Map<String, String> headers, byte[] message, String protocol) {
            this._referenceDatabaseId = referenceDatabaseId;
            this._headers = headers;
            this._syncReplyMessage = message;
            this._protocol = protocol;
            if (_log.isDebugEnabled()) {
                _log.debug("Created EbXml20.SyncReply object.");
            }
        }

        boolean process() {
            if (_log.isDebugEnabled()) {
                _log.debug("Trying to process the received sync reply.");
            }
            try {
                SoapListener listener = (SoapListener)EbXml20.this.getListenerManager().getListener("SoapListener");
                listener.processSyncResponse(this._headers, this._syncReplyMessage, this._protocol, this._referenceDatabaseId);
                if (_log.isDebugEnabled()) {
                    _log.debug("Processed the received sync reply.");
                }
                return true;
            }
            catch (Exception e) {
                _log.error("Could not processed the received sync reply: " + e.toString());
                return false;
            }
        }
    }
}

