/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public abstract class BasePackager {
    public static final String REQUEST_ACK = "/RequestACK";
    public static final String TRUE = "true";
    public static final String HTTP = "http:";
    public static final String HTTPS = "https:";
    public static final String MAILTO = "mailto:";
    public static final String SMIME = "smime:";
    public static final String FTP = "ftp:";
    public static final String FTPS = "ftps:";
    public static final String X_COPY_OF = "X-CopyOf";
    public static final String X_ORIGINAL_RECEIVER = "X-OriginalReceiver";
    public static final String ALLOW_HEADER_IN_PAYLOAD_HEADER = "X-allow-header-in-payload";
    public static final String ALLOW_HEADER_IN_PAYLOAD_TRUE = "true";
    public static final String ALLOW_HEADER_IN_PAYLOAD_FALSE = "false";
    public static final String TRANSMISSION_FORMAT_FILE = "xp_message.dat";
    public static final String TRANSMISSION_HEADER_FILE = "xp_message_header.dat";
    public static final String ENVELOPE_FILE = "packaging_envelope.xml";
    public static final String HEADERS_FILE = "headers.txt";
    private static final String PLACEHOLDER_TESTFLAG = "%TESTFLAG%";
    private static final Pattern WILDCARD_TESTFLAG = Pattern.compile("(?i)%TESTFLAG%");
    private static final String TESTFLAG_PRODUCTION = "Production";
    private static final String TESTFLAG_TEST = "Test";
    private static final String PLACEHOLDER_MESSAGETYPE = "%MESSAGETYPE%";
    private static final Pattern WILDCARD_MESSAGETYPE = Pattern.compile("(?i)%MESSAGETYPE%");
    private static final String PLACEHOLDER_MESSAGEVERSION = "%MESSAGEVERSION%";
    private static final Pattern WILDCARD_MESSAGEVERSION = Pattern.compile("(?i)%MESSAGEVERSION%");
    private static final String PLACEHOLDER_SCHEMASET = "%SCHEMASET%";
    private static final Pattern WILDCARD_SCHEMASET = Pattern.compile("(?i)%SCHEMASET%");
    private static final String PLACEHOLDER_SENDERID = "%SENDERID%";
    private static final Pattern WILDCARD_SENDERID = Pattern.compile("(?i)%SENDERID%");
    private static final String PLACEHOLDER_SENDER_DISPLAYNAME = "%SENDER_DISPLAYNAME%";
    private static final Pattern WILDCARD_SENDER_DISPLAYNAME = Pattern.compile("(?i)%SENDER_DISPLAYNAME%");
    private static final String PLACEHOLDER_RECEIVERID = "%RECEIVERID%";
    private static final Pattern WILDCARD_RECEIVERID = Pattern.compile("(?i)%RECEIVERID%");
    private static final String PLACEHOLDER_RECEIVER_DISPLAYNAME = "%RECEIVER_DISPLAYNAME%";
    private static final Pattern WILDCARD_RECEIVER_DISPLAYNAME = Pattern.compile("(?i)%RECEIVER_DISPLAYNAME%");
    private static final String PLACEHOLDER_MESSAGEID = "%MESSAGEID%";
    private static final Pattern WILDCARD_MESSAGEID = Pattern.compile("(?i)%MESSAGEID%");
    private static final String PLACEHOLDER_MESSAGEID_WITHOUT_DOMAIN = "%MESSAGEID_WITHOUT_DOMAIN%";
    private static final Pattern WILDCARD_MESSAGEID_WITHOUT_DOMAIN = Pattern.compile("(?i)%MESSAGEID_WITHOUT_DOMAIN%");
    private static final String PLACEHOLDER_CONVERSATIONID = "%CONVERSATIONID%";
    private static final Pattern WILDCARD_CONVERSATIONID = Pattern.compile("(?i)%CONVERSATIONID%");
    private static final String PLACEHOLDER_MESSAGE_CREATION_DATE = "%MESSAGE_CREATION_DATE%";
    private static final Pattern WILDCARD_MESSAGE_CREATION_DATE = Pattern.compile("(?i)%MESSAGE_CREATION_DATE%");
    private static final Pattern WILDCARD_PROCESSING_DIRECTIVES = Pattern.compile("%PROCESSING_DIRECTIVE:(.+?)%");
    private static final DateTimeFormatter CREATION_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private final MessengerConfig _messengerConfig;
    private final ListenerManager _listenerManager;
    private final MessengerLog _messengerLog;
    private final MDNDataDAO _mdnDataDAO;
    private final IPasswordCrypt _passwordCrypt;
    private final KeystoreBean _keystore;
    private final Profiles _profiles;
    private final Agreements _agreements;
    private final IdGenerator _idGenerator;
    private final MessageDAO _messageDAO;
    private final ReferenceDateTask _referenceDate;
    private final IFolders _folders;
    private final ReceiveFromListener _receiveFromListener;
    private final SchemataConfig _schemataConfig;
    private final IMessengerProperties _messengerProperties;
    private final CertificateUtility _certificateUtility;
    private final AS1ObjectFactory _as1ObjectFactory;
    private final AS2ObjectFactory _as2ObjectFactory;
    private final AS3ObjectFactory _as3ObjectFactory;
    private final EbXml20UIOptions _ebXml20UIOptions;
    private final AS4UIOptions _as4UIOptions;
    private final MessageWorkDataDAO _messageWorkDataDAO;

    public BasePackager(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, MessageWorkDataDAO messageWorkDataDAO) {
        this._messengerConfig = messengerConfig;
        this._listenerManager = listenerManager;
        this._messengerLog = messengerLog;
        this._mdnDataDAO = mdnDataDAO;
        this._passwordCrypt = passwordCrypt;
        this._keystore = keystore;
        this._profiles = profiles;
        this._agreements = agreements;
        this._idGenerator = idGenerator;
        this._messageDAO = messageDAO;
        this._referenceDate = referenceDate;
        this._folders = folders;
        this._receiveFromListener = receiveFromListener;
        this._schemataConfig = schemataConfig;
        this._messengerProperties = messengerProperties;
        this._certificateUtility = certificateUtility;
        this._as1ObjectFactory = as1ObjectFactory;
        this._as2ObjectFactory = as2ObjectFactory;
        this._as3ObjectFactory = as3ObjectFactory;
        this._ebXml20UIOptions = ebXml20UIOptions;
        this._as4UIOptions = as4UIOptions;
        this._messageWorkDataDAO = messageWorkDataDAO;
    }

    public boolean handleTransmissionResponse(long messageDataId, ProviderResponse response) {
        XpMessage xpMessageAck = null;
        String replyText = null;
        Map<String, String> headers = response.getHeaders();
        if (headers != null) {
            replyText = headers.get("X-reply-text");
        }
        if (response.isFailed() && replyText == null) {
            return false;
        }
        try {
            xpMessageAck = this.createXpMessageForResponse(messageDataId);
            Communication com = xpMessageAck.getAgreement().getCommunication(xpMessageAck.getReceiverLocalId(), xpMessageAck.getSenderLocalId());
            try {
                if (this.isNoAckNeeded(com)) {
                    return false;
                }
            }
            catch (OptionNotFoundException e) {
                return false;
            }
            this.getMessageDAO().registerMessage(xpMessageAck);
        }
        catch (Exception e) {
            this.getLogger().fatal(e.toString());
            return false;
        }
        xpMessageAck.setIsAck(true);
        try {
            XpAcknowledgment ack = new XpAcknowledgment(xpMessageAck, xpMessageAck.getReferenceId(), xpMessageAck.getRegistrationTimestamp(), xpMessageAck.getMessageTimestamp());
            if (response.isFailed()) {
                if (replyText != null) {
                    ack.setOverallResult("Error");
                    ack.addError("Error", response.getProtocol() + " " + replyText);
                }
            } else {
                ack.setOverallResult("Success");
                ack.addError("Success", "Message was successfully received");
            }
            File ackRef = ack.saveToDisk(new File(this.getFolders().getWorkInboundFolder(), String.valueOf(xpMessageAck.getDatabaseId())));
            xpMessageAck.setCurrentContentReference(ackRef);
            this.getReceiveFromListener().handleMessage(xpMessageAck);
            return true;
        }
        catch (JAXBException e) {
            this.getLogger().debug("could not store Xp-ACK... stop further processing now:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.getLogger().fatal("Acknowledgment could not be processed: {}", (Object)e.getMessage());
        }
        return false;
    }

    protected boolean isNoAckNeeded(Communication communication) throws OptionNotFoundException {
        return !"true".equals(communication.getPackagingOptionValue(REQUEST_ACK));
    }

    private XpMessage createXpMessageForResponse(long messageDataId) throws DbException, AgreementException, ProfileException {
        MessageInfo messageInfo = this.getMessageDAO().getMessageInfo(messageDataId);
        XpMessage ack = new XpMessage();
        ack.setMessageId(this.getIdGenerator().generateMessageId());
        ack.setConversationId(messageInfo.getConversationId());
        ack.setConversationDatabaseId(messageInfo.getConversationDatabaseId());
        ack.setReferenceId(messageInfo.getMessageId());
        ack.setReferenceDatabaseId(messageInfo.getDatabaseId());
        ack.setSenderLocalId(messageInfo.getReceiverId());
        ack.setReceiverLocalId(messageInfo.getSenderId());
        ack.setInboundMessage(true);
        ack.setMessageTimestamp(this.getReferenceDate().getReferenceDate());
        ack.setMessageType("ACK");
        ack.setMessageVersion("2.1");
        ack.setSchemaSet("ponton");
        ack.setMessengerId(messageInfo.getMessengerId());
        ack.setProtocol(messageInfo.getProtocol());
        ack.setMessagePackaging(messageInfo.getPackagingId());
        Agreement agreement = this.getAgreements().getAgreement(ack.getReceiverLocalId(), ack.getSenderLocalId(), true);
        ack.setAgreement(agreement);
        ack.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
        ack.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
        ack.setCommunication(agreement.getCommunication(ack.getSenderLocalId(), ack.getReceiverLocalId()));
        return ack;
    }

    public abstract void storePrequeueingFormat(XpMessage var1, File var2, File var3) throws PackagingException;

    public void storePostqueueingFormat(Communication communication, long ttl, File work) throws PackagingException {
    }

    public abstract XpMessage createAsyncAck(List<ProcessingResult> var1, XpMessage var2, boolean var3) throws PackagingException;

    public abstract XpMessage createErrorResponse(List<ProcessingResult> var1, XpMessage var2, boolean var3) throws PackagingException;

    protected String replaceWildcardValues(XpMessage xpMessage, String str) {
        String value = str;
        if (!value.contains("%")) {
            return value;
        }
        if (value.contains(PLACEHOLDER_MESSAGETYPE)) {
            value = WILDCARD_MESSAGETYPE.matcher(value).replaceAll(xpMessage.getMessageType());
        }
        if (value.contains(PLACEHOLDER_MESSAGEVERSION)) {
            value = WILDCARD_MESSAGEVERSION.matcher(value).replaceAll(xpMessage.getMessageVersion());
        }
        if (value.contains(PLACEHOLDER_SCHEMASET)) {
            value = WILDCARD_SCHEMASET.matcher(value).replaceAll(xpMessage.getSchemaSet());
        }
        if (value.contains(PLACEHOLDER_MESSAGEID)) {
            value = WILDCARD_MESSAGEID.matcher(value).replaceAll(xpMessage.getMessageId());
        }
        if (value.contains(PLACEHOLDER_MESSAGEID_WITHOUT_DOMAIN)) {
            int index = xpMessage.getMessageId().lastIndexOf(64);
            String messageIdWithoutDomain = index > 0 ? xpMessage.getMessageId().substring(0, index) : xpMessage.getMessageId();
            value = WILDCARD_MESSAGEID_WITHOUT_DOMAIN.matcher(value).replaceAll(messageIdWithoutDomain);
        }
        if (value.contains(PLACEHOLDER_MESSAGE_CREATION_DATE)) {
            Date messageCreationTimestamp = xpMessage.getMessageTimestamp();
            value = WILDCARD_MESSAGE_CREATION_DATE.matcher(value).replaceAll(CREATION_TIME_FORMATTER.format(messageCreationTimestamp.toInstant()));
        }
        if (value.contains(PLACEHOLDER_CONVERSATIONID)) {
            value = WILDCARD_CONVERSATIONID.matcher(value).replaceAll(xpMessage.getConversationId());
        }
        if (value.contains(PLACEHOLDER_SENDERID)) {
            value = WILDCARD_SENDERID.matcher(value).replaceAll(xpMessage.getSenderInternalId());
        }
        if (value.contains(PLACEHOLDER_SENDER_DISPLAYNAME)) {
            try {
                value = WILDCARD_SENDER_DISPLAYNAME.matcher(value).replaceAll(this.getProfiles().getProfileForLocalId(xpMessage.getSenderLocalId(), true).getDisplayName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value.contains(PLACEHOLDER_RECEIVERID)) {
            value = WILDCARD_RECEIVERID.matcher(value).replaceAll(xpMessage.getReceiverInternalId());
        }
        if (value.contains(PLACEHOLDER_RECEIVER_DISPLAYNAME)) {
            try {
                value = WILDCARD_RECEIVER_DISPLAYNAME.matcher(value).replaceAll(this.getProfiles().getProfileForLocalId(xpMessage.getReceiverLocalId(), true).getDisplayName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value.contains(PLACEHOLDER_TESTFLAG)) {
            value = xpMessage.isTestMessage() ? WILDCARD_TESTFLAG.matcher(value).replaceAll(TESTFLAG_TEST) : WILDCARD_TESTFLAG.matcher(value).replaceAll(TESTFLAG_PRODUCTION);
        }
        value = this.replaceProcessingDirectives(xpMessage, value);
        return value;
    }

    protected String replaceProcessingDirectives(XpMessage xpMessage, String value) {
        Matcher matcher = WILDCARD_PROCESSING_DIRECTIVES.matcher(value);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String name = matcher.group(1);
            String replacement = xpMessage.getProcessingDirective(name);
            if (Objects.isNull(replacement)) {
                this.getLogger().warn("ProcessingDirective '{}' not found for PlaceHolder '{}' not found", (Object)name, (Object)("%PROCESSING_DIRECTIVE:" + name + "%"));
                replacement = "";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    protected boolean isNotEmpty(String value) {
        return StringUtils.isNotEmpty((CharSequence)value);
    }

    protected boolean isEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value);
    }

    protected abstract Logger getLogger();

    public abstract UIOption[] getUIOptions();

    public String getPackagingEncryptionPath() {
        throw new IllegalAccessError("The packaging doesn't support encryption.");
    }

    public String getPackagingSignPath() {
        return null;
    }

    public String getPackagingAckSignPath() {
        return this.getPackagingSignPath();
    }

    protected MessengerConfig getMessengerConfig() {
        return this._messengerConfig;
    }

    protected ListenerManager getListenerManager() {
        return this._listenerManager;
    }

    protected MessengerLog getMessengerLog() {
        return this._messengerLog;
    }

    protected MDNDataDAO getMdnDataDAO() {
        return this._mdnDataDAO;
    }

    protected IPasswordCrypt getPasswordCrypt() {
        return this._passwordCrypt;
    }

    protected PontonKeystore getKeystore() {
        return this._keystore.getKeystore();
    }

    protected Profiles getProfiles() {
        return this._profiles;
    }

    protected IdGenerator getIdGenerator() {
        return this._idGenerator;
    }

    protected MessageDAO getMessageDAO() {
        return this._messageDAO;
    }

    protected ReferenceDateTask getReferenceDate() {
        return this._referenceDate;
    }

    protected IFolders getFolders() {
        return this._folders;
    }

    protected ReceiveFromListener getReceiveFromListener() {
        return this._receiveFromListener;
    }

    protected Agreements getAgreements() {
        return this._agreements;
    }

    public AS1ObjectFactory getAs1ObjectFactory() {
        return this._as1ObjectFactory;
    }

    public AS2ObjectFactory getAs2ObjectFactory() {
        return this._as2ObjectFactory;
    }

    public AS3ObjectFactory getAs3ObjectFactory() {
        return this._as3ObjectFactory;
    }

    protected EbXml20UIOptions getEbXml20UIOptions() {
        return this._ebXml20UIOptions;
    }

    protected AS4UIOptions getAS4UIOptions() {
        return this._as4UIOptions;
    }

    protected SchemataConfig getSchemataConfig() {
        return this._schemataConfig;
    }

    protected IMessengerProperties getMessengerProperties() {
        return this._messengerProperties;
    }

    protected CertificateUtility getCertificateUtility() {
        return this._certificateUtility;
    }

    protected MessageWorkDataDAO getMessageWorkDataDAO() {
        return this._messageWorkDataDAO;
    }
}

