/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;

public class AttachmentCallbackHandler
implements CallbackHandler {
    private final List<Attachment> originalRequestAttachments;
    private final Map<String, Attachment> attachmentMap = new HashMap<String, Attachment>();
    private final List<Attachment> responseAttachments = new ArrayList<Attachment>();

    public AttachmentCallbackHandler() {
        this.originalRequestAttachments = new ArrayList<Attachment>();
    }

    public AttachmentCallbackHandler(List<Attachment> attachments) {
        this.originalRequestAttachments = attachments;
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                this.attachmentMap.put(attachment.getId(), attachment);
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof AttachmentRequestCallback) {
                AttachmentRequestCallback attachmentRequestCallback = (AttachmentRequestCallback)callbacks[i];
                List<Attachment> attachments = this.getAttachmentsToAdd(attachmentRequestCallback.getAttachmentId());
                if (attachments.isEmpty()) {
                    throw new RuntimeException("wrong attachment requested");
                }
                attachmentRequestCallback.setAttachments(attachments);
                continue;
            }
            if (callbacks[i] instanceof AttachmentResultCallback) {
                AttachmentResultCallback attachmentResultCallback = (AttachmentResultCallback)callbacks[i];
                this.responseAttachments.add(attachmentResultCallback.getAttachment());
                this.attachmentMap.put(attachmentResultCallback.getAttachment().getId(), attachmentResultCallback.getAttachment());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public List<Attachment> getResponseAttachments() {
        return this.responseAttachments;
    }

    private List<Attachment> getAttachmentsToAdd(String id) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (this.attachmentMap.containsKey(id)) {
            attachments.add(this.attachmentMap.get(id));
        } else if (this.originalRequestAttachments != null) {
            attachments.addAll(this.originalRequestAttachments);
        }
        return attachments;
    }
}

