/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import jakarta.mail.internet.ContentType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncSoapResponseSender {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.AsyncSoapResponseSender");
    private final OutboundQueue _outboundMessageQueue;

    public AsyncSoapResponseSender(OutboundQueue outboundMessageQueue) {
        this._outboundMessageQueue = outboundMessageQueue;
    }

    public void addToOutboundQueue(SOAPMessage response, XpMessage responseXpMessage) {
        File work = responseXpMessage.getCurrentContentReferenceFolder();
        File messageFile = new File(work, "xp_message.dat");
        File messageHeaderFile = new File(work, "xp_message_header.dat");
        MimeHeaders mimeHeaders = response.getMimeHeaders();
        String lowercaseUrl = null;
        try {
            FilterOutputStream out;
            Communication responseSettings = responseXpMessage.getCommunication();
            String destinationURL = responseSettings.getTransportURL();
            responseXpMessage.setDestinationUrl(destinationURL);
            responseXpMessage.setProtocol(destinationURL.split(":")[0].toUpperCase());
            lowercaseUrl = destinationURL.toLowerCase();
            if (response.countAttachments() > 0) {
                try {
                    String[] cTypes = mimeHeaders.getHeader("Content-Type");
                    ContentType contentType = new ContentType(cTypes[0]);
                    contentType.setParameter("start", "<" + responseXpMessage.getMessageId() + ">");
                    mimeHeaders.setHeader("Content-Type", contentType.toString());
                }
                catch (Exception e) {
                    _log.warn("Could not update Content-Type:{}", (Object)e.getMessage());
                }
            }
            if (lowercaseUrl.startsWith("mailto:") || lowercaseUrl.startsWith("smime:")) {
                mimeHeaders.setHeader("Content-Transfer-Encoding", "base64");
            }
            try (BufferedOutputStream outHeaders = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));
                 ObjectOutputStream oos = new ObjectOutputStream(outHeaders);){
                Map<String, String> header2 = MimeMultipartUtils.convertMimeHeadersToHashMap(mimeHeaders);
                oos.writeObject(header2);
            }
            String[] contentTransferEncodingHeader = mimeHeaders.getHeader("Content-Transfer-Encoding");
            if (contentTransferEncodingHeader != null && contentTransferEncodingHeader.length > 0 && "base64".equalsIgnoreCase(mimeHeaders.getHeader("Content-Transfer-Encoding")[0])) {
                out = new Base64Encoder(new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0])));
                try {
                    response.writeTo((OutputStream)out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            out = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
            try {
                response.writeTo((OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
            _log.debug("sending Async response");
            if (responseXpMessage.getAdapterId() == null) {
                responseXpMessage.setAdapterId("NullAdapter");
            }
            this._outboundMessageQueue.deliverMessageToPartner(responseXpMessage);
        }
        catch (IOException e) {
            _log.error("cannot store data for outbound queue", (Throwable)e);
        }
        catch (SOAPException e) {
            _log.error("SOAP Message cannot be created", (Throwable)e);
        }
    }
}

