/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.jaxb.as4.AgreementRef;
import de.pontonconsulting.xmlpipe.jaxb.as4.Body;
import de.pontonconsulting.xmlpipe.jaxb.as4.CollaborationInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.Description;
import de.pontonconsulting.xmlpipe.jaxb.as4.Envelope;
import de.pontonconsulting.xmlpipe.jaxb.as4.From;
import de.pontonconsulting.xmlpipe.jaxb.as4.Header;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageProperties;
import de.pontonconsulting.xmlpipe.jaxb.as4.Messaging;
import de.pontonconsulting.xmlpipe.jaxb.as4.ObjectFactory;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartProperties;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartyId;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartyInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.PayloadInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.Property;
import de.pontonconsulting.xmlpipe.jaxb.as4.Schema;
import de.pontonconsulting.xmlpipe.jaxb.as4.Service;
import de.pontonconsulting.xmlpipe.jaxb.as4.To;
import de.pontonconsulting.xmlpipe.jaxb.as4.UserMessage;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4GZIPDataSource;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Message;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Payload;
import de.pontonconsulting.xmlpipe.messenger.packaging.JAXBToSOAPConverter;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.util.SkipMimeHeaderDataSource;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.lang3.StringUtils;

public class AS4ToSOAPConverter {
    private static final String CID = "cid:";
    private static final String ENGLISH = "en";
    private static final String PROPERTY_AS4_DEFAULT_FROM_ROLE = "ponton.as4.default.role.from";
    private static final String PROPERTY_AS4_DEFAULT_TO_ROLE = "ponton.as4.default.role.to";
    private static final String DEFAULT_ROLE = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultRole";
    private final ObjectFactory _as4ObjectFactory;
    private final JAXBToSOAPConverter _jaxbToSOAPConverter;
    private final IdGenerator _idGenerator;
    private final IMessengerProperties _messengerProperties;

    public AS4ToSOAPConverter(ObjectFactory as4ObjectFactory, JAXBToSOAPConverter jaxbToSOAPConverter, IdGenerator idGenerator, IMessengerProperties messengerProperties) {
        this._as4ObjectFactory = as4ObjectFactory;
        this._jaxbToSOAPConverter = jaxbToSOAPConverter;
        this._idGenerator = idGenerator;
        this._messengerProperties = messengerProperties;
    }

    public SOAPMessage convert(AS4Message as4Message) throws PackagingException {
        UserMessage userMessage = this._as4ObjectFactory.createUserMessage();
        userMessage.setMessageInfo(this.createMessageInfo(as4Message));
        userMessage.setPartyInfo(this.createPartyInfo(as4Message));
        userMessage.setCollaborationInfo(this.createCollaborationInfo(as4Message));
        userMessage.setMessageProperties(this.createMessageProperties(as4Message));
        Messaging messaging = this._as4ObjectFactory.createMessaging();
        messaging.setMustUnderstand(true);
        messaging.setId(this._idGenerator.getSoapId());
        messaging.getUserMessage().add(userMessage);
        Header header = this._as4ObjectFactory.createHeader();
        header.getAny().add(messaging);
        Body body = this._as4ObjectFactory.createBody();
        Envelope envelope = this._as4ObjectFactory.createEnvelope();
        envelope.setHeader(header);
        envelope.setBody(body);
        return this.finalizeAS4Message(as4Message, envelope, messaging);
    }

    private MessageInfo createMessageInfo(AS4Message as4Message) {
        MessageInfo messageInfo = this._as4ObjectFactory.createMessageInfo();
        messageInfo.setTimestamp(as4Message.getTimestamp());
        messageInfo.setMessageId(as4Message.getMessageId());
        return messageInfo;
    }

    private PartyInfo createPartyInfo(AS4Message as4Message) throws PackagingException {
        PartyInfo partyInfo = this._as4ObjectFactory.createPartyInfo();
        From from = this._as4ObjectFactory.createFrom();
        this.setPartyIds(as4Message.getFromParties(), from.getPartyId());
        if (from.getPartyId().isEmpty()) {
            throw new PackagingException(-1, "At least one From-PartyId has to be created.");
        }
        String fromRole = as4Message.getFromRole();
        if (fromRole != null && !fromRole.isEmpty()) {
            from.setRole(fromRole);
        } else {
            from.setRole(this._messengerProperties.getProperty(PROPERTY_AS4_DEFAULT_FROM_ROLE, DEFAULT_ROLE));
        }
        partyInfo.setFrom(from);
        To to = this._as4ObjectFactory.createTo();
        this.setPartyIds(as4Message.getToParties(), to.getPartyId());
        if (to.getPartyId().isEmpty()) {
            throw new PackagingException(-1, "At least one To-PartyId has to be created.");
        }
        String toRole = as4Message.getToRole();
        if (toRole != null && !toRole.isEmpty()) {
            to.setRole(toRole);
        } else {
            to.setRole(this._messengerProperties.getProperty(PROPERTY_AS4_DEFAULT_TO_ROLE, DEFAULT_ROLE));
        }
        partyInfo.setTo(to);
        return partyInfo;
    }

    private void setPartyIds(Map<String, String> fromParties, List<PartyId> objectPartyIdList) {
        fromParties.forEach((type, value) -> {
            PartyId partyId = this._as4ObjectFactory.createPartyId();
            partyId.setType(type);
            partyId.setValue(value);
            objectPartyIdList.add(partyId);
        });
    }

    private CollaborationInfo createCollaborationInfo(AS4Message as4Message) throws PackagingException {
        CollaborationInfo collaborationInfo = this._as4ObjectFactory.createCollaborationInfo();
        collaborationInfo.setService(this.createService(as4Message));
        collaborationInfo.setAction(this.createAction(as4Message));
        collaborationInfo.setAgreementRef(this.createAgreementRef(as4Message));
        collaborationInfo.setConversationId(as4Message.getConversationId());
        return collaborationInfo;
    }

    private Service createService(AS4Message as4Message) throws PackagingException {
        Service service = this._as4ObjectFactory.createService();
        String as4Service = as4Message.getService();
        if (as4Service == null || as4Service.isEmpty()) {
            throw new PackagingException(-1, "Service must be set.");
        }
        service.setValue(this.replaceWildcardValues(as4Service));
        String as4ServiceType = as4Message.getServiceType();
        if (as4ServiceType != null && !as4ServiceType.isEmpty()) {
            service.setType(as4ServiceType);
        }
        return service;
    }

    private String replaceWildcardValues(String as4Service) {
        return as4Service;
    }

    private String createAction(AS4Message as4Message) throws PackagingException {
        String as4Action = as4Message.getAction();
        if (as4Action == null || as4Action.isEmpty()) {
            throw new PackagingException(-1, "Action must be defined.");
        }
        return this.replaceWildcardValues(as4Action);
    }

    private AgreementRef createAgreementRef(AS4Message as4Message) {
        String agreementRef = as4Message.getAgreementRef();
        if (StringUtils.isBlank((CharSequence)agreementRef)) {
            return null;
        }
        AgreementRef result = this._as4ObjectFactory.createAgreementRef();
        result.setValue(agreementRef);
        result.setType(as4Message.getAgreementRefType());
        result.setPmode(as4Message.getAgreementRefPMode());
        return result;
    }

    private MessageProperties createMessageProperties(AS4Message as4Message) {
        MessageProperties messageProperties = null;
        Map<String, String> messageRelatedProcessingDirectives = as4Message.getMessageProperties();
        if (!messageRelatedProcessingDirectives.isEmpty()) {
            messageProperties = this._as4ObjectFactory.createMessageProperties();
            this.setProperties(messageRelatedProcessingDirectives, messageProperties.getProperty());
        }
        return messageProperties;
    }

    private void setProperties(Map<String, String> processingDirectives, List<Property> objectPropertyList) {
        processingDirectives.forEach((name, value) -> {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Property property = this._as4ObjectFactory.createProperty();
                property.setName(name);
                property.setValue(value);
                objectPropertyList.add(property);
            }
        });
    }

    private PayloadInfo getPayloadInfo(Messaging messaging) {
        List userMessages = messaging.getUserMessage();
        UserMessage userMessage = (UserMessage)userMessages.getFirst();
        PayloadInfo payloadInfo = userMessage.getPayloadInfo();
        if (payloadInfo == null) {
            payloadInfo = this._as4ObjectFactory.createPayloadInfo();
            userMessage.setPayloadInfo(payloadInfo);
        }
        return payloadInfo;
    }

    private Schema createSchema(AS4Message as4Message) {
        Schema schema = null;
        if (as4Message.getSchemaLocation() != null && !as4Message.getSchemaLocation().isEmpty()) {
            schema = this._as4ObjectFactory.createSchema();
            schema.setLocation(as4Message.getSchemaLocation());
            schema.setNamespace(as4Message.getSchemaNamespace());
            schema.setVersion(as4Message.getSchemaVersion());
        }
        return schema;
    }

    private PartProperties createPartProperties(AS4Payload as4Payload) {
        PartProperties partProperties = null;
        TreeMap<String, String> payloadRelatedProcessingDirectives = new TreeMap<String, String>(as4Payload.getProperties());
        payloadRelatedProcessingDirectives.put(AS4ProcessorHelper.PARTINFO_PROPERTY_MIME_TYPE, as4Payload.getContentType());
        if (as4Payload.isCompressed()) {
            payloadRelatedProcessingDirectives.put(AS4ProcessorHelper.PARTINFO_PROPERTY_COMPRESSION_TYPE, "application/gzip");
        }
        partProperties = this._as4ObjectFactory.createPartProperties();
        this.setProperties(payloadRelatedProcessingDirectives, partProperties.getProperty());
        return partProperties;
    }

    private SOAPMessage finalizeAS4Message(AS4Message as4Message, Envelope envelope, Messaging messaging) throws PackagingException {
        SOAPMessage soapMessage;
        List<AS4Payload> payloads = as4Message.getPayloads();
        if (!payloads.isEmpty()) {
            PayloadInfo payloadInfo = this.getPayloadInfo(messaging);
            AS4Payload as4Payload = payloads.getFirst();
            PartInfo partInfo = this._as4ObjectFactory.createPartInfo();
            partInfo.setHref(CID + as4Payload.getContentId());
            partInfo.setSchema(this.createSchema(as4Message));
            Description description = this._as4ObjectFactory.createDescription();
            description.setLang(ENGLISH);
            description.setValue("Payload");
            partInfo.setDescription(description);
            partInfo.setPartProperties(this.createPartProperties(as4Payload));
            payloadInfo.getPartInfo().add(partInfo);
            for (int i = 1; i < payloads.size(); ++i) {
                AS4Payload attachment = payloads.get(i);
                PartInfo attachmentPartInfo = this._as4ObjectFactory.createPartInfo();
                attachmentPartInfo.setHref(CID + attachment.getContentId());
                Description attachmentDescription = this._as4ObjectFactory.createDescription();
                attachmentDescription.setLang(ENGLISH);
                attachmentDescription.setValue("Attachment");
                attachmentPartInfo.setDescription(attachmentDescription);
                payloadInfo.getPartInfo().add(attachmentPartInfo);
            }
        }
        try {
            soapMessage = this._jaxbToSOAPConverter.convertEnvelope(envelope, true);
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            soapMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (Exception e) {
            throw new PackagingException(-1, "Could not create SOAP Message.", e);
        }
        for (AS4Payload attachment : payloads) {
            try {
                this.addAttachmentToSoapMessage(soapMessage, attachment);
            }
            catch (IOException e) {
                throw new PackagingException(-1, "Could not add an attachment to SOAP Message.", e);
            }
        }
        return soapMessage;
    }

    private void addAttachmentToSoapMessage(SOAPMessage soapMessage, AS4Payload attachment) throws IOException {
        String as4Filename;
        try {
            as4Filename = MimeUtility.encodeText((String)attachment.getFileName());
        }
        catch (UnsupportedEncodingException ex) {
            as4Filename = attachment.getFileName();
        }
        AttachmentPart ap = soapMessage.createAttachmentPart();
        ap.setContentId(attachment.getContentId());
        ap.setMimeHeader("Content-Disposition", "attachment; filename=\"" + as4Filename + "\"");
        String contentType = attachment.getContentType();
        DataSource dataSource = contentType != null && !contentType.isEmpty() && contentType.toLowerCase().startsWith("multipart") ? new SkipMimeHeaderDataSource(contentType, attachment.getContentFile()) : new SimpleFileDataSource(contentType, attachment.getContentFile());
        if (attachment.isCompressed()) {
            dataSource = new AS4GZIPDataSource(dataSource, attachment.getContentFile());
            attachment.setCompressedSize(((AS4GZIPDataSource)dataSource).getCompressedSize());
        }
        ap.setDataHandler(new DataHandler(dataSource));
        soapMessage.addAttachmentPart(ap);
    }
}

