/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.validate;

public class ValidationResult {
    private static final String TEXT_UNKNOWN = "UNKNOWN: ";
    private static final String TEXT_FATAL = "FATAL: ";
    private static final String TEXT_ERROR = "ERROR: ";
    private static final String TEXT_WARNING = "WARNING: ";
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int FATAL = 2;
    private final int _level;
    private final int _line;
    private final int _column;
    private final String _description;

    public ValidationResult(int level, int line, int column, String description) {
        this._level = level;
        this._line = line;
        this._column = column;
        this._description = description;
    }

    public int getColumn() {
        return this._column;
    }

    public String getDescription() {
        return this._description;
    }

    public int getLevel() {
        return this._level;
    }

    public String getLevelText() {
        switch (this._level) {
            case 0: {
                return TEXT_WARNING;
            }
            case 1: {
                return TEXT_ERROR;
            }
            case 2: {
                return TEXT_FATAL;
            }
        }
        return TEXT_UNKNOWN;
    }

    public int getLine() {
        return this._line;
    }

    public String toString() {
        return "ValidationResult [_level=" + this._level + ", _line=" + this._line + ", _column=" + this._column + ", _description=" + this._description + "]";
    }
}

