/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.validate;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class SchemaResolver
implements LSResourceResolver {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.SchemaResolver");
    private final ConfigResourceService configResourceService;
    private final String schemaFolder;
    private final DOMImplementationLS domImplementationLS;

    public SchemaResolver(ConfigResourceService configResourceService, String schemaFolder) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.configResourceService = configResourceService;
        this.schemaFolder = schemaFolder;
        this.domImplementationLS = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Objects.requireNonNull(systemId, "SystemId");
        try {
            URI schemaURI = new URI(systemId);
            String schemaPath = schemaURI.getPath();
            File schemaFile = new File(schemaPath);
            String schemaFileName = systemId;
            if (schemaURI.getHost() != null) {
                schemaFileName = schemaFile.getName();
            }
            try {
                return this.getLsInput(publicId, systemId, baseURI, schemaFileName);
            }
            catch (IOException e) {
                return this.getLsInput(publicId, systemId, baseURI, schemaFile.getName());
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.error("could not resolve schema {}: {}", (Object)systemId, (Object)e.toString());
            throw new RuntimeException("Resource '" + systemId + "' cannot be resolved. Did not find local file " + e.getMessage());
        }
    }

    private LSInput getLsInput(String publicId, String systemId, String baseURI, String schemaName) throws IOException {
        if (baseURI != null) {
            String parentPath = baseURI.substring(0, baseURI.lastIndexOf(47));
            Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(parentPath + "/" + schemaName);
            LOG.trace("resolved schema {} at {}", (Object)schemaName, (Object)resourceAsStream.getKey());
            LSInput input = this.domImplementationLS.createLSInput();
            input.setByteStream(resourceAsStream.getValue());
            input.setPublicId(publicId);
            input.setBaseURI(baseURI);
            input.setSystemId(resourceAsStream.getKey().toString());
            return input;
        }
        Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(this.schemaFolder + "/" + schemaName);
        LOG.trace("resolved schema {} at {}", (Object)schemaName, (Object)resourceAsStream.getKey());
        LSInput input = this.domImplementationLS.createLSInput();
        input.setPublicId(publicId);
        input.setBaseURI(baseURI);
        input.setSystemId(resourceAsStream.getKey().toString());
        input.setByteStream(resourceAsStream.getValue());
        return input;
    }
}

