/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateInfo;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public abstract class Verifier
extends BaseFilterPlugin {
    private static final int ERROR_NUMBER_SIGNATURE_DOESNT_MATCH_AGREEMENT = 19012;
    private String _usedAlgorithm;
    private String _usedHashAlgorithm;
    private String _cmsAlgorithm;
    private final RegistryProfileUpdater registryProfileUpdater;
    private final CertificateUtility _certificateUtility;
    private boolean isECPublicKey;

    public Verifier(String pluginName, RegistryProfileUpdater registryProfileUpdater, CertificateUtility certificateUtility, MessengerLog messengerLog) throws BaseFilterException {
        super(pluginName, messengerLog);
        this.registryProfileUpdater = registryProfileUpdater;
        this._certificateUtility = certificateUtility;
    }

    protected void setSignatureAlgorithm(String option_value_sha12, String processing_value_hash_algorithm_sha1, String cmsAlgorithm) throws BaseFilterException {
        try {
            this._usedAlgorithm = option_value_sha12;
            this._usedHashAlgorithm = processing_value_hash_algorithm_sha1;
            this._cmsAlgorithm = cmsAlgorithm;
            Signature.getInstance(option_value_sha12, "BC");
        }
        catch (GeneralSecurityException e) {
            throw new BaseFilterException(15011, e);
        }
    }

    public void doFilter(XpMessage message) throws SignatureException {
        CppPartner sender;
        String signOption = null;
        try {
            signOption = message.getCommunication().getPipelineOptionValueForMessage("/sign", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        File sigFile = message.getSignatureReference();
        if (sigFile == null) {
            if (signOption == null || signOption.isBlank()) {
                return;
            }
            String errorMsg = "Message should be signed, but is not signed.";
            this.messageLog(504, message.getDatabaseId(), message.getMessageId(), "Message should be signed, but is not signed.");
            throw new SignatureException(19005, "Message should be signed, but is not signed.");
        }
        if (signOption == null || signOption.isBlank()) {
            String errorMsg = "Message is signed, but signing is disabled in agreement.";
            this.messageLog(504, message.getDatabaseId(), message.getMessageId(), "Message is signed, but signing is disabled in agreement.");
            throw new SignatureException(19010, "Message is signed, but signing is disabled in agreement.");
        }
        try {
            sender = message.getSender();
        }
        catch (ProfileException pe) {
            throw new SignatureException(23002, new String[]{message.getSenderLocalId()}, pe);
        }
        try {
            this.checkSignature(message, sigFile, sender);
        }
        catch (SignatureException e) {
            this.tryToUpdateProfileFromRegistryAndRevalidate(message, sigFile, sender, e);
        }
    }

    private void tryToUpdateProfileFromRegistryAndRevalidate(XpMessage message, File sigFile, CppPartner sender, SignatureException e) throws SignatureException {
        CppPartner updated;
        if (sender.isFromRegistry() && sender.isAutoupdate() && (updated = this.registryProfileUpdater.updateProfile(sender)) != null) {
            this._log.debug("verifying signature with new certificates of updated profile");
            this.checkSignature(message, sigFile, updated);
            return;
        }
        throw e;
    }

    private void checkSignature(XpMessage message, File sigFile, CppPartner sender) throws SignatureException {
        try {
            X509CertificateHolder senderCertificate;
            Set<X509Certificate> senderCerts = sender.getAllCertificates();
            if (senderCerts.isEmpty()) {
                this._log.error("No certificate installed for sender '{}'", (Object)sender.getDisplayName());
                throw new SignatureException(19013, "No certificate installed for sender.");
            }
            boolean pkcs7 = false;
            try {
                pkcs7 = Boolean.parseBoolean(message.getCommunication().getPipelineOptionValueForMessage("/sign/PKCS7-signed-data", message.getSchemaLocation()));
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            Object signatureFilename = message.getCurrentContentReference().getName();
            if (pkcs7) {
                if (!((String)signatureFilename).endsWith(".p7s")) {
                    signatureFilename = (String)signatureFilename + ".p7s";
                }
                senderCertificate = this.verifyPkcs7Signature(message.getSignatureReference(), message.getCurrentContentReference(), senderCerts, message);
            } else {
                String signatureFileExt;
                senderCertificate = this.verifyRawSignature(message.getSignatureReference(), message.getCurrentContentReference(), senderCerts, message);
                String string = signatureFileExt = this.isECPublicKey ? "." + this._usedAlgorithm + ".ecdsa" : "." + this._usedAlgorithm + ".rsa";
                if (!((String)signatureFilename).endsWith(signatureFileExt)) {
                    signatureFilename = (String)signatureFilename + signatureFileExt;
                }
            }
            this._log.info("Message Signature successfully verified. ");
            X509Certificate cert = CryptoUtil.createCertificate(senderCertificate);
            String andCertificateText = this._certificateUtility.toUsingInfoText(cert, " and certificate");
            if (this._log.isDebugEnabled()) {
                this._log.debug("used {}{}", (Object)this._usedAlgorithm, (Object)andCertificateText);
            }
            this.messageLog(71, message.getDatabaseId(), message.getMessageId(), "using " + this._usedAlgorithm + andCertificateText);
            if (this.isECPublicKey) {
                message.setProcessingDirective("SignatureAlgorithm", "ecdsa");
            } else {
                message.setProcessingDirective("SignatureAlgorithm", "rsa");
            }
            message.setProcessingDirective("HashAlgorithm", this._usedHashAlgorithm);
            File newSigFile = new File(sigFile.getParent(), (String)signatureFilename);
            if (!sigFile.renameTo(newSigFile)) {
                throw new IOException("Could not rename file " + sigFile.getAbsolutePath() + " to " + String.valueOf(newSigFile));
            }
            File certificateFile = new File(message.getCurrentContentReferenceFolder(), sender.getLocalId() + ".cer");
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(certificateFile.toPath(), new OpenOption[0]));){
                out.write(senderCertificate.getEncoded());
                out.flush();
            }
            catch (IOException ioe) {
                this._log.warn("could not store certificate: {}", (Object)ioe.getMessage());
            }
        }
        catch (LocalizedException e) {
            this._log.fatal("Error while verifying signature: {}", (Object)e.getMessage());
            this.messageLog(504, message.getDatabaseId(), message.getMessageId(), e.getMessage());
            throw new SignatureException(19008, "Error while verifying signature: " + e.getMessage());
        }
        catch (IOException | CertificateException | OperatorCreationException e) {
            this._log.fatal("Error while verifying signature: {},", (Object)e.toString());
            this.messageLog(504, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new SignatureException(19008, "Error while verifying signature: " + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected X509CertificateHolder verifyPkcs7Signature(File signatureFile, File contentFile, Collection<X509Certificate> certs, XpMessage message) throws SignatureException, OperatorCreationException {
        X509CertificateHolder usedCertificate = null;
        try (BufferedInputStream sigStream = new BufferedInputStream(Files.newInputStream(signatureFile.toPath(), new OpenOption[0]));){
            X509CertificateHolder x509CertificateHolder;
            try (BufferedInputStream dataStream = new BufferedInputStream(Files.newInputStream(contentFile.toPath(), new OpenOption[0]));){
                CMSTypedStream cmsDataStream = new CMSTypedStream((InputStream)dataStream);
                CMSSignedDataParser sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), cmsDataStream, (InputStream)sigStream);
                sp.getSignedContent().drain();
                SignerInformationStore signers = sp.getSignerInfos();
                Collection c = signers.getSigners();
                Iterator it = c.iterator();
                ArrayList<CertificateInfo> unknownCertificates = new ArrayList<CertificateInfo>();
                boolean signatureIsOk = false;
                boolean signatureFound = false;
                block17: while (it.hasNext() && !signatureFound) {
                    SignerInformation signer = (SignerInformation)it.next();
                    SignerId id = signer.getSID();
                    for (X509Certificate cert : certs) {
                        if (CryptoUtil.isPrincipalsEqual(id.getIssuer(), cert.getIssuerX500Principal()) && cert.getSerialNumber().equals(id.getSerialNumber())) {
                            signatureFound = true;
                            if (this._cmsAlgorithm.equals(signer.getDigestAlgOID())) {
                                X509CertificateHolder certHolder = CryptoUtil.createCertificateHolder(cert);
                                try {
                                    signatureIsOk = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certHolder));
                                    this.isECPublicKey = cert.getPublicKey() instanceof ECPublicKey;
                                }
                                catch (GeneralSecurityException e) {
                                    this._log.debug("could not verify signature for certificate {}: {}", (Object)certHolder.getSubject().toString(), (Object)e);
                                }
                                usedCertificate = certHolder;
                                continue block17;
                            }
                            throw new SignatureException(19012, "Different signature and hash algorithm used, than defined in agreement.");
                        }
                        unknownCertificates.add(new CertificateInfo(id.getIssuer(), id.getSerialNumber()));
                    }
                }
                if (!signatureFound) {
                    throw new SignatureException(19007, this._certificateUtility.getSignatureUnknownErrorTextFor(unknownCertificates));
                }
                if (!signatureIsOk) {
                    throw new SignatureException(19007, "Signature is not valid !");
                }
                x509CertificateHolder = usedCertificate;
            }
            return x509CertificateHolder;
        }
        catch (ClassCastException c) {
            throw new SignatureException(19014, "Signature is not in PKCS7 format.");
        }
        catch (IOException e) {
            this._log.error("error while reading signature file: {}", (Object)e.getMessage());
            throw new SignatureException(19015, "Could not read Signature file");
        }
        catch (CMSException e) {
            this._log.error("signature format problem: {}", (Object)e.getMessage());
            throw new SignatureException(19014, "Signature is not in PKCS7 format.");
        }
        catch (Exception e) {
            this._log.error("crypto problem: {}", (Object)e.getMessage());
            throw new SignatureException(19008, "Error while verifying signature.");
        }
    }

    protected X509CertificateHolder verifyRawSignature(File signatureFile, File contentFile, Collection<X509Certificate> senderCerts, XpMessage message) throws SignatureException {
        long sigSize = signatureFile.length();
        boolean sizeOk = false;
        X509CertificateHolder usedCert = null;
        for (X509Certificate cert : senderCerts) {
            PublicKey publicKey = cert.getPublicKey();
            if (publicKey instanceof RSAPublicKey) {
                int expectedSignatureSize = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8;
                if (sigSize == (long)expectedSignatureSize) {
                    sizeOk = true;
                    continue;
                }
                this._log.debug("rsa signature size:{}  expected size:{}", (Object)signatureFile.length(), (Object)expectedSignatureSize);
                continue;
            }
            if (!(publicKey instanceof ECPublicKey)) continue;
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(signatureFile.toPath(), new OpenOption[0]));
                 ASN1InputStream decoder = new ASN1InputStream((InputStream)inputStream);){
                ASN1Primitive asn1Primitive = decoder.readObject();
                if (asn1Primitive instanceof ASN1Sequence) {
                    int asn1ECSigSize = ((ASN1Sequence)asn1Primitive).size();
                    if (2 == asn1ECSigSize) {
                        sizeOk = true;
                        continue;
                    }
                    this._log.debug("asn1 data sequence does not got 2 elements");
                    continue;
                }
                this._log.debug("asn1 primitive is not an ans1 sequence");
            }
            catch (IOException e) {
                this._log.debug("Signature is not in EC raw format");
            }
        }
        if (!sizeOk) {
            throw new SignatureException(19007, "Signature is not in raw format");
        }
        boolean validSig = false;
        Iterator<X509Certificate> iter2 = senderCerts.iterator();
        while (iter2.hasNext() && !validSig) {
            X509Certificate cert = iter2.next();
            PublicKey pub = cert.getPublicKey();
            try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(contentFile.toPath(), new OpenOption[0]));
                 BufferedInputStream fis2 = new BufferedInputStream(Files.newInputStream(signatureFile.toPath(), new OpenOption[0]));){
                int length;
                byte[] buffer = new byte[8192];
                Signature signature = Signature.getInstance(this._usedAlgorithm, "BC");
                signature.initVerify(pub);
                while ((length = ((InputStream)fis).read(buffer)) != -1) {
                    signature.update(buffer, 0, length);
                }
                byte[] sigdata = new byte[((InputStream)fis2).available()];
                ((InputStream)fis2).read(sigdata);
                if (signature.verify(sigdata)) {
                    validSig = true;
                    usedCert = CryptoUtil.createCertificateHolder(cert);
                    this.isECPublicKey = pub instanceof ECPublicKey;
                    break;
                }
                this._log.debug("invalid signature for certificate {}", (Object)cert.getSubjectX500Principal());
            }
            catch (IOException | GeneralSecurityException e) {
                this._log.debug("problem while validating signature using certificate {} :{}", (Object)cert.getSubjectX500Principal(), (Object)e);
            }
        }
        if (!validSig) {
            throw new SignatureException(19007, "Signature is not valid !");
        }
        return usedCert;
    }
}

