/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SMIMECDSASigner;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;

public class SMIME384ECDSASigner
extends SMIMECDSASigner
implements ISigner {
    public static final String PROCESSING_VALUE = "SMIME-SHA384-ECDSA";
    public static final String OPTION_VALUE_SMIME = "SMIME-SHA384-ECDSA";
    private final CertificateUtility certificateUtility;
    private final SMIMESigner smimeSigner;

    public SMIME384ECDSASigner(CertificateUtility certificateUtility, SMIMESigner smimeSigner, MessengerLog messengerLog) {
        super("SMIME384ECDSASigner", messengerLog);
        this.certificateUtility = certificateUtility;
        this.smimeSigner = smimeSigner;
    }

    @Override
    public void doFilter(XpMessage message) throws BaseFilterException {
        this._log.debug("S/MIME sha384 ecdsa signature will be created.");
        this.filterSMIME(message, "SHA384withECDSA", this.certificateUtility, this.smimeSigner);
    }

    @Override
    protected String getDefaultExtension() {
        return ".p7smime";
    }

    @Override
    public String getOptionValue() {
        return "SMIME-SHA384-ECDSA";
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return "SMIME-SHA384-ECDSA";
    }
}

