/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.eda;

import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.PartnerCertificateManager;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.AbstractXMLSecFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XmlCryptException;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XmlSignatureException;
import de.pontonconsulting.xmlpipe.messenger.util.XmlEncryptionUtil;
import de.pontonconsulting.xmlpipe.messenger.util.XmlSignatureUtil;
import de.pontonconsulting.xmlpipe.messenger.util.XmlUtil;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public class XMLSecOutboundFilter
extends AbstractXMLSecFilter {
    private static final String DEFAULT_XMLENCRYPTION_VERSION = "1.0";
    private static final String PROPERTY_XMLENCRYPTION_VERSION = "ponton.xmlencryption.version";
    protected static final String PROCESSING_DIRECTIVE_EDASKIPXMLSECURITY = "EdaSkipXmlSecurity";
    private static final UIOption[] OPTIONS = new UIOption[]{new UIOption("pipelineOption.filter.xmlsec", "/edaXmlSec", "boolean", Boolean.TRUE.toString(), "help_header_xmlsec", "pipelineOption.filter.xmlsec", "pipelineOption.agreement.help.filter.xmlsec", "pipelineOption.profile.help.filter.xmlsec", UIOption.BOTH_PARTNERS)};
    private final Profiles profiles;
    private final CertificateUtility certificateUtility;
    private final XmlSignatureUtil xmlSignatureUtil;
    private final XmlEncryptionUtil xmlEncryptionUtil;
    private final IMessengerProperties messengerProperties;
    private final PartnerCertificateManager partnerCertificateManager;

    public XMLSecOutboundFilter(Profiles profiles, CertificateUtility certificateUtility, XmlSignatureUtil xmlSignatureUtil, XmlEncryptionUtil xmlEncryptionUtil, IMessengerProperties messengerProperties, PartnerCertificateManager partnerCertificateManager, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("XMLSecOutboundFilter", messengerLog, uiConfig, applicationContext);
        this.profiles = profiles;
        this.certificateUtility = certificateUtility;
        this.xmlSignatureUtil = xmlSignatureUtil;
        this.xmlEncryptionUtil = xmlEncryptionUtil;
        this.messengerProperties = messengerProperties;
        this.partnerCertificateManager = partnerCertificateManager;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    private XmlEncryptionUtil.XmlEncryptionType getSymmetricKeyEncryptionAlgorithm() {
        String version = this.messengerProperties.getProperty(PROPERTY_XMLENCRYPTION_VERSION, DEFAULT_XMLENCRYPTION_VERSION);
        if (DEFAULT_XMLENCRYPTION_VERSION.equals(version)) {
            return XmlEncryptionUtil.XmlEncryptionType.RSA_OAEP;
        }
        if ("1.1".equals(version)) {
            return XmlEncryptionUtil.XmlEncryptionType.RSA_OAEP_11;
        }
        throw new RuntimeException("unsupported XML Encryption version configured in ponton-messenger.properties :" + version);
    }

    private XmlEncryptionUtil.XmlEncryptionType getSymmetricDataEncryptionAlgorithm() {
        String version = this.messengerProperties.getProperty(PROPERTY_XMLENCRYPTION_VERSION, DEFAULT_XMLENCRYPTION_VERSION);
        if (DEFAULT_XMLENCRYPTION_VERSION.equals(version)) {
            return XmlEncryptionUtil.XmlEncryptionType.AES_256;
        }
        if ("1.1".equals(version)) {
            return XmlEncryptionUtil.XmlEncryptionType.AES_256_GCM;
        }
        throw new RuntimeException("unsupported XML Encryption version configured in ponton-messenger.properties :" + version);
    }

    @Override
    public void doFilter(XpMessage xpMessage) throws BaseFilterException {
        String skipXmlSecurity = xpMessage.getProcessingDirective(PROCESSING_DIRECTIVE_EDASKIPXMLSECURITY);
        xpMessage.removeProcessingDirective(PROCESSING_DIRECTIVE_EDASKIPXMLSECURITY);
        if (!this.isEnabled(xpMessage)) {
            return;
        }
        if (skipXmlSecurity != null && Boolean.parseBoolean(skipXmlSecurity)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The filter is skipped: processing directive EdaSkipXmlSecurity is set.");
            }
            return;
        }
        String endReceiverId = xpMessage.getProcessingDirective("EdaReceiver");
        if (endReceiverId == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The filter is skipped: EdaReceiver is not set.");
            }
            return;
        }
        this.getLogger().info("Creating xmlSec (EDA) for the message '{} using the partner '{}'.", (Object)xpMessage.getMessageId(), (Object)endReceiverId);
        this.updateProcessedOriginalFilename(xpMessage, false);
        File payload = xpMessage.getCurrentContentReference();
        Document edaDocument = null;
        try {
            X509Certificate receiverCertificate = this.getReceiverCertificate(endReceiverId, xpMessage);
            if (receiverCertificate == null) {
                throw new XmlCryptException(-1, "No VALID certificate is installed for receiver: " + endReceiverId);
            }
            edaDocument = XmlUtil.getDocument(payload);
            edaDocument = this.xmlEncryptionUtil.encrypt(edaDocument, edaDocument.getDocumentElement(), receiverCertificate, true, this.getSymmetricDataEncryptionAlgorithm(), this.getSymmetricKeyEncryptionAlgorithm());
            String usingPrefix = "(partner '" + endReceiverId + "') ";
            String usingInfoText = this.certificateUtility.toUsingInfoText(receiverCertificate, usingPrefix + "used certificate");
            this.messageLog(90, xpMessage.getDatabaseId(), xpMessage.getMessageId(), usingInfoText);
            this.messageLog(90, xpMessage.getDatabaseId(), xpMessage.getMessageId(), this.xmlEncryptionUtil.encryptionTypeToString(this.getSymmetricDataEncryptionAlgorithm()));
            this.getLogger().debug("XML Enctryption: {}", (Object)usingInfoText);
            this.getLogger().info("XML Encryption: {}. Message is successfully encrypted.", (Object)usingPrefix);
            this.getLogger().info("XML Encryption: {}. {}", (Object)usingPrefix, (Object)this.xmlEncryptionUtil.encryptionTypeToString(this.getSymmetricDataEncryptionAlgorithm()));
        }
        catch (Exception e) {
            Object errorMSG = "Error while encrypting: ";
            if (e instanceof LocalizedException) {
                this.messageLog(541, xpMessage.getDatabaseId(), xpMessage.getMessageId(), e.getMessage());
                errorMSG = (String)errorMSG + e.getMessage();
            } else {
                this.messageLog(541, xpMessage.getDatabaseId(), xpMessage.getMessageId(), e.toString());
                errorMSG = (String)errorMSG + e.toString();
            }
            this.getLogger().error("XML Encryption: {}", errorMSG);
            this.messageLog(541, xpMessage.getDatabaseId(), xpMessage.getMessageId(), this.xmlEncryptionUtil.encryptionTypeToString(this.getSymmetricDataEncryptionAlgorithm()));
            throw new XmlCryptException(-1, (String)errorMSG);
        }
        try {
            SignCertInfo senderSignCertInfo = this.getSenderSignCertInfo(xpMessage);
            if (senderSignCertInfo == null) {
                throw new XmlSignatureException(-1, "No VALID certificate is installed for sender: " + xpMessage.getSenderInternalId());
            }
            X509Certificate senderCertificate = senderSignCertInfo.getCertificateChain()[0];
            PrivateKey senderPrivateKey = senderSignCertInfo.getPrivateKey();
            this.xmlSignatureUtil.sign(edaDocument, senderCertificate, senderPrivateKey);
            String usingInfoText = this.certificateUtility.toUsingInfoText(senderCertificate);
            this.messageLog(73, xpMessage.getDatabaseId(), xpMessage.getMessageId(), usingInfoText);
            this.getLogger().debug("XML Signature: " + usingInfoText);
            this.getLogger().info("XML Signature: message is successfully signed.");
            File xmlSecFile = new File(payload.getParent(), payload.getName() + this.getDefaultExtension());
            XmlUtil.writeDocument(xmlSecFile, edaDocument);
            xpMessage.setCurrentContentReference(xmlSecFile);
        }
        catch (Exception e) {
            Object errorMSG = "Error while signing: ";
            errorMSG = e instanceof LocalizedException ? (String)errorMSG + e.getMessage() : (String)errorMSG + e.toString();
            this.messageLog(521, xpMessage.getDatabaseId(), xpMessage.getMessageId(), (String)errorMSG);
            this.getLogger().error("XML Signature: {}", errorMSG);
            throw new XmlSignatureException(-1, "XML Siganture: " + (String)errorMSG);
        }
    }

    private X509Certificate getReceiverCertificate(String receiverInternalId, XpMessage xpMessage) throws Exception {
        CppPartner endReceiver = this.profiles.getProfileForInternalId(receiverInternalId, true);
        return this.partnerCertificateManager.getPipelineCertificate(endReceiver, xpMessage.getCommunication().getPipelineId());
    }

    private SignCertInfo getSenderSignCertInfo(XpMessage xpMessage) throws Exception {
        return xpMessage.getCommunication().getProcessingSignKey();
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }
}

