/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.crypt;

import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSException;

public abstract class ASN1Encrypter
extends BaseFilterPlugin {
    private String _cmsAlgorithm;
    private String _usedAlgorithm;
    private String _usedCryptAlgorithm;
    private final CertificateUtility _certificateUtility;

    public ASN1Encrypter(String pluginName, MessengerLog messengerLog, CertificateUtility certificateUtility) {
        super(pluginName, messengerLog);
        this._certificateUtility = certificateUtility;
    }

    protected void setEncryptionAlgorithm(String usedAlgorithm, String usedCryptAlgorithm, String cmsAlgorithm) {
        this._usedAlgorithm = usedAlgorithm;
        this._usedCryptAlgorithm = usedCryptAlgorithm;
        this._cmsAlgorithm = cmsAlgorithm;
    }

    public void doFilter(XpMessage message) throws CryptException {
        this._log.debug("Message {} will be encrypted", (Object)message.getMessageId());
        try {
            this.updateProcessedOriginalFilename(message, false);
            File inputFile = message.getCurrentContentReference();
            File outputFile = new File(message.getCurrentContentReferenceFolder(), inputFile.getName() + this.getDefaultExtension());
            X509Certificate receiverCertificate = message.getCommunication().getProcessingEncryptionCertificate();
            this.encryptFile(inputFile, outputFile, receiverCertificate);
            String usingInfoText = this._certificateUtility.toUsingInfoText(receiverCertificate, "using " + this._usedCryptAlgorithm + " and certificate");
            this.messageLog(64, message.getDatabaseId(), message.getMessageId(), usingInfoText);
            if (this._log.isInfoEnabled()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(usingInfoText);
                }
                this._log.info("Message successfully encrypted");
            }
            message.setCurrentContentReference(outputFile);
            message.setCurrentContentType("application/pkcs7-mime");
            message.setProcessingDirective("CryptoAlgorithm", this._usedAlgorithm);
        }
        catch (Exception e) {
            if (e instanceof LocalizedException) {
                this._log.fatal("Error while encrypting: {}", (Object)e.getMessage());
                this.messageLog(507, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new CryptException(17001, "Error while encrypting: " + e.getMessage());
            }
            this._log.fatal("Error while encrypting: {}", (Object)e.toString());
            this.messageLog(507, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new CryptException(17001, "Error while encrypting: " + e.toString());
        }
    }

    protected void encryptFile(File inputFile, File outputFile, X509Certificate receiverCertificate) throws FileNotFoundException, GeneralSecurityException, CMSException, IOException {
        String symmetricAlgorithm = CryptoUtil.extractSymmetricAlgorithm(this._cmsAlgorithm);
        String asymmetricAlgorithm = CryptoUtil.extractAsymmetricAlgorithm(this._cmsAlgorithm);
        ASN1ObjectIdentifier identifier = CryptoUtil.getASN1ObjectIdentifier(this._cmsAlgorithm);
        CryptoUtil.CMSEnvelopedGeneratorTupel edGen = CryptoUtil.createGenerator(receiverCertificate, asymmetricAlgorithm, symmetricAlgorithm);
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(inputFile.toPath(), new OpenOption[0]));
             BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), 8192);
             OutputStream out = edGen.open(identifier, fos);){
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = ((InputStream)fis).read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    @Override
    protected String getDefaultExtension() {
        return ".asn1";
    }
}

