/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.ICompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZIPwithAttachmentsCompressor
extends BaseFilterPlugin
implements ICompressor {
    private static final String COMMENT_ATTACHMENT = "attachment";
    public static final String PROCESSING_VALUE_ZIP_WITH_ATTACHMENTS = "ZIPwithAttachments";

    public ZIPwithAttachmentsCompressor(MessengerLog messengerLog) {
        super("ZIPwithAttachmentsCompressor", messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        File temp = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + this.getDefaultExtension());
        int before = 0;
        int after = 0;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));
             ZipOutputStream comp = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(temp.toPath(), new OpenOption[0])));){
            ZipEntry payloadEntry = new ZipEntry(message.getCurrentContentReference().getName());
            payloadEntry.setComment("payload");
            comp.putNextEntry(payloadEntry);
            before += this.write(in, comp);
            comp.closeEntry();
            int index = 0;
            Iterator<XpMessageAttachment> attachmets = message.getAttachmentIterator();
            while (attachmets.hasNext()) {
                XpMessageAttachment attachment = attachmets.next();
                if ("Signature".equals(attachment.getDescription())) continue;
                try (BufferedInputStream attachmentIn = new BufferedInputStream(Files.newInputStream(attachment.getAttachment().toPath(), new OpenOption[0]));){
                    ZipEntry attachmentEntry = new ZipEntry(attachment.getAttachment().getName());
                    attachmentEntry.setComment("attachment " + ++index);
                    comp.putNextEntry(attachmentEntry);
                    before += this.write(attachmentIn, comp);
                    comp.closeEntry();
                }
                attachmets.remove();
            }
            this.updateProcessedOriginalFilename(message, false);
            message.setCurrentContentReference(temp);
            message.setCurrentContentType("application/zip");
            message.setProcessingDirective("CompressionAlgorithm", PROCESSING_VALUE_ZIP_WITH_ATTACHMENTS);
        }
        catch (IOException ioe) {
            this._log.fatal("Error while compressing message: {}", (Object)ioe.toString());
            this.messageLog(502, message.getDatabaseId(), message.getMessageId(), ioe.toString());
            throw new CompressionException(16001, "Error while compressing message: " + ioe.toString());
        }
        this._log.info("Message successfully compressed");
        after = (int)temp.length();
        this.messageLog(62, message.getDatabaseId(), message.getMessageId(), before + " bytes -> " + after + " bytes (" + this.getOptionValue() + ")");
    }

    @Override
    protected String getDefaultExtension() {
        return ".zip";
    }

    @Override
    public String getOptionValue() {
        return PROCESSING_VALUE_ZIP_WITH_ATTACHMENTS;
    }
}

