/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.common.io.ZlibFixInputStream;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateDecompressor
extends BaseFilterPlugin
implements IDecompressor {
    public DeflateDecompressor(MessengerLog messengerLog) {
        super("DeflateDecompressor", messengerLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        byte[] _buffer = new byte[8192];
        long before = message.getCurrentContentReference().length();
        if (this._log.isDebugEnabled()) {
            this._log.debug("Message is compressed: {} bytes", (Object)before);
        }
        ZlibFixInputStream in = null;
        BufferedOutputStream out = null;
        try {
            String payloadFilename = this.updateCurrentPayloadFilename(message, true);
            Inflater zipper = new Inflater(true);
            try {
                out = new BufferedOutputStream(Files.newOutputStream(message.getCurrentContentReference().toPath(), StandardOpenOption.APPEND));
                ((OutputStream)out).write(0);
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(out);
                throw throwable;
            }
            IOUtil.closeStreamQuietly(out);
            in = new ZlibFixInputStream(new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0])));
            File outFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
            if (this._log.isDebugEnabled()) {
                this._log.debug("writing to: {}", (Object)outFile);
            }
            out = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
            InflaterInputStream decomp = null;
            try {
                int length;
                decomp = new InflaterInputStream(in, zipper);
                while ((length = decomp.read(_buffer)) != -1) {
                    ((OutputStream)out).write(_buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(decomp);
                throw throwable;
            }
            IOUtil.closeStreamQuietly(decomp);
            this._log.debug("Message is decompressed: {} bytes", (Object)zipper.getTotalOut());
            message.setCurrentContentReference(outFile);
            this.updateProcessedOriginalFilename(message, true);
            this.messageLog(69, message.getDatabaseId(), message.getMessageId(), zipper.getTotalIn() + " bytes -> " + zipper.getTotalOut() + " bytes (" + this.getOptionValue() + ")");
            this._log.info("Message successfully decompressed");
        }
        catch (IOException e) {
            try {
                this._log.fatal("Error while decompressing Message: {}", (Object)e.toString());
                this.messageLog(503, message.getDatabaseId(), message.getMessageId(), "decompression problem: " + e.toString());
                throw new CompressionException(16003, "Error while decompressing Message: " + e.toString());
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(in);
                IOUtil.closeStreamQuietly(out);
                throw throwable;
            }
        }
        IOUtil.closeStreamQuietly(in);
        IOUtil.closeStreamQuietly(out);
    }

    @Override
    protected String getDefaultExtension() {
        return ".zlib";
    }

    @Override
    public String getOptionValue() {
        return "Deflate";
    }
}

