/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap;

import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ErrorCode;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.FileScanRequest;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ISTagInfo;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.Policy;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ScanEngineInfo;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.ScanException;
import de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.StreamScanRequestImpl;
import java.io.File;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public final class ScanEngine {
    static final ResourceBundle res = ResourceBundle.getBundle("de.pontonconsulting.xmlpipe.messenger.filter.antivirus.icap.APIResource");
    private InetAddress[] inetAddress;
    private ISTagInfo[] isTagInfo;
    private String[] ipAddress;
    private int[] portNumber;
    private int failRetryTime;
    private int readWriteTime;

    ScanEngine() {
    }

    public static ScanEngine createScanEngine(List<ScanEngineInfo> list, int i, int j) throws ScanException {
        ScanEngine scanengine = new ScanEngine();
        scanengine.ipAddress = new String[list.size()];
        scanengine.portNumber = new int[list.size()];
        scanengine.inetAddress = new InetAddress[list.size()];
        scanengine.isTagInfo = new ISTagInfo[list.size()];
        if (i <= 0 || j <= 0) {
            throw new IllegalArgumentException();
        }
        if (list.size() != 0) {
            int k = 0;
            for (ScanEngineInfo scanengineinfo : list) {
                scanengine.ipAddress[k] = scanengineinfo.scanEngineIP;
                scanengine.portNumber[k] = scanengineinfo.scanEnginePort;
                if (scanengine.portNumber[k] <= 0 || scanengine.portNumber[k] > 65535) {
                    throw new IllegalArgumentException("At least one value of Port Number is incorrect.(" + scanengine.portNumber[k] + ")");
                }
                scanengine.inetAddress[k] = scanengine.validateIP(scanengine.ipAddress[k]);
                ++k;
            }
        }
        scanengine.readWriteTime = i;
        scanengine.failRetryTime = j;
        return scanengine;
    }

    InetAddress validateIP(String s) throws ScanException {
        InetAddress inetaddress = null;
        try {
            inetaddress = InetAddress.getByName(s);
        }
        catch (UnknownHostException unknownhostexception) {
            throw new ScanException("At least one IP is incorrect. (" + s + ")", ErrorCode.IP_UNRESOLVED);
        }
        return inetaddress;
    }

    public static ScanEngine createScanEngine(ArrayList<ScanEngineInfo> array) throws ScanException {
        int c = 1000;
        int c1 = 3000;
        return ScanEngine.createScanEngine(array, c1, c);
    }

    public static ScanEngine createScanEngine() throws ScanException {
        int c = 1000;
        int c1 = 3000;
        ArrayList<ScanEngineInfo> arrayList = new ArrayList<ScanEngineInfo>();
        arrayList.add(new ScanEngineInfo("127.0.0.1", 1344));
        return ScanEngine.createScanEngine(arrayList, c1, c);
    }

    public StreamScanRequestImpl createStreamScanRequestImpl(String s, String s1, OutputStream outputstream, Policy policy) throws ScanException {
        File file1 = new File(s);
        File file = s1 == null ? null : new File(s1);
        StreamScanRequestImpl streamscanrequestimpl = new StreamScanRequestImpl(this.inetAddress, this.portNumber, this.isTagInfo, file1, file, outputstream, policy);
        streamscanrequestimpl.setFailRetryTime(this.failRetryTime);
        streamscanrequestimpl.setReadWriteTime(this.readWriteTime);
        return streamscanrequestimpl;
    }

    public FileScanRequest createFileScanRequestImpl(String s, Policy policy) throws ScanException {
        File file = new File(s);
        FileScanRequest filescanrequestimpl = new FileScanRequest(this.inetAddress, this.portNumber, this.isTagInfo, file, null, policy);
        filescanrequestimpl.setFailRetryTime(this.failRetryTime);
        filescanrequestimpl.setReadWriteTime(this.readWriteTime);
        return filescanrequestimpl;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

