/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import com.ctc.wstx.stax.WstxInputFactory;
import de.pontonconsulting.xmlpipe.adapter.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.DoctypeActionType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.LineEndingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlEncodingType;
import de.pontonconsulting.xmlpipe.message.StAXWriteContainer;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.springframework.context.ApplicationContext;

public class XmlModificationFilter
extends BaseFilter<IFilterPlugin> {
    private static final List<String> SUPPORTED_MIME_TYPES = List.of("application/xml", "text/xml");
    private static final String TAB = "   ";
    private static final String CRLF_STRING = "\r\n";
    private static final char CR = '\r';
    private static final String CR_STRING = String.valueOf('\r');
    private static final char LF = '\n';
    private static final String LF_STRING = String.valueOf('\n');
    private static final String XPATH_SEPARATOR = "/";
    private static final String XPATH_TRANSFER_ID = "/Envelope/TransmissionInformation/TransmissionCharacteristics/TransferID";
    private static final String XPATH_TRANSMISSION_TIMESTAMP = "/Envelope/TransmissionInformation/TransmissionCharacteristics/TransmissionTimeStamp";
    private static final String XPATH_TRANSMISSION_PROTOCOL = "/Envelope/TransmissionInformation/TransmissionCharacteristics/@TransmissionProtocol";
    private static final String XPATH_SENDER_ORGANISATION = "/Envelope/TransmissionInformation/TransmissionOrganisationIdentifiers/SenderOrganisation";
    private static final String XPATH_RECEIVER_ORGANISATION = "/Envelope/TransmissionInformation/TransmissionOrganisationIdentifiers/ReceiverOrganisation";
    private static final String XPATH_LOG_INFO = "/Envelope/Payload/MessageMetaData/DocumentInfo/LogInfo";
    private static final String XPATH_DTD_VERSION = "/Envelope/Payload/MessageMetaData/DocumentInfo/DTDVersionNumber";
    private static final String XPATH_DTD_SET = "/Envelope/Payload/MessageMetaData/DocumentInfo/DTDSet";
    private static final String XPATH_MESSAGE_NAME = "/Envelope/Payload/MessageMetaData/DocumentInfo/@MessageName";
    private static final String XPATH_TEST_FLAG = "/Envelope/Payload/MessageMetaData/DocumentInfo/@TestFlag";
    private static final String TEST_FLAG_TRUE = "Test";
    private static final String TEST_FLAG_FALSE = "Production";
    private static final Map<String, String> LINE_ENDINGS = new HashMap<String, String>();
    private static final Map<String, String> LINE_ENDINGS_NAMES = new HashMap<String, String>();
    private static final Pattern CRLF_PATTERN = Pattern.compile("(\r\n|\r|\n|\n\r)");
    private static final XMLInputFactory _factory = XMLInputFactory.newInstance();
    private final SchemataConfig schemataConfig;

    public XmlModificationFilter(SchemataConfig schemataConfig, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("XmlModificationFilter", messengerLog, uiConfig, applicationContext);
        this.schemataConfig = schemataConfig;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    private boolean isXml(XpMessage xpMessage) {
        return xpMessage.getCurrentContentType() != null && SUPPORTED_MIME_TYPES.contains(xpMessage.getCurrentContentType().toLowerCase()) || this.isContentXML(xpMessage.getCurrentContentReference());
    }

    private boolean isContentXML(File dataFile) {
        boolean bl;
        de.pontonconsulting.xmlpipe.adapter.util.UTF8BOMSkippingInputStream inputStream = new de.pontonconsulting.xmlpipe.adapter.util.UTF8BOMSkippingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(dataFile.toPath(), new OpenOption[0])));
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            factory.setXMLReporter(null);
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader((InputStream)inputStream);
            xmlStreamReader.next();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    @Override
    public void doFilter(XpMessage message) {
        if (!this.isXml(message)) {
            String logText = "XmlModification does not support '%s' data.".formatted(message.getCurrentContentType());
            this.getLogger().info(logText);
            this.messageLog(10, message.getDatabaseId(), message.getMessageId(), logText);
            return;
        }
        if (message.getCurrentContentReference() != null && message.getCommunication().getXmlModificationEnabled()) {
            String encoding = message.getCommunication().getXmlEncoding();
            String changeLineEnding = message.getCommunication().getLineEnding();
            boolean prettyPrint = message.getCommunication().getPrettyPrint();
            boolean updatePapinet1Envelope = message.getCommunication().getUpdatePapinet1Envelope();
            String doctype = null;
            try {
                SchemaData schema;
                String doctypeAction = message.getCommunication().getDoctypeAction();
                if (DoctypeActionType.ADD_UPDATE.value().equals(doctypeAction) && (schema = this.schemataConfig.getSchemaBySetTypeVersion(message.getSchemaSet(), message.getMessageType(), message.getMessageVersion())) != null && schema.getDtdFile() != null && !schema.getDtdFile().trim().isEmpty()) {
                    doctype = schema.getDtdFile();
                }
            }
            catch (Exception e) {
                this.getLogger().warn("could not fetch doctype:{}", (Object)e.toString());
            }
            boolean keepDoctype = DoctypeActionType.NO_CHANGE.value().equals(message.getCommunication().getDoctypeAction());
            changeLineEnding = this.doFilter(message, encoding, changeLineEnding, prettyPrint, doctype, updatePapinet1Envelope, keepDoctype);
            if (encoding != null && !encoding.equals(XmlEncodingType.NO_CHANGE.value())) {
                message.setPayloadEncoding(encoding);
            }
            if (changeLineEnding != null && !changeLineEnding.equals(LineEndingType.NO_CHANGE.value())) {
                message.setPayloadLineEnding(changeLineEnding);
            }
        }
    }

    private String getRealLineFeed(String lineFeed) {
        return LINE_ENDINGS.get(lineFeed);
    }

    private String getLineFeedNames(String lineFeed) {
        return LINE_ENDINGS_NAMES.get(lineFeed);
    }

    protected String doFilter(XpMessage message, String encoding, String lineFeed, boolean prettyPrint, String doctype, boolean updatePapinet1Envelope, boolean keepDoctype) {
        String par_encoding = XmlEncodingType.NO_CHANGE.value().equals(encoding) ? null : encoding;
        String par_lineFeed = this.getRealLineFeed(lineFeed);
        boolean par_prettyPrint = prettyPrint;
        String par_doctype = doctype;
        boolean par_updatePapinet1Envelope = updatePapinet1Envelope;
        try {
            String par_sourceLineFeed;
            String orgFileName;
            File folder = message.getCurrentContentReferenceFolder();
            String orgFileNameWithoutExtension = orgFileName = message.getCurrentContentReference().getName();
            Object modFileName = orgFileName;
            int extensionIndex = orgFileName.lastIndexOf(46);
            if (extensionIndex > -1) {
                orgFileNameWithoutExtension = orgFileName.substring(0, extensionIndex);
                modFileName = orgFileNameWithoutExtension + "_mod.xml";
            }
            File newFile = new File(folder, (String)modFileName);
            try (BufferedOutputStream outStream = new BufferedOutputStream(Files.newOutputStream(newFile.toPath(), new OpenOption[0]));
                 BufferedInputStream inStream = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));){
                par_sourceLineFeed = this.writeNew(message, inStream, outStream, par_doctype, par_encoding, par_lineFeed, prettyPrint, par_updatePapinet1Envelope, keepDoctype);
            }
            if (message.isInbound()) {
                Files.move(message.getCurrentContentReference().toPath(), new File(folder, "payload_org.xml").toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                message.setCurrentContentReference(newFile);
            } else {
                boolean renamed = false;
                try {
                    Files.move(message.getCurrentContentReference().toPath(), new File(folder, orgFileNameWithoutExtension + "_old.xml").toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    try {
                        Files.move(newFile.toPath(), new File(folder, orgFileName).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (IOException io) {
                        this.getLogger().error("failed to rename from '{}' to '{}'", (Object)newFile, (Object)new File(folder, orgFileName));
                    }
                    renamed = true;
                }
                catch (IOException e) {
                    this.getLogger().error("failed to rename from '{}' to '{}'", (Object)message.getCurrentContentReference(), (Object)new File(folder, orgFileNameWithoutExtension + "_old.xml"));
                }
                if (!renamed) {
                    this.messageLog(527, message.getDatabaseId(), message.getMessageId(), "renaming failed");
                    throw new Exception("could not rename file during xml modification");
                }
            }
            this.messageLog(105, message.getDatabaseId(), message.getMessageId(), null);
            if (this.getLogger().isDebugEnabled()) {
                if (par_encoding != null) {
                    this.getLogger().debug("encoding changed to '{}'", (Object)par_encoding);
                }
                if (par_lineFeed != null) {
                    this.getLogger().debug("line feed changed to '{}'", (Object)lineFeed);
                }
                if (par_prettyPrint) {
                    this.getLogger().debug("pretty print XML");
                }
                if (par_doctype != null) {
                    this.getLogger().debug("doctype changed to '{}'", (Object)par_doctype);
                }
                if (par_updatePapinet1Envelope) {
                    this.getLogger().debug("updated papinet 1.x envelope");
                }
            }
            return this.getLineFeedNames(par_sourceLineFeed);
        }
        catch (Exception e1) {
            this.getLogger().error("problem while applying XML modification {}", (Object)e1.toString());
            throw new RuntimeException(e1);
        }
    }

    private String writeNew(XpMessage message, InputStream inStream, OutputStream out, String par_doctype, String par_encoding, String par_lineFeed, boolean par_prettyPrint, boolean par_updatePapinet1Envelope, boolean keepDoctype) {
        String par_sourceLineFeed = null;
        XMLStreamWriter2 writer = null;
        XMLStreamReader2 reader = null;
        try {
            String string;
            UTF8BOMSkippingInputStream in = new UTF8BOMSkippingInputStream(inStream);
            reader = (XMLStreamReader2)_factory.createXMLStreamReader((InputStream)in);
            StAXWriteContainer container = new StAXWriteContainer();
            if (par_updatePapinet1Envelope) {
                container.addCustomXPath(XPATH_TRANSMISSION_PROTOCOL, message.getProtocol());
                container.addCustomXPath(XPATH_TRANSFER_ID, message.getMessageId());
                container.addCustomXPath(XPATH_DTD_VERSION, message.getMessageVersion());
                container.addCustomXPath(XPATH_DTD_SET, message.getSchemaSet());
                container.addCustomXPath(XPATH_MESSAGE_NAME, message.getMessageType());
                container.addCustomXPath(XPATH_SENDER_ORGANISATION, message.getSenderInternalId());
                container.addCustomXPath(XPATH_RECEIVER_ORGANISATION, message.getReceiverInternalId());
                container.addCustomXPath(XPATH_TRANSMISSION_TIMESTAMP, message.getMessageTimestamp().toString());
                container.addCustomXPath(XPATH_LOG_INFO, message.getProcessingDirective("LogInfo"));
                if (message.isTestMessage()) {
                    container.addCustomXPath(XPATH_TEST_FLAG, TEST_FLAG_TRUE);
                } else {
                    container.addCustomXPath(XPATH_TEST_FLAG, TEST_FLAG_FALSE);
                }
            }
            ArrayList<Object> xpath = new ArrayList<Object>();
            Object currentXPath = "";
            int xpathLevel = 0;
            xpath.add(0, currentXPath);
            boolean firstElement = true;
            boolean firstLineFeed = true;
            boolean hasDTD = false;
            boolean skipNextElementText = false;
            boolean haveText = false;
            while (reader.hasNext()) {
                switch (reader.getEventType()) {
                    case 7: {
                        String encoding = reader.getCharacterEncodingScheme();
                        if (par_encoding != null) {
                            encoding = par_encoding;
                        }
                        writer = (XMLStreamWriter2)XMLOutputFactory.newInstance().createXMLStreamWriter(out, encoding);
                        writer.writeStartDocument();
                        break;
                    }
                    case 13: {
                        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                            writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                        break;
                    }
                    case 11: {
                        hasDTD = true;
                        if (!keepDoctype) break;
                        DTDInfo dtdInfo = reader.getDTDInfo();
                        String internalSubset = dtdInfo.getDTDInternalSubset();
                        String publicId = dtdInfo.getDTDPublicId();
                        String systemId = dtdInfo.getDTDSystemId();
                        String rootName = dtdInfo.getDTDRootName();
                        writer.writeDTD(rootName, systemId, publicId, internalSubset);
                        if (par_sourceLineFeed == null) break;
                        writer.writeRaw(par_sourceLineFeed);
                        break;
                    }
                    case 1: {
                        int i;
                        if (par_sourceLineFeed == null) {
                            par_sourceLineFeed = par_lineFeed != null ? par_lineFeed : CRLF_STRING;
                        }
                        if (firstElement && par_doctype != null) {
                            writer.writeDTD("<!DOCTYPE " + reader.getName().getLocalPart() + " SYSTEM \"" + par_doctype + "\">");
                            writer.writeRaw(par_sourceLineFeed);
                        }
                        if (par_prettyPrint && !firstElement) {
                            Object spaces = "";
                            for (int i2 = 0; i2 < xpathLevel; ++i2) {
                                spaces = (String)spaces + TAB;
                            }
                            writer.writeRaw(par_sourceLineFeed + (String)spaces);
                        }
                        currentXPath = (String)xpath.get(xpathLevel) + XPATH_SEPARATOR + reader.getName().getLocalPart();
                        if (xpath.size() > ++xpathLevel && xpath.get(xpathLevel) != null) {
                            xpath.remove(xpathLevel);
                        }
                        xpath.add(xpathLevel, currentXPath);
                        writer.writeStartElement(reader.getName().getPrefix(), reader.getName().getLocalPart(), reader.getName().getNamespaceURI());
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            if (container.handleAttributes((XMLStreamReader)reader, (XMLStreamWriter)writer, xpathLevel, (String)currentXPath, i)) continue;
                            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeName(i).getLocalPart(), reader.getAttributeValue(i));
                        }
                        skipNextElementText = container.handleStartElement((XMLStreamReader)reader, (XMLStreamWriter)writer, xpathLevel, (String)currentXPath);
                        firstElement = false;
                        break;
                    }
                    case 2: {
                        skipNextElementText = false;
                        --xpathLevel;
                        if (!haveText && par_prettyPrint && par_sourceLineFeed != null) {
                            Object spaces = "";
                            for (int i = 0; i < xpathLevel; ++i) {
                                spaces = (String)spaces + TAB;
                            }
                            writer.writeRaw(par_sourceLineFeed + (String)spaces);
                        }
                        haveText = false;
                        writer.writeEndElement();
                        break;
                    }
                    case 6: {
                        String chars = null;
                        if (!firstElement || hasDTD) break;
                        String[] temp_par = new String[]{par_sourceLineFeed};
                        chars = this.getChars((XMLStreamReader)reader, skipNextElementText, firstElement, par_prettyPrint, true, par_lineFeed, temp_par);
                        par_sourceLineFeed = temp_par[0];
                        if (chars == null) break;
                        writer.writeRaw(chars);
                        break;
                    }
                    case 4: {
                        String[] temp_par = new String[]{par_sourceLineFeed};
                        String chars = this.getChars((XMLStreamReader)reader, skipNextElementText, firstElement, par_prettyPrint, true, par_lineFeed, temp_par);
                        par_sourceLineFeed = temp_par[0];
                        if (skipNextElementText || chars != null && chars.length() > 0) {
                            haveText = true;
                        }
                        if (chars == null) break;
                        char[] tempChars = chars.toCharArray();
                        for (int i = 0; i < tempChars.length; ++i) {
                            if (tempChars[i] == '\r' || tempChars[i] == '\n') {
                                writer.writeRaw(tempChars, i, 1);
                                continue;
                            }
                            writer.writeCharacters(tempChars, i, 1);
                        }
                        break;
                    }
                    case 5: {
                        String chars = reader.getText();
                        if (par_lineFeed != null && (chars.indexOf(10) != -1 || chars.indexOf(13) != -1)) {
                            par_sourceLineFeed = par_lineFeed;
                            Matcher m = CRLF_PATTERN.matcher(chars);
                            chars = m.replaceAll(par_lineFeed);
                        }
                        writer.writeComment(chars);
                        break;
                    }
                }
                reader.next();
            }
            writer.writeEndDocument();
            if (par_lineFeed == null) {
                string = par_sourceLineFeed;
                return string;
            }
            string = par_lineFeed;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            try {
                inStream.close();
            }
            catch (Exception exception) {}
            try {
                writer.flush();
            }
            catch (Exception exception) {}
            try {
                writer.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getChars(XMLStreamReader reader, boolean skipNextElementText, boolean firstElement, boolean par_prettyPrint, boolean firstLineFeed, String par_lineFeed, String[] par_sourceLineFeed) {
        if (skipNextElementText) {
            return null;
        }
        String chars = reader.getText();
        if (par_lineFeed == null && par_sourceLineFeed[0] == null) {
            par_sourceLineFeed[0] = chars.indexOf(10) != -1 ? (chars.indexOf(13) != -1 ? CRLF_STRING : LF_STRING) : (chars.indexOf(13) != -1 ? CR_STRING : par_lineFeed);
        }
        if (par_lineFeed != null && (chars.indexOf(10) != -1 || chars.indexOf(13) != -1)) {
            par_sourceLineFeed[0] = par_lineFeed;
            Matcher m = CRLF_PATTERN.matcher(chars);
            chars = m.replaceAll(par_lineFeed);
        }
        if (firstElement) {
            if (firstLineFeed && par_sourceLineFeed[0] != null) {
                return par_sourceLineFeed[0];
            }
        } else {
            if (par_prettyPrint) {
                chars = chars.trim();
            }
            return chars;
        }
        firstLineFeed = false;
        return null;
    }

    @Override
    public UIOption[] getUIOptions() {
        return new UIOption[0];
    }

    static {
        if (_factory instanceof WstxInputFactory) {
            ((WstxInputFactory)_factory).configureForSpeed();
            ((WstxInputFactory)_factory).getConfig().doReportPrologWhitespace(true);
        }
        _factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        _factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        LINE_ENDINGS.put(LineEndingType.NO_CHANGE.value(), null);
        LINE_ENDINGS.put(LineEndingType.LF.value(), LF_STRING);
        LINE_ENDINGS.put(LineEndingType.CR_LF.value(), CRLF_STRING);
        LINE_ENDINGS.put(LineEndingType.CR.value(), CR_STRING);
        LINE_ENDINGS_NAMES.put(LF_STRING, LineEndingType.LF.value());
        LINE_ENDINGS_NAMES.put(CRLF_STRING, LineEndingType.CR_LF.value());
        LINE_ENDINGS_NAMES.put(CR_STRING, LineEndingType.CR.value());
    }
}

