/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.rest.messagemulticastrule.ContentRestrictionModel;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastInboundRule;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleService;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageTypeModel;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.InboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.util.CopyFileVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MessageMulticastInboundFilter
extends BaseFilter<IFilterPlugin> {
    private static final String PROCESSING_DIRECTIVE_DUPLICATE_FOR_MESSAGE = "DuplicateForMessage";
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageMulticastInboundFilter.class.getName()));
    private final MessageMulticastRuleService messageMulticastRuleService;
    private final InboundQueue inboundQueue;
    private final MessageDAO messageDAO;
    private final FileRefDAO fileRefDAO;

    public MessageMulticastInboundFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext, MessageMulticastRuleService messageMulticastRuleService, InboundQueue inboundQueue, MessageDAO messageDAO, FileRefDAO fileRefDAO) {
        super(MessageMulticastInboundFilter.class.getSimpleName(), messengerLog, uiConfig, applicationContext);
        this.messageMulticastRuleService = messageMulticastRuleService;
        this.inboundQueue = inboundQueue;
        this.messageDAO = messageDAO;
        this.fileRefDAO = fileRefDAO;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    @Override
    public void doFilter(XpMessage xpMessage) throws BaseFilterException {
        if (xpMessage.isSignal()) {
            return;
        }
        try {
            Optional<MessageMulticastInboundRule> messageMulticastInboundRule = this.getMatchingRule(xpMessage);
            ArrayList<String> usedAdapterIds = new ArrayList<String>();
            usedAdapterIds.add(xpMessage.getAdapterId());
            messageMulticastInboundRule.ifPresent(rule -> {
                for (String adapterId : rule.getCopyAdapterIds()) {
                    if (usedAdapterIds.contains(adapterId)) continue;
                    usedAdapterIds.add(adapterId);
                    try {
                        XpMessage newXpMessage = MessageMulticastInboundFilter.copyXpMessage(xpMessage, adapterId);
                        this.messageDAO.registerMessage(newXpMessage);
                        Path originalFolder = xpMessage.getCurrentContentReferenceFolder().toPath();
                        Path newFolder = originalFolder.getParent().resolve(String.valueOf(newXpMessage.getDatabaseId()));
                        Files.walkFileTree(originalFolder, new CopyFileVisitor(originalFolder, newFolder));
                        newXpMessage.setCurrentContentReference(newFolder.resolve(xpMessage.getCurrentContentReference().getName()).toFile());
                        newXpMessage.setCurrentContentReferenceFolder(newFolder.toFile());
                        xpMessage.getAttachmentIterator().forEachRemaining(xpMessageAttachment -> {
                            File originalAttachmentFile = xpMessageAttachment.getAttachment();
                            Path originalAttachmentFolder = originalAttachmentFile.getParentFile().toPath();
                            File newAttachmentFile = newFolder.resolve(originalAttachmentFolder.getFileName()).resolve(originalAttachmentFile.getName()).toFile();
                            XpMessageAttachment newAttachment = new XpMessageAttachment(newAttachmentFile, xpMessageAttachment.getType(), xpMessageAttachment.getDescription());
                            newAttachment.setRole(xpMessageAttachment.getRole());
                            newXpMessage.addAttachment(newAttachment);
                        });
                        this.messageDAO.updateMessageFolder(newXpMessage.getDatabaseId(), newXpMessage.getCurrentContentReferenceFolder());
                        this.fileRefDAO.insertMessageFileReference(newXpMessage.getDatabaseId(), newXpMessage.getCurrentContentReferenceFolder(), newXpMessage.getCurrentContentReference().getName(), newXpMessage.getCurrentContentType());
                        this._messengerLog.log2dbWithHref(217, xpMessage.getDatabaseId(), newXpMessage.getMessageId(), newXpMessage.getMessageId(), newXpMessage.getDatabaseId(), true);
                        this._messengerLog.log2dbWithHref(218, newXpMessage.getDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
                        this.inboundQueue.deliverMessageToAdapter(adapterId, newXpMessage);
                    }
                    catch (InboundQueueException | DbException | IOException e) {
                        LOG.error("Error while creating message copy for adapter '{}': {}", (Object)adapterId, (Object)e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error while processing message: {}", (Object)e.getMessage());
            throw new BaseFilterException(-1, e);
        }
    }

    private static XpMessage copyXpMessage(XpMessage xpMessage, String adapterId) {
        XpMessage newXpMessage = new XpMessage();
        newXpMessage.setAdapterId(adapterId);
        newXpMessage.setMessageId(adapterId + "-" + xpMessage.getMessageId());
        newXpMessage.setConversationDatabaseId(xpMessage.getConversationDatabaseId());
        newXpMessage.setConversationId(xpMessage.getConversationId());
        newXpMessage.setInboundMessage(true);
        newXpMessage.setSenderLocalId(xpMessage.getSenderLocalId());
        newXpMessage.setSenderInternalId(xpMessage.getSenderInternalId());
        newXpMessage.setReceiverLocalId(xpMessage.getReceiverLocalId());
        newXpMessage.setReceiverInternalId(xpMessage.getReceiverInternalId());
        newXpMessage.setAgreement(xpMessage.getAgreement());
        newXpMessage.setOwnPartner(xpMessage.getOwnPartner());
        newXpMessage.setCommunicationPartner(xpMessage.getCommunicationPartner());
        newXpMessage.setCommunication(xpMessage.getCommunication());
        newXpMessage.setMessageType(xpMessage.getMessageType());
        newXpMessage.setMessageVersion(xpMessage.getMessageVersion());
        newXpMessage.setSchemaSet(xpMessage.getSchemaSet());
        newXpMessage.setAckRequested(xpMessage.isAckRequested());
        newXpMessage.setCurrentContentType(xpMessage.getCurrentContentType());
        newXpMessage.setInternalSequenceNumber(xpMessage.getInternalSequenceNumber());
        newXpMessage.setMessagePackaging(xpMessage.getMessagePackaging());
        newXpMessage.setMessageTimestamp(xpMessage.getMessageTimestamp());
        newXpMessage.setPayloadEncoding(xpMessage.getPayloadEncoding());
        newXpMessage.setPayloadLineEnding(xpMessage.getPayloadLineEnding());
        newXpMessage.setPayloadNamespaceUri(xpMessage.getPayloadNamespaceUri());
        newXpMessage.setPayloadRootElement(xpMessage.getPayloadRootElement());
        newXpMessage.setPayloadXPath(xpMessage.getPayloadXPath());
        newXpMessage.setProcessingDirectives(xpMessage.getProcessingDirectives());
        newXpMessage.setProcessingDirective(PROCESSING_DIRECTIVE_DUPLICATE_FOR_MESSAGE, xpMessage.getMessageId());
        newXpMessage.setProtocol(xpMessage.getProtocol());
        newXpMessage.setSchemaLocation(xpMessage.getSchemaLocation());
        newXpMessage.setSchemaNamespace(xpMessage.getSchemaNamespace());
        newXpMessage.setTestMessage(xpMessage.isTestMessage());
        newXpMessage.setXpEnvelopeName(xpMessage.getXpEnvelopeName());
        newXpMessage.setXpEnvelopeNamespaceUri(xpMessage.getXpEnvelopeNamespaceUri());
        newXpMessage.setXpEnvelopeSchemaFile(xpMessage.getXpEnvelopeSchemaFile());
        return newXpMessage;
    }

    protected Optional<MessageMulticastInboundRule> getMatchingRule(XpMessage xpMessage) {
        List<MessageMulticastInboundRule> messageMulticastInboundRules;
        String senderInternalId = xpMessage.getSenderInternalId();
        String receiverInternalId = xpMessage.getReceiverInternalId();
        String messageType = xpMessage.getMessageType();
        String messageVersion = xpMessage.getMessageVersion();
        String schemaSet = xpMessage.getSchemaSet();
        try {
            messageMulticastInboundRules = this.messageMulticastRuleService.getMessageMulticastInboundRules();
        }
        catch (Exception e) {
            LOG.error("Error while getting multicast rules: {}", (Object)e.getMessage());
            return Optional.empty();
        }
        for (int i = 0; i < messageMulticastInboundRules.size(); ++i) {
            boolean foundMatch;
            List<MessageTypeModel> messageTypes;
            List<String> receiverBackendIds;
            MessageMulticastInboundRule messageMulticastInboundRule = messageMulticastInboundRules.get(i);
            List<String> senderBackendIds = messageMulticastInboundRule.getSenderBackendIds();
            if (senderBackendIds != null && !senderBackendIds.isEmpty() && !senderBackendIds.contains(senderInternalId) || (receiverBackendIds = messageMulticastInboundRule.getReceiverBackendIds()) != null && !receiverBackendIds.isEmpty() && !receiverBackendIds.contains(receiverInternalId) || (messageTypes = messageMulticastInboundRule.getMessageTypes()) != null && !messageTypes.isEmpty() && messageTypes.stream().noneMatch(messageTypeModel -> messageTypeModel.getMessageType().equals(messageType) && messageTypeModel.getMessageVersion().equals(messageVersion) && messageTypeModel.getSchemaSet().equals(schemaSet))) continue;
            try {
                foundMatch = this.isFoundMatchInContent(xpMessage, messageMulticastInboundRule);
            }
            catch (Exception e) {
                LOG.warn("Error while checking content restrictions: {}", (Object)e.getMessage());
                continue;
            }
            if (!foundMatch) continue;
            LOG.debug("Message matched multicast rule no. {}", (Object)i);
            return Optional.of(messageMulticastInboundRule);
        }
        return Optional.empty();
    }

    private boolean isFoundMatchInContent(XpMessage xpMessage, MessageMulticastInboundRule messageMulticastInboundRule) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        boolean foundMatch;
        block17: {
            List<ContentRestrictionModel> contentRestrictions = messageMulticastInboundRule.getContentRestrictions();
            if (contentRestrictions == null || contentRestrictions.isEmpty()) {
                return true;
            }
            foundMatch = true;
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(xpMessage.getCurrentContentReference().toPath(), new OpenOption[0]));){
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document xmlDocument = builder.parse(inputStream);
                for (ContentRestrictionModel contentRestriction : contentRestrictions) {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    String foundContentValue = (String)xPath.compile(contentRestriction.getXPath()).evaluate(xmlDocument, XPathConstants.STRING);
                    switch (contentRestriction.getOperator()) {
                        case EQUALS: {
                            if (!foundContentValue.equals(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case NOT_EQUALS: {
                            if (foundContentValue.equals(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case CONTAINS: {
                            if (!foundContentValue.contains(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case NOT_CONTAINS: {
                            if (foundContentValue.contains(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case STARTS_WITH: {
                            if (!foundContentValue.startsWith(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case ENDS_WITH: {
                            if (!foundContentValue.endsWith(contentRestriction.getValue())) break;
                            break block17;
                        }
                        case GREATER_THAN: {
                            if (foundContentValue.compareTo(contentRestriction.getValue()) <= 0) break;
                            break block17;
                        }
                        case LESS_THAN: {
                            if (foundContentValue.compareTo(contentRestriction.getValue()) >= 0) break;
                            break block17;
                        }
                        default: {
                            LOG.error("Unknown operator: {}", (Object)contentRestriction.getOperator());
                        }
                    }
                    foundMatch = false;
                }
            }
        }
        return foundMatch;
    }

    @Override
    public UIOption[] getUIOptions() {
        return new UIOption[0];
    }
}

