/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecrypter;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import org.springframework.context.ApplicationContext;

public class DecryptionFilter
extends BaseFilter<IDecrypter> {
    public DecryptionFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("DecryptionFilter", messengerLog, uiConfig, applicationContext);
    }

    @Override
    protected Class<IDecrypter> getFilterPluginClass() {
        return IDecrypter.class;
    }

    @Override
    public void doFilter(XpMessage message) throws CryptException, BaseFilterException {
        String encryption = message.getProcessingDirective("CryptoAlgorithm");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("EncryptionAlgorithm defined in processing directives is: {}", (Object)encryption);
        }
        String cryptOption = null;
        try {
            cryptOption = message.getCommunication().getPipelineOptionValueForMessage("/Encryption", message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (cryptOption != null && cryptOption.length() > 0) {
            for (IFilterPlugin plugin : this._plugins) {
                if (!plugin.getOptionValue().equals(cryptOption)) continue;
                try {
                    plugin.doFilter(message);
                    break;
                }
                catch (BaseFilterException bfe) {
                    if (bfe instanceof CryptException) {
                        throw (CryptException)bfe;
                    }
                    throw bfe;
                }
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("No encryption selected in agreement");
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        UIOption[] options = new UIOption[]{};
        return options;
    }
}

