/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseFilterPlugin {
    protected Logger _log = null;
    private String _pluginName = null;
    private final MessengerLog _messengerLog;

    public BaseFilterPlugin(String pluginName, MessengerLog messengerLog) {
        this._pluginName = pluginName;
        this._messengerLog = messengerLog;
        this.initLogger();
    }

    private void initLogger() {
        this._log = LogManager.getLogger((String)("Messenger." + this._pluginName));
    }

    protected String updateCurrentPayloadFilename(XpMessage xpMessage, boolean inbound) throws IOException {
        if (inbound) {
            File currentContentReference = xpMessage.getCurrentContentReference();
            String payloadFilename = currentContentReference.getName();
            if (payloadFilename.endsWith(this.getDefaultExtension())) {
                payloadFilename = payloadFilename.substring(0, payloadFilename.length() - this.getDefaultExtension().length());
            } else {
                File processedPayload = new File(currentContentReference.getParent(), payloadFilename + this.getDefaultExtension());
                if (!currentContentReference.renameTo(processedPayload)) {
                    throw new IOException("Could not rename file " + currentContentReference.getAbsolutePath() + " to " + String.valueOf(processedPayload));
                }
                xpMessage.setCurrentContentReference(processedPayload);
            }
            return payloadFilename;
        }
        throw new IllegalAccessError("Don't use this method for the outbound direction.");
    }

    protected void updateProcessedOriginalFilename(XpMessage xpMessage, boolean inbound) {
        String extention = this.getDefaultExtension();
        Object processedOriginalFilename = xpMessage.getProcessingDirective("ProcessedOriginalFilename");
        if (inbound) {
            if (((String)processedOriginalFilename).endsWith(extention)) {
                processedOriginalFilename = ((String)processedOriginalFilename).substring(0, ((String)processedOriginalFilename).length() - extention.length());
                xpMessage.setProcessingDirective("ProcessedOriginalFilename", (String)processedOriginalFilename);
                if (this._log.isTraceEnabled()) {
                    this._log.trace("Set processing directive ProcessedOriginalFilename to {}", processedOriginalFilename);
                }
            }
        } else {
            processedOriginalFilename = (String)processedOriginalFilename + extention;
            xpMessage.setProcessingDirective("ProcessedOriginalFilename", (String)processedOriginalFilename);
            if (this._log.isTraceEnabled()) {
                this._log.trace("Set processing directive ProcessedOriginalFilename to {}", processedOriginalFilename);
            }
        }
    }

    protected String getDefaultExtension() {
        throw new IllegalAccessError("This method is not overridden by the subclass.");
    }

    protected void messageLog(int textId, long messageDatatID, String messageId, String additionalInfo) {
        try {
            this._messengerLog.log2db(textId, messageDatatID, additionalInfo);
        }
        catch (Exception e) {
            this._log.warn("{}  message:{} code:{} text:{}", (Object)e.getMessage(), (Object)messageId, (Object)textId, (Object)additionalInfo);
        }
    }

    public int write(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int size = 0;
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            size += length;
            out.write(buffer, 0, length);
        }
        return size;
    }
}

