/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import java.util.List;

public class RemoteMaintenanceIntervalDAO
extends BaseDAO {
    private final ReferenceDateTask referenceDateTask;

    public RemoteMaintenanceIntervalDAO(HibernateSessionFactory hibernateSessionFactory, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this.referenceDateTask = referenceDateTask;
    }

    public List<RemoteMaintenanceInterval> readAll() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("from RemoteMaintenanceInterval", RemoteMaintenanceInterval.class).getResultList();
            return list;
        }
    }

    public void replaceAll(List<RemoteMaintenanceInterval> newIntervals) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("delete from RemoteMaintenanceInterval").executeUpdate();
            for (RemoteMaintenanceInterval interval : newIntervals) {
                entityManager.persist((Object)interval);
            }
            entityManager.getTransaction().commit();
        }
    }

    public void create(RemoteMaintenanceInterval interval) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.persist((Object)interval);
            entityManager.getTransaction().commit();
        }
    }

    public void deleteAll(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("delete from RemoteMaintenanceInterval where partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public void update(String partnerId, List<RemoteMaintenanceInterval> newIntervals) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("delete from RemoteMaintenanceInterval where partnerId = :partnerId").setParameter("partnerId", (Object)partnerId).executeUpdate();
            if (newIntervals != null) {
                for (RemoteMaintenanceInterval interval : newIntervals) {
                    entityManager.persist((Object)interval);
                }
            }
            entityManager.getTransaction().commit();
        }
    }

    public List<RemoteMaintenanceInterval> readAll(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("from RemoteMaintenanceInterval where partnerId = :partnerId", RemoteMaintenanceInterval.class).setParameter("partnerId", (Object)partnerId).getResultList();
            return list;
        }
    }
}

