/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AgreementListItem;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerAgreement;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PartnerAgreementDAO
extends BaseDAO {
    public PartnerAgreementDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public List<PartnerAgreement> loadAllPartnerAgreements() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM " + PartnerAgreement.class.getSimpleName(), PartnerAgreement.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<AgreementListItem> loadAgreementList() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            List list = entityManager.createQuery("FROM " + AgreementListItem.class.getSimpleName(), AgreementListItem.class).getResultList();
            return list;
        }
    }

    public PartnerAgreement loadPartnerAgreement(String id) {
        PartnerAgreement partnerAgreement;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                partnerAgreement = this.loadPartnerAgreement(entityManager, id);
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return partnerAgreement;
    }

    private PartnerAgreement loadPartnerAgreement(EntityManager entityManager, String id) {
        try {
            return (PartnerAgreement)entityManager.find(PartnerAgreement.class, (Object)id);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void importPartnerAgreement(PartnerAgreement newPartnerAgreement) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)newPartnerAgreement);
            entityManager.getTransaction().commit();
        }
    }

    public boolean storePartnerAgreement(PartnerAgreement agreement) {
        boolean isNewAgreement = !this.agreementExists(agreement.getId());
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            if (Objects.isNull(agreement.getLastChange())) {
                agreement.setLastChange(OffsetDateTime.now(ZoneOffset.UTC));
            }
            entityManager.merge((Object)agreement);
            entityManager.getTransaction().commit();
        }
        return isNewAgreement;
    }

    public boolean agreementExists(String id) {
        return Objects.nonNull(this.getLastChanged(id));
    }

    public void deletePartnerAgreement(String id) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("DELETE FROM " + PartnerAgreement.class.getSimpleName() + " WHERE id = :id").setParameter("id", (Object)id).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public OffsetDateTime getLastChanged(String id) {
        OffsetDateTime offsetDateTime;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT lastChange FROM " + PartnerAgreement.class.getSimpleName() + " WHERE id = :id", OffsetDateTime.class);
                query.setParameter("id", (Object)id);
                offsetDateTime = (OffsetDateTime)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return offsetDateTime;
    }

    public Map<String, OffsetDateTime> getAllAgreementIds() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Map<String, OffsetDateTime> map = entityManager.createQuery("SELECT id, lastChange FROM " + PartnerAgreement.class.getSimpleName(), Object[].class).getResultStream().collect(Collectors.toMap(row -> (String)row[0], row -> (OffsetDateTime)row[1]));
            return map;
        }
    }

    public Map<String, OffsetDateTime> getAgreementIdsFor(String partnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Map<String, OffsetDateTime> map = entityManager.createQuery("SELECT id, lastChange FROM %s\nWHERE ownPartnerId = :partnerId OR communicationPartnerId = :partnerId\n".formatted(PartnerAgreement.class.getSimpleName()), Object[].class).setParameter("partnerId", (Object)partnerId).getResultStream().collect(Collectors.toMap(row -> (String)row[0], row -> (OffsetDateTime)row[1]));
            return map;
        }
    }

    public Map.Entry<String, OffsetDateTime> getAgreementIdFor(String ownPartnerId, String communicationPartnerId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Map.Entry entry = entityManager.createQuery("SELECT id, lastChange FROM %s\nWHERE ownPartnerId = :partnerId AND communicationPartnerId = :partnerId2\n".formatted(PartnerAgreement.class.getSimpleName()), Object[].class).setParameter("partnerId", (Object)ownPartnerId).setParameter("partnerId2", (Object)communicationPartnerId).getResultStream().collect(Collectors.toMap(row -> (String)row[0], row -> (OffsetDateTime)row[1])).entrySet().stream().findFirst().orElse(null);
            return entry;
        }
    }

    public String getLocalPartnerOfAgreement(String agreementId) {
        String string;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT ownPartnerId FROM " + PartnerAgreement.class.getSimpleName() + " WHERE id = :id", String.class);
                query.setParameter("id", (Object)agreementId);
                string = (String)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return string;
    }

    public void saveUrlIsValid(String agreementId, boolean urlIsValid) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE " + PartnerAgreement.class.getSimpleName() + " SET urlIsValid = :isValid WHERE id = :id").setParameter("id", (Object)agreementId).setParameter("isValid", (Object)urlIsValid).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public void saveFallbackUrlIsValid(String agreementId, boolean urlIsValid) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE " + PartnerAgreement.class.getSimpleName() + " SET fallbackUrlIsValid = :isValid WHERE id = :id").setParameter("id", (Object)agreementId).setParameter("isValid", (Object)urlIsValid).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }
}

