/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.NotificationReceiver;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.LogChannel;
import de.pontonconsulting.xmlpipe.messenger.database.LogChannelMail;
import de.pontonconsulting.xmlpipe.messenger.database.LogException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageLogDAO;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotification;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessengerLog
extends BaseDAO {
    private static final String HREF_END = "</a>";
    private static final String HREF_MIDDLE = "'>";
    private static final String HREF_START = "<a href='MessageMonitorDetail.do?messageid=";
    private static final String HREF_START_CONT = "&messagedataid=";
    private static final String HREF_INBOUND = "&inbound=";
    private final Map<Integer, List<LogChannel>> _logChannels = new HashMap<Integer, List<LogChannel>>();
    private final boolean _logOnlyErrors;
    private final MessengerConfig _messengerConfig;
    private final MessageLogDAO _messageLogDAO;
    private final MessageDAO _messageDAO;
    private final EMailNotification _emailNotification;

    public MessengerLog(MessengerConfig messengerConfig, MessageLogDAO messageLogDAO, MessageDAO messageDAO, EMailNotification emailNotification, HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
        this._messengerConfig = messengerConfig;
        this._messageLogDAO = messageLogDAO;
        this._messageDAO = messageDAO;
        this._emailNotification = emailNotification;
        boolean temp = false;
        try {
            temp = this._messengerConfig.isDetailLogOnlyErrors();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        this._logOnlyErrors = temp;
    }

    @PostConstruct
    public void init() throws Exception {
        this.initLogChannels();
    }

    public void reinitLogChannels() {
        this.resetLogChannels();
        try {
            this.initLogChannels();
        }
        catch (Exception e) {
            _log.error("Could not reinitialze log channels: " + e.toString());
        }
    }

    private void initLogChannels() throws Exception {
        List<NotificationReceiver> notificationReceivers;
        try {
            notificationReceivers = this._messengerConfig.getNotificationReceivers();
        }
        catch (JAXBException e) {
            Object msg = e.getMessage();
            msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
            msg = "Could not read notification receivers from messenger configuration" + (String)msg;
            _log.error("Could not set up Log Channels:{}", msg);
            throw e;
        }
        for (NotificationReceiver notificationReceiver : notificationReceivers) {
            LogChannelMail logChannel = new LogChannelMail(notificationReceiver.getEmail(), notificationReceiver.isWithAttachement(), notificationReceiver.getSubjectElements());
            logChannel.setEMailNotification(this._emailNotification);
            logChannel.setEntityManagerSupplier(this::createNewEntityManager);
            for (int event : notificationReceiver.getEvents()) {
                this.registerLogChannel(logChannel, event);
            }
        }
        _log.info("Log Channel setup completed");
    }

    public void registerLogChannel(LogChannel logChannel, int messageCode) {
        Integer key = messageCode;
        List<LogChannel> channels = this._logChannels.get(key);
        if (channels == null) {
            channels = new ArrayList<LogChannel>();
        }
        if (channels.contains(logChannel)) {
            return;
        }
        channels.add(logChannel);
        this._logChannels.put(key, channels);
    }

    public void resetLogChannels() {
        this._logChannels.clear();
    }

    private boolean log(int messageCode, long messageDataID, String description) throws LogException {
        boolean result = false;
        MessageInfo info = null;
        List<LogChannel> channels = this._logChannels.get(messageCode);
        if (channels != null) {
            try {
                info = this._messageDAO.getMessageInfo(messageDataID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (LogChannel channel : channels) {
                channel.log(messageCode, info, description);
                result = true;
            }
        }
        return result;
    }

    public void log2dbWithHref(int logId, long messageDataID, String text, String hrefMessageId, long hrefMessageDataId, boolean inbound) {
        String encodedMessageId = URLEncoder.encode(hrefMessageId, StandardCharsets.UTF_8);
        this.log2db(logId, messageDataID, HREF_START + encodedMessageId + HREF_INBOUND + inbound + HREF_START_CONT + hrefMessageDataId + HREF_MIDDLE + text + HREF_END);
    }

    public void log2db(int messageCode, long messageDataID, String description) {
        if (!this._logOnlyErrors || messageCode >= 500) {
            this._messageLogDAO.log2db(messageCode, messageDataID, description);
        }
        try {
            this.log(messageCode, messageDataID, description);
        }
        catch (LogException e) {
            _log.error("error on one log channel: {}", (Object)e.getMessage());
        }
    }

    public void deleteLogs(long databaseId) {
        try {
            this._messageLogDAO.deleteFromMessageLog(databaseId);
        }
        catch (DbException e) {
            _log.error("error while deleting log messages for {}", (Object)databaseId);
        }
    }
}

