/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerLicense;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MessengerActivationDAO
extends BaseDAO {
    private static final String PARAM_INSTANCE_ALIAS = "instanceAlias";
    private static final int LICENSE_ID = 0;
    public static final int HEARTBEAT_MINUTES = 1;
    public static final int MAX_HEARTBEAT_MINUTES = 3;
    private final ReferenceDateTask referenceDateTask;

    public MessengerActivationDAO(HibernateSessionFactory hibernateSessionFactory, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this.referenceDateTask = referenceDateTask;
    }

    public Optional<OffsetDateTime> getTimestampForMessengerActivation(String instanceAlias) {
        Optional<OffsetDateTime> optional;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT timestamp FROM MessengerActivation WHERE instanceAlias = :instanceAlias", OffsetDateTime.class);
                query.setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias);
                optional = Optional.of((OffsetDateTime)query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Optional.empty();
                }
            }
            entityManager.close();
        }
        return optional;
    }

    public MessengerActivation loadMessengerActivation(String instanceAlias) {
        MessengerActivation messengerActivation;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerActivation WHERE instanceAlias = :instanceAlias", MessengerActivation.class);
                query.setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias);
                messengerActivation = (MessengerActivation)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return new MessengerActivation().setInstanceAlias(instanceAlias);
                }
            }
            entityManager.close();
        }
        return messengerActivation;
    }

    public List<MessengerActivation> loadAllMessengerActivations() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerActivation ORDER BY messengerId", MessengerActivation.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public List<MessengerLicense> loadAllMessengerLicenses() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerLicense", MessengerLicense.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public Optional<OffsetDateTime> getTimestampForMessengerLicense() {
        Optional<OffsetDateTime> optional;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT timestamp FROM MessengerLicense WHERE id = 0", OffsetDateTime.class);
                optional = Optional.of((OffsetDateTime)query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Optional.empty();
                }
            }
            entityManager.close();
        }
        return optional;
    }

    public MessengerLicense loadMessengerLicense() {
        MessengerLicense messengerLicense;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerLicense WHERE id = 0", MessengerLicense.class);
                messengerLicense = (MessengerLicense)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return messengerLicense;
    }

    public Long getLicenseSerialNumber() {
        Long l;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                String serialNumber = (String)entityManager.createQuery("SELECT serialNumber FROM MessengerLicense WHERE id = 0", String.class).getSingleResult();
                Long l2 = l = Objects.isNull(serialNumber) ? null : Long.valueOf(serialNumber);
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return l;
    }

    public byte[] loadMessengerProductIdentifierCert(String instanceAlias) {
        byte[] byArray;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                byArray = (byte[])entityManager.createQuery("SELECT productCertificate FROM MessengerActivation WHERE instanceAlias = :instanceAlias", byte[].class).setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return byArray;
    }

    public byte[] loadClusterProductIdentifierCert() {
        byte[] byArray;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                byArray = (byte[])entityManager.createQuery("SELECT productCertificate FROM MessengerLicense WHERE id = 0", byte[].class).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return byArray;
    }

    public byte[] loadMessengerProductIdentifierKey(String instanceAlias) {
        byte[] byArray;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                byArray = (byte[])entityManager.createQuery("SELECT productKey FROM MessengerActivation WHERE instanceAlias = :instanceAlias", byte[].class).setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return byArray;
    }

    public byte[] loadClusterProductIdentifierKey() {
        byte[] byArray;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                byArray = (byte[])entityManager.createQuery("SELECT productKey FROM MessengerLicense WHERE id = 0", byte[].class).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return byArray;
    }

    public void storeMessengerActivation(byte[] activation, String instanceAlias, String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            entityManager.getTransaction().begin();
            MessengerActivation messengerActivation = (MessengerActivation)entityManager.find(MessengerActivation.class, (Object)instanceAlias);
            if (Objects.isNull(messengerActivation)) {
                messengerActivation = new MessengerActivation();
                messengerActivation.setInstanceAlias(instanceAlias);
            }
            messengerActivation.setActivation(activation);
            messengerActivation.setUsername(username);
            messengerActivation.setTimestamp(now);
            entityManager.persist((Object)messengerActivation);
            entityManager.getTransaction().commit();
        }
    }

    public void removeActivation(String instanceAlias, String username) {
        this.storeMessengerActivation(new byte[0], instanceAlias, username);
    }

    public void storeInstanceProductKey(byte[] productKey, byte[] productCertificate, String instanceAlias, String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            entityManager.getTransaction().begin();
            MessengerActivation messengerActivation = (MessengerActivation)entityManager.find(MessengerActivation.class, (Object)instanceAlias);
            if (Objects.isNull(messengerActivation)) {
                messengerActivation = new MessengerActivation();
                messengerActivation.setInstanceAlias(instanceAlias);
            }
            messengerActivation.setProductKey(productKey);
            messengerActivation.setProductCertificate(productCertificate);
            messengerActivation.setUsername(username);
            messengerActivation.setTimestamp(now);
            entityManager.persist((Object)messengerActivation);
            entityManager.getTransaction().commit();
        }
    }

    public void storeClusterProductKey(byte[] productKey, byte[] productCertificate, String clusterId, String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            entityManager.getTransaction().begin();
            MessengerLicense messengerLicense = (MessengerLicense)entityManager.find(MessengerLicense.class, (Object)0);
            if (Objects.isNull(messengerLicense)) {
                messengerLicense = new MessengerLicense();
                messengerLicense.setId(0);
            }
            messengerLicense.setProductKey(productKey);
            messengerLicense.setProductCertificate(productCertificate);
            messengerLicense.setClusterId(clusterId);
            messengerLicense.setTimestamp(now);
            messengerLicense.setUsername(username);
            entityManager.persist((Object)messengerLicense);
            entityManager.getTransaction().commit();
        }
    }

    public Integer storeInstanceId(String instanceAlias, String instanceId, String username, String ipAddress) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            MessengerActivation messengerActivation = (MessengerActivation)entityManager.find(MessengerActivation.class, (Object)instanceAlias);
            entityManager.getTransaction().begin();
            if (Objects.isNull(messengerActivation)) {
                messengerActivation = new MessengerActivation();
                messengerActivation.setInstanceAlias(instanceAlias);
            }
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            messengerActivation.setUsername(username);
            messengerActivation.setIpAddress(ipAddress);
            messengerActivation.setTimestamp(now);
            messengerActivation.setLastStartup(now);
            messengerActivation.setLastHeartBeat(now);
            messengerActivation.setInstanceId(instanceId);
            entityManager.persist((Object)messengerActivation);
            entityManager.getTransaction().commit();
            if (Objects.nonNull(messengerActivation.getMessengerId())) {
                Integer n = messengerActivation.getMessengerId();
                return n;
            }
            Integer n = this.getMessengerId(instanceAlias);
            return n;
        }
    }

    public OffsetDateTime storeMessengerLicense(X509Certificate license, String username) throws CertificateEncodingException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            byte[] licenseBytes = Objects.isNull(license) ? null : license.getEncoded();
            String serialNumber = Objects.isNull(license) ? null : String.valueOf(license.getSerialNumber());
            entityManager.getTransaction().begin();
            MessengerLicense messengerLicense = (MessengerLicense)entityManager.find(MessengerLicense.class, (Object)0);
            if (Objects.isNull(messengerLicense)) {
                messengerLicense = new MessengerLicense();
                messengerLicense.setId(0);
            }
            messengerLicense.setLicense(licenseBytes);
            messengerLicense.setSerialNumber(serialNumber);
            messengerLicense.setTimestamp(now);
            messengerLicense.setUsername(username);
            entityManager.persist((Object)messengerLicense);
            entityManager.getTransaction().commit();
            OffsetDateTime offsetDateTime = now;
            return offsetDateTime;
        }
    }

    public boolean doesMessengerActivationExist(String instanceAlias) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT COUNT(mc) FROM MessengerActivation mc WHERE mc.instanceAlias = :instanceAlias", Long.class);
            query.setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias);
            boolean bl = (Long)query.getSingleResult() > 0L;
            return bl;
        }
    }

    public String getOtherActiveActivationInstanceAlias(String instanceAlias) {
        String string;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                OffsetDateTime maxLastHeartBeat = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(3L);
                string = (String)entityManager.createQuery("SELECT instanceAlias FROM MessengerActivation\nWHERE instanceAlias != :instanceAlias AND lastHeartBeat > :maxLastHeartBeat\nORDER BY lastHeartBeat DESC", String.class).setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias).setParameter("maxLastHeartBeat", (Object)maxLastHeartBeat).setMaxResults(1).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return string;
    }

    public boolean doesMessengerLicenseExist() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            boolean bl = (Long)entityManager.createQuery("SELECT COUNT(mc) FROM MessengerLicense mc WHERE mc.id = 0", Long.class).getSingleResult() > 0L;
            return bl;
        }
    }

    public void importMessengerActivation(MessengerActivation activation) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)activation);
            entityManager.getTransaction().commit();
        }
    }

    public void importMessengerLicense(MessengerLicense license) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)license);
            entityManager.getTransaction().commit();
        }
    }

    public void storeHeartBeat(String instanceAlias) {
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE MessengerActivation\nSET lastHeartBeat = :now\nWHERE instanceAlias = :instanceAlias").setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias).setParameter("now", (Object)now).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public Integer getMessengerId(String instanceAlias) {
        Integer n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                n = (Integer)entityManager.createQuery("SELECT messengerId FROM MessengerActivation messenger WHERE instanceAlias = :instanceAlias", Integer.class).setParameter(PARAM_INSTANCE_ALIAS, (Object)instanceAlias).getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return n;
    }
}

