/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.ConnectionPool;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class MessageLogDAO
extends BaseDAO {
    private static final String SQL_INSERT_LOG = "INSERT INTO MESSAGE_LOG VALUES (?,?,?,?,?)";
    private static final String SQL_DELETE_MESSAGE_LOG_BY_MESSAGE_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageLog ml WHERE ml.messageID=:messageId";
    private static final String SQL_DELETE_MESSAGE_LOG_BY_MESSAGE_IDS = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageLog ml WHERE ml.messageID in (:messageIds)";
    private static final String TABLE_MESSAGE_LOG = "MESSAGE_LOG";
    private static final String TABLE_MESSAGE_LOG_ADDITIONAL_TEXT = "ADDITIONAL_TEXT";
    public static final long TEST_VALUE_TIMESTAMP = 12345678901234567L;
    public static final int TEST_VALUE_TEXT_ID = 1234567890;
    public static final String TEST_VALUE_ADDITIONAL_TEXT = "One Test Log Entry";
    public static final AtomicLong _id = new AtomicLong(System.currentTimeMillis());
    private int _maxLogString = 128;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig _messengerConfig;

    public MessageLogDAO(HibernateSessionFactory hibernateSessionFactory, ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig) {
        super(hibernateSessionFactory);
        this.referenceDateTask = referenceDateTask;
        this._messengerConfig = messengerConfig;
    }

    @PostConstruct
    public void init() throws SQLException {
        this.updateMaxLogString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxLogString() throws SQLException {
        ResultSet logTable;
        Connection conn;
        block5: {
            conn = null;
            logTable = null;
            try {
                conn = ConnectionPool.getDataSource().getConnection();
                DatabaseMetaData dbmd = conn.getMetaData();
                logTable = dbmd.getColumns(null, null, TABLE_MESSAGE_LOG, TABLE_MESSAGE_LOG_ADDITIONAL_TEXT);
                if (logTable.next()) {
                    this._maxLogString = logTable.getInt("COLUMN_SIZE");
                    _log.debug("Database reported a size of the ADDITIONAL_TEXT in MESSAGE_LOG table to be {} chars", (Object)this._maxLogString);
                    break block5;
                }
                logTable = dbmd.getColumns("%", "%", TABLE_MESSAGE_LOG, TABLE_MESSAGE_LOG_ADDITIONAL_TEXT);
                if (logTable.next()) {
                    this._maxLogString = logTable.getInt("COLUMN_SIZE");
                    _log.debug("Database reported a size of the ADDITIONAL_TEXT in MESSAGE_LOG table to be {} chars", (Object)this._maxLogString);
                    break block5;
                }
                logTable = dbmd.getColumns(null, null, TABLE_MESSAGE_LOG.toLowerCase(), TABLE_MESSAGE_LOG_ADDITIONAL_TEXT.toLowerCase());
                if (logTable.next()) {
                    this._maxLogString = logTable.getInt("COLUMN_SIZE");
                    _log.debug("Database reported a size of the ADDITIONAL_TEXT in MESSAGE_LOG table to be {} chars", (Object)this._maxLogString);
                    break block5;
                }
                _log.warn("Database did not report the size of the ADDITIONAL_TEXT in MESSAGE_LOG table, so we use the default of {} chars", (Object)this._maxLogString);
            }
            catch (Throwable throwable) {
                this.closeResultSet(logTable);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(logTable);
        this.closeConnection(conn);
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            MessageLog messageLog = new MessageLog();
            messageLog.setId(this.getNextId());
            messageLog.setTimestamp(12345678901234567L);
            messageLog.setMessageID(testMessage.getId());
            messageLog.setAdditionalText(TEST_VALUE_ADDITIONAL_TEXT);
            messageLog.setLogMessageID(1234567890);
            entityManager.persist((Object)messageLog);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13031, "DB Consistency check for table 'MESSAGE_LOG' failed. Reason: " + e.toString());
        }
    }

    public void log2db(int messageCode, long messageDataID, String description) {
        if (description != null && description.length() > this._maxLogString) {
            _log.info("description for log entry is longer than {} chars. it is shortend to fit into the database", (Object)this._maxLogString);
            description = description.substring(0, this._maxLogString);
        }
        try {
            this.writeLog2db(messageCode, messageDataID, this.referenceDateTask.getReferenceCurrentTimeMillis(), description);
        }
        catch (DbException e) {
            _log.error("Could not insert process log data to database: " + e.toString());
            _log.error("message database id:" + messageDataID + " code:" + messageCode + " desc:" + description);
        }
    }

    public void writeLog2db(int messageCode, long messageDataID, long timestamp, String description) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_INSERT_LOG);
            stmt.setLong(1, this.getNextId());
            stmt.setLong(2, timestamp);
            stmt.setLong(3, messageDataID);
            stmt.setInt(4, messageCode);
            stmt.setString(5, description);
            stmt.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            try {
                this.rollbackConnection(conn);
                _log.error("Could not insert process log data to database: " + e.toString());
                throw new DbException(13066, "Could not insert process log data to database: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(conn);
    }

    public void dbCleanup(long testMessageDatabaseId) throws DbException {
        this.deleteFromMessageLog(testMessageDatabaseId);
    }

    public int deleteFromMessageLog(long messageDataId) throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int result = this.deleteFromMessageLog(messageDataId, entityManager);
                entityManager.getTransaction().commit();
                n = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EntityNotFoundException e) {
                    return 0;
                }
            }
            entityManager.close();
        }
        return n;
    }

    public int deleteFromMessageLog(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_MESSAGE_LOG_BY_MESSAGE_ID).setParameter("messageId", (Object)messageDataId).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13054, "Could not delete Message Log from Database: " + String.valueOf(e));
        }
    }

    public int deleteByMessageDataIds(Collection<Long> messageDataIds, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_MESSAGE_LOG_BY_MESSAGE_IDS).setParameter("messageIds", messageDataIds).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13054, "Could not delete Message Log from Database: " + String.valueOf(e));
        }
    }

    private long getNextId() {
        long id = _id.incrementAndGet();
        if (this._messengerConfig.isClusterEnabled()) {
            long messengerId = this._messengerConfig.getMessengerId();
            long t = messengerId << 48;
            id = t | id;
        }
        return id;
    }
}

