/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.ConnectionPool;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.MessageExistsException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.BackendPartnerId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Conversation;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ConversationReference;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageReference;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpDatabaseMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ConversationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class MessageDAO
extends BaseDAO {
    public static final String SEPARATOR = "\t";
    public static final int MSTATUS_NONE = -1;
    public static final int MSTATUS_UNKNOWN_MESSAGE = 0;
    public static final int MSTATUS_IN_PROCESS = 1;
    public static final int MSTATUS_IN_TRANSIT = 2;
    public static final int MSTATUS_OK = 3;
    public static final int MSTATUS_FAILED = 4;
    public static final int MSTATUS_ARCHIVED = 5;
    public static final int MSTATUS_RESOLVED = 6;
    public static final int DIRECTION_OUTBOUND = 0;
    public static final int DIRECTION_INBOUND = 1;
    int MAX_LOGINFO_SIZE_128 = 128;
    public static final int ARCHIVE_STATUS_INITIAL = 0;
    public static final int ARCHIVE_STATUS_ENQUEUED = 1;
    public static final int ARCHIVE_STATUS_RUNNING = 2;
    public static final int ARCHIVE_STATUS_ARCHIVED = 3;
    public static final int ARCHIVE_STATUS_FAILED_RESCHEDULE = 4;
    public static final int ARCHIVE_STATUS_FAILED = 99;
    private static final String UNKNOWN = "unknown";
    private static final int DEFAULT_FETCH_SIZE = 200;
    protected static final String TEST_VALUE_MESSAGE_ID = "MID-1234567890123456789@ponton-consulting.de";
    private static final String TEST_VALUE_FOLDER = "$ARCHIVE/inbound/2006/03/15/MID-1140017209504@ponton-consulting.de.zip";
    private static final long TEST_VALUE_CREATION_TIME = 12345678901234567L;
    private static final int TEST_VALUE_INBOUND = 1;
    private static final String TEST_VALUE_MESSAGE_TYPE = "PurchaseOrder";
    private static final String TEST_VALUE_SCHEMA_VERSION = "V2R10.1023";
    private static final String TEST_VALUE_SCHEMA_SET = "papinet";
    private static final String TEST_VALUE_PROTOCOL = "SMTP";
    private static final String TEST_VALUE_RECEIVER_ID = "local_testpartner1";
    private static final String TEST_VALUE_SENDER_ID = "local_testpartner2";
    private static final long TEST_VALUE_MESSAGE_TIME = 12345678901234567L;
    private static final int TEST_VALUE_TESTFLAG = 0;
    private static final int TEST_VALUE_STATUS = 5;
    private static final int TEST_VALUE_ACK_RECEIVED = 0;
    private static final int TEST_VALUE_MESSENGER_ID = 99;
    private static final String SQL_GET_MESSAGE_DATA_ID = "SELECT ID, INBOUND FROM MESSAGE WHERE MESSAGE_ID=?";
    private static final String SQL_GET_MESSAGE_DATA_ID_INBOUND = "SELECT ID, INBOUND FROM MESSAGE WHERE MESSAGE_ID=? AND INBOUND=?";
    private static final String SQL_GET_MESSAGE_TIMESTAMP = "SELECT MESSAGE_TIME FROM MESSAGE WHERE MESSAGE_ID=?";
    private static final String SQL_SELECT_SENDER_OF_MESSAGE = "SELECT SENDER_ID FROM MESSAGE WHERE ID=?";
    private static final String SQL_SELECT_FIRST_MSG = "SELECT ID FROM MESSAGE WHERE CONVERSATION=? AND SEQUENCE_NUMBER=? AND ID<>? AND INBOUND=?";
    private static final String SQL_SELECT_MAX_SEQUENCE = "SELECT SEQUENCE_NUMBER FROM MESSAGE WHERE CONVERSATION=? AND ID<>? AND INBOUND=? ORDER BY SEQUENCE_NUMBER DESC";
    private static final String SQL_SELECT_NUMBER_OF_PREDECESSORS = "SELECT COUNT(*) FROM MESSAGE WHERE CONVERSATION=? AND SEQUENCE_NUMBER<>-1 AND SEQUENCE_NUMBER<? AND INBOUND=? AND (STATUS=? OR STATUS=?)";
    private static final String SQL_SELECT_SEQ_OF_LAST_OK_MSG = "SELECT SEQUENCE_NUMBER FROM MESSAGE WHERE CONVERSATION=? AND INBOUND=? AND STATUS=? ORDER BY SEQUENCE_NUMBER DESC";
    private static final String SQL_SELECT_NUMBER_OF_SEQUENCE_DUPLICATES = "SELECT COUNT(*) FROM MESSAGE WHERE ID<>? AND CONVERSATION=? AND SEQUENCE_NUMBER=? AND INBOUND=? AND STATUS<>?";
    private static final String SQL_UPDATE_SEQUENCE_NUMBER = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET sequenceNumber=:sequence WHERE ID=:id";
    private static final String SQL_UPDATE_MESSAGE = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET messageId=:messageId, messageType=:messageType, schemaVersion=:schemaVersion, schemaSet=:schemaSet, protocol=:protocol, parent=:parent, receiverId=:receiverId, senderId=:senderId, loginfo=:loginfo, creationTime=:creationTime, messengerId=:messengerId WHERE ID=:id";
    private static final String SQL_UPDATE_MESSAGE_AND_STATUS = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET messageId=:messageId, messageType=:messageType, schemaVersion=:schemaVersion, schemaSet=:schemaSet, protocol=:protocol, parent=:parent, receiverId=:receiverId, senderId=:senderId, loginfo=:loginfo, creationTime=:creationTime, messengerId=:messengerId, status=:status WHERE ID=:id";
    private static final String SQL_UPDATE_MESSAGE_STATUS = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET status=:status WHERE ID=:id";
    private static final String SQL_UPDATE_ARCHIVE_STATUS = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET archiveStatus=:archiveStatus WHERE ID=:id AND archiveStatus != 3";
    private static final String SQL_UPDATE_PACKAGING_ID = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET packagingId=:packagingId WHERE ID=:id";
    private static final String SQL_UPDATE_MESSAGE_TIMESTAMP = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET messageTime=:messageTime WHERE ID=:id";
    private static final String SQL_UPDATE_MESSAGE_ACK = "UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message SET ackReceived=:ackReceived WHERE ID=:id";
    private static final String QUERY_DELETE_MESSAGE_BY_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message m WHERE m.id=:id";
    private static final String QUERY_DELETE_MESSAGE_BY_IDS = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message m WHERE m.id IN (:ids)";
    private final ReferenceDateTask referenceDateTask;
    private final ConversationDAO _conversationDAO;
    private final FileRefDAO _fileRefDAO;
    private final IFolders _folders;

    public MessageDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders, ReferenceDateTask referenceDateTask, ConversationDAO conversationDAO, FileRefDAO fileRefDAO) {
        super(hibernateSessionFactory);
        this.referenceDateTask = referenceDateTask;
        this._conversationDAO = conversationDAO;
        this._fileRefDAO = fileRefDAO;
        this._folders = folders;
    }

    public MessageInfo getMessageInfo(long messageDataId) throws DbException {
        MessageInfo result;
        block10: {
            result = null;
            try (EntityManager entityManager = this.createNewEntityManager();){
                Message message = this.getMessage(entityManager, messageDataId);
                if (message == null) break block10;
                result = this.getMessageInfo(message);
                result.setPayloadFile(null);
                for (FileRef fileRef : message.getFileRefs()) {
                    if (!FileType.isPayLoad(fileRef.getFileType())) continue;
                    if (result.getPayloadFile() != null) {
                        _log.error("Message {} contains more than one PAYLOAD FileRef [at least {} and {}]. Ignore second one", (Object)messageDataId, (Object)result.getPayloadFile().getName(), (Object)fileRef.getFileName());
                        break;
                    }
                    result.setPayloadFile(fileRef.getFileName());
                }
            }
            catch (RuntimeException e) {
                throw new DbException(13039, "Could not get MessageInfo for messageDataId " + messageDataId + " from Database:" + e.getMessage());
            }
        }
        return result;
    }

    public Message getMessage(EntityManager entityManager, long messageDataId) throws DbException {
        return (Message)entityManager.find(Message.class, (Object)messageDataId);
    }

    public Message getMessage(long messageDataId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, messageDataId);
            return message;
        }
    }

    public void batchMessagesOperation(BiFunction<CriteriaBuilder, Root, List<Predicate>> criteriaFunction, Consumer<MessageInfo> messageInfoConsumer) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(Message.class);
            Root messageRoot = criteriaQuery.from(Message.class);
            List<Predicate> predicates = criteriaFunction.apply(cb, messageRoot);
            criteriaQuery.where(predicates.toArray(new Predicate[0]));
            criteriaQuery.select((Selection)messageRoot);
            criteriaQuery.orderBy(new Order[]{cb.asc((Expression)messageRoot.get("creationTime"))});
            entityManager.createQuery(criteriaQuery).getResultList().forEach(m -> messageInfoConsumer.accept(this.getMessageInfo((Message)m)));
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get Message reference from Database: " + e.getMessage(), e);
        }
    }

    public MessageInfo getMessageInfo(String messageId, int direction) throws DbException {
        MessageInfo result = null;
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, messageId, direction);
            if (message != null) {
                result = this.getMessageInfo(message);
                Set<FileRef> filerefs = message.getFileRefs();
                if (!filerefs.isEmpty()) {
                    FileRef ref = filerefs.iterator().next();
                    result.setPayloadFile(ref.getFileName());
                }
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get Message reference from Database: " + e.getMessage(), e);
        }
        return result;
    }

    public Message getMessage(EntityManager entityManager, String messageId, int direction) throws DbException {
        try {
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(Message.class);
            Root messageRoot = criteriaQuery.from(Message.class);
            criteriaQuery.select((Selection)messageRoot);
            criteriaQuery.where(new Predicate[]{cb.equal((Expression)messageRoot.get("messageId"), (Object)messageId), cb.equal((Expression)messageRoot.get("inbound"), (Object)direction)});
            return (Message)entityManager.createQuery(criteriaQuery).getSingleResult();
        }
        catch (NoResultException e) {
            _log.debug("{} Message with messageId {} not found", (Object)(direction == 1 ? "Inbound" : "Outbound"), (Object)messageId);
            return null;
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get Message reference from Database: " + e.getMessage(), e);
        }
    }

    public Message getTestMessage() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, TEST_VALUE_MESSAGE_ID, 1);
            return message;
        }
    }

    public List<MessageInfo> getReferenceMessageInfos(long messageDataId) throws DbException {
        ArrayList<MessageInfo> references = new ArrayList<MessageInfo>();
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, messageDataId);
            if (message != null) {
                Set<Message> children = message.getChildren();
                for (Message child : children) {
                    MessageInfo temp = this.getMessageInfo(child);
                    references.add(temp);
                    Set<FileRef> filerefs = message.getFileRefs();
                    for (FileRef ref : filerefs) {
                        if (!FileType.isPayLoad(ref.getFileType())) continue;
                        temp.setPayloadFile(ref.getFileName());
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get Message reference from Database: " + e.getMessage());
        }
        return references;
    }

    public MessageInfo getMessageInfo(Message message) {
        MessageInfo info = new MessageInfo(message.getId(), message.getMessageId());
        info.setMessageFolder(this._folders.convertStringToFolder(message.getFolder()));
        info.setInbound(message.getInbound());
        Conversation conversation = message.getConversation();
        if (conversation != null) {
            info.setConversationId(conversation.getConversationId());
            info.setConversationDatabaseId(conversation.getId());
            info.setSequenceNumber(message.getSequenceNumber() == null ? message.getConversation().getSequenceOffset() : message.getSequenceNumber() + message.getConversation().getSequenceOffset());
        }
        info.setMessageType(message.getMessageType());
        info.setSchemaVersion(message.getSchemaVersion());
        info.setSchemaSet(message.getSchemaSet());
        info.setReceiverId(message.getReceiverId());
        info.setSenderId(message.getSenderId());
        info.setTimestamp(message.getMessageTime() == null ? 0L : message.getMessageTime());
        info.setStatus(message.getStatus());
        info.setArchiveStatus(message.getArchiveStatus());
        info.setMessengerId(message.getMessengerId());
        info.setPackagingId(message.getPackagingId());
        info.setAckReceived(message.getAckReceived() != null && message.getAckReceived() == 1);
        info.setSignedAckRequested(message.getSignedAckRequested() != null && message.getSignedAckRequested() == 1);
        info.setProtocol(message.getProtocol());
        info.setLogInfo(message.getLoginfo());
        info.setAdapterId(message.getAdapterId());
        return info;
    }

    public String getSenderOfMessage(long messageDataId) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String result = null;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_SENDER_OF_MESSAGE);
            stmt.setLong(1, messageDataId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13051, "Could not get the sender id for the message: " + messageDataId + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    public String getAdapterId(long messageDataId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            String adapterId = entityManager.createQuery("SELECT adapterId FROM Message WHERE id = :id", String.class).setParameter("id", (Object)messageDataId).getResultStream().findFirst().orElse(null);
            if (Objects.nonNull(adapterId) && adapterId.contains(SEPARATOR)) {
                String string = adapterId.split(SEPARATOR)[0];
                return string;
            }
            String string = adapterId;
            return string;
        }
    }

    public String getTransferId(long messageDataId) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Object[] adapterAndTransferId = entityManager.createQuery("SELECT adapterId, transferId FROM Message WHERE id = :id", Object[].class).setParameter("id", (Object)messageDataId).getResultStream().findFirst().orElse(null);
            if (Objects.nonNull(adapterAndTransferId)) {
                String adapterId = (String)adapterAndTransferId[0];
                String transferId = (String)adapterAndTransferId[1];
                if (StringUtils.isNotEmpty((CharSequence)transferId)) {
                    String string = transferId;
                    return string;
                }
                if (Objects.nonNull(adapterId) && adapterId.contains(SEPARATOR)) {
                    String string = adapterId.split(SEPARATOR)[1];
                    return string;
                }
            }
            String string = null;
            return string;
        }
    }

    public int registerOrUpdateMessage(XpMessage xpMessage) throws DbException {
        int messageStatus;
        String messageId = xpMessage.getMessageId();
        try {
            this.registerMessage(xpMessage);
            _log.info(" [{}] registered new message {}", (Object)xpMessage.getDatabaseId(), (Object)messageId);
            messageStatus = 0;
        }
        catch (MessageExistsException e) {
            messageStatus = this.getStatusOfMessage(messageId, 1);
        }
        if (messageStatus != 0) {
            int direction = xpMessage.isInbound() ? 1 : 0;
            long databaseId = this.getMessageDataID(messageId, direction);
            xpMessage.setDatabaseId(databaseId);
            if (messageStatus == 4) {
                _log.info(" [{}] updating existing failed message {}", (Object)xpMessage.getDatabaseId(), (Object)messageId);
                boolean updated = this.updateMessageStatus(databaseId, 4, 1);
                if (!updated) {
                    messageStatus = this.getStatusOfMessage(messageId, 1);
                } else {
                    this.updateRegistrationTime(xpMessage);
                }
            }
        }
        return messageStatus;
    }

    private void updateRegistrationTime(XpMessage xpMessage) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Message message = (Message)entityManager.find(Message.class, (Object)xpMessage.getDatabaseId());
            Date registrationTime = this.referenceDateTask.getReferenceDate();
            xpMessage.setRegistrationTimestamp(registrationTime);
            message.setMessageTime(registrationTime.getTime());
            entityManager.merge((Object)message);
            entityManager.getTransaction().commit();
        }
    }

    public void registerMessage(XpMessage xpMessage) throws DbException {
        this.registerMessage(xpMessage, 1);
    }

    public void registerMessage(XpMessage xpMessage, int initStatus) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            int direction;
            Message parent;
            Message message = new Message();
            if (xpMessage.getConversationId() != null && xpMessage.getConversationDatabaseId() == -1L) {
                this.sequenceConversion(xpMessage, entityManager, message);
            }
            entityManager.getTransaction().begin();
            message.setMessageId(xpMessage.getMessageId());
            message.setTransferId(xpMessage.getTransferId());
            message.setDestinationUrl(xpMessage.getDestinationUrl());
            message.setFolder(this._folders.convertFolderToString(xpMessage.getCurrentContentReferenceFolder()));
            message.setContentReferenceFile(Objects.isNull(xpMessage.getCurrentContentReference()) ? null : xpMessage.getCurrentContentReference().getName());
            message.setContentType(xpMessage.getCurrentContentType());
            Date registrationTime = this.referenceDateTask.getReferenceDate();
            xpMessage.setRegistrationTimestamp(registrationTime);
            message.setMessageTime(registrationTime.getTime());
            if (xpMessage.getMessageTimestamp() != null) {
                message.setCreationTime(xpMessage.getMessageTimestamp().getTime());
            }
            message.setInbound(xpMessage.isInbound() ? 1 : 0);
            if (xpMessage.getMessageType() == null) {
                message.setMessageType(UNKNOWN);
            } else {
                message.setMessageType(xpMessage.getMessageType());
            }
            if (xpMessage.getMessageVersion() == null) {
                message.setSchemaVersion(UNKNOWN);
            } else {
                message.setSchemaVersion(xpMessage.getMessageVersion());
            }
            if (xpMessage.getSchemaSet() == null) {
                message.setSchemaSet(UNKNOWN);
            } else {
                message.setSchemaSet(xpMessage.getSchemaSet());
            }
            message.setSchemaLocation(xpMessage.getSchemaLocation());
            message.setSchemaNamespace(xpMessage.getSchemaNamespace());
            message.setProtocol(xpMessage.getProtocol());
            message.setReceiverId(this.getReceiverId(xpMessage));
            message.setSenderId(this.getSenderId(xpMessage));
            message.setArchiveStatus(0);
            String referenceId = xpMessage.getReferenceId();
            if (referenceId != null && (parent = this.getMessage(entityManager, referenceId, direction = "StatusRequest".equals(xpMessage.getMessageType()) ? message.getInbound() : (xpMessage.isInbound() ? 0 : 1))) != null) {
                message.setParent(parent);
                xpMessage.setReferenceDatabaseId(message.getParent().getId());
            }
            message.setTestflag(xpMessage.isTestMessage() ? 1 : 0);
            message.setStatus(initStatus);
            String logInfo = xpMessage.getProcessingDirective("LogInfo");
            if (StringUtils.isNotBlank((CharSequence)logInfo)) {
                message.setLoginfo(this.abbreviateLogInfo(logInfo));
            }
            message.setAckRequested(xpMessage.isAckRequested());
            message.setAckReceived(0);
            message.setAdapterId(xpMessage.getAdapterId());
            message.setTransferId(xpMessage.getTransferId());
            message.setMessengerId(xpMessage.getMessengerId());
            message.setTtl(xpMessage.getTimeToLive() == null ? -1L : xpMessage.getTimeToLive().getTime());
            message.setPackagingId(xpMessage.getMessagePackaging());
            message.setSignedAckRequested(xpMessage.isSignedAckRequested() ? 1 : 0);
            entityManager.persist((Object)message);
            entityManager.getTransaction().commit();
            xpMessage.setDatabaseId(message.getId());
            if (Objects.nonNull(message.getConversation())) {
                xpMessage.setConversationDatabaseId(message.getConversation().getId());
            }
            MessageDAO.putDbIdToThreadContext(message.getId());
        }
        catch (Throwable e) {
            if (this.isConstraintViolationException(e)) {
                throw new MessageExistsException("Message with id " + xpMessage.getMessageId() + " already exists", e);
            }
            throw new DbException(13036, "could not save message data to database:" + e.getMessage(), e);
        }
    }

    private String abbreviateLogInfo(String logInfo) {
        return StringUtils.abbreviate((String)logInfo, (int)this.MAX_LOGINFO_SIZE_128);
    }

    private void sequenceConversion(XpMessage xpMessage, EntityManager entityManager, Message message) {
        String conversationId = xpMessage.getConversationId();
        if (conversationId != null && !conversationId.trim().isEmpty()) {
            Conversation conversation = this._conversationDAO.getConversationData(conversationId, entityManager);
            if (conversation == null) {
                conversation = new Conversation(conversationId);
                try {
                    entityManager.getTransaction().begin();
                    entityManager.persist((Object)conversation);
                    entityManager.getTransaction().commit();
                }
                catch (PersistenceException e) {
                    entityManager.getTransaction().rollback();
                    conversation = this._conversationDAO.getConversationData(conversationId, entityManager);
                }
            }
            message.setConversation(conversation);
            long internalSequenceNumber = -1L;
            if (xpMessage.isInbound() && xpMessage.getSequenceNumber() != -1) {
                internalSequenceNumber = (long)xpMessage.getSequenceNumber() + conversation.getSequenceOffset();
                xpMessage.setInternalSequenceNumber(internalSequenceNumber);
            } else if (!xpMessage.isInbound() && xpMessage.getInternalSequenceNumber() != -1L) {
                internalSequenceNumber = xpMessage.getInternalSequenceNumber();
                xpMessage.setSequenceNumber((int)(internalSequenceNumber - conversation.getSequenceOutboundOffset()));
            }
            message.setSequenceNumber(internalSequenceNumber);
            if (xpMessage.isSequenceReset() && xpMessage.getInternalSequenceNumber() > 0L && !xpMessage.isInbound()) {
                conversation.setSequenceOutboundOffset(xpMessage.getInternalSequenceNumber() + 1L);
            }
        }
    }

    private String getSenderId(XpMessage xpMessage) {
        String sender = xpMessage.getSenderLocalId();
        if (Objects.isNull(sender)) {
            sender = xpMessage.getSenderInternalId();
        }
        if (Objects.nonNull(sender) && sender.length() > 30) {
            sender = sender.substring(0, 30);
        }
        return sender;
    }

    private String getReceiverId(XpMessage xpMessage) {
        String receiver = xpMessage.getReceiverLocalId();
        if (Objects.isNull(receiver)) {
            receiver = xpMessage.getReceiverInternalId();
        }
        if (Objects.nonNull(receiver) && receiver.length() > 30) {
            receiver = receiver.substring(0, 30);
        }
        return receiver;
    }

    public void updateMessage(XpMessage xpMessage) throws DbException {
        this.updateMessageAndStatus(xpMessage, -1);
    }

    private Message getParentMessage(XpMessage xpMessage, EntityManager entityManager) throws DbException {
        long parentMessageDatabaseId = -1L;
        if (xpMessage.getReferenceId() != null) {
            if (xpMessage.getReferenceDatabaseId() != -1L) {
                return this.getMessage(entityManager, xpMessage.getReferenceDatabaseId());
            }
            return this.getMessage(entityManager, xpMessage.getReferenceId(), xpMessage.isInbound() ? 1 : 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageDataID(String messageId) {
        long l;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long messageDbId = -1L;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_GET_MESSAGE_DATA_ID);
            stmt.setString(1, messageId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                messageDbId = rs.getLong(1);
                if (rs.getInt(2) != 0) continue;
            }
            MessageDAO.putDbIdToThreadContext(messageDbId);
            l = messageDbId;
        }
        catch (Exception e) {
            long l2;
            try {
                _log.error("Could not get message data id for the message :{} : {}", (Object)messageId, (Object)e.toString());
                l2 = messageDbId;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeResultSet(rs);
            this.closeStatement(stmt);
            this.closeConnection(conn);
            return l2;
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReferenceMessageDataID(String referenceMessageId, int direction) {
        long l;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long result = -1L;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_GET_MESSAGE_DATA_ID_INBOUND);
            stmt.setString(1, referenceMessageId);
            stmt.setInt(2, direction);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
            l = result;
            this.closeResultSet(rs);
        }
        catch (Exception e) {
            _log.error("Could not get message data id for the message {} and direction {}: {}", (Object)referenceMessageId, (Object)direction, (Object)e.toString());
            long l2 = result;
            return l2;
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(stmt);
            this.closeConnection(conn);
        }
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return l;
    }

    public long getMessageDataID(String messageId, int direction) {
        long messageDbId = this.getReferenceMessageDataID(messageId, direction);
        MessageDAO.putDbIdToThreadContext(messageDbId);
        return messageDbId;
    }

    public void updateMessageAndStatus(XpMessage xpMessage, int status) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery(status == -1 ? SQL_UPDATE_MESSAGE : SQL_UPDATE_MESSAGE_AND_STATUS);
            q.setParameter("messageId", (Object)xpMessage.getMessageId());
            q.setParameter("messageType", (Object)(xpMessage.getMessageType() == null ? UNKNOWN : xpMessage.getMessageType()));
            q.setParameter("schemaVersion", (Object)(xpMessage.getMessageVersion() == null ? UNKNOWN : xpMessage.getMessageVersion()));
            q.setParameter("schemaSet", (Object)(xpMessage.getSchemaSet() == null ? UNKNOWN : xpMessage.getSchemaSet()));
            q.setParameter("protocol", (Object)xpMessage.getProtocol());
            q.setParameter("parent", (Object)this.getParentMessage(xpMessage, entityManager));
            q.setParameter("receiverId", (Object)this.getReceiverId(xpMessage));
            q.setParameter("senderId", (Object)this.getSenderId(xpMessage));
            q.setParameter("loginfo", (Object)this.abbreviateLogInfo(xpMessage.getProcessingDirective("LogInfo")));
            q.setParameter("creationTime", xpMessage.getMessageTimestamp() == null ? null : Long.valueOf(xpMessage.getMessageTimestamp().getTime()));
            q.setParameter("messengerId", (Object)xpMessage.getMessengerId());
            if (status != -1) {
                q.setParameter("status", (Object)status);
            }
            q.setParameter("id", (Object)xpMessage.getDatabaseId());
            q.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (DbException | RuntimeException e) {
            throw new DbException(13037, "could not update message data (messageDataId=" + xpMessage.getDatabaseId() + ") to database:" + e.getMessage(), e);
        }
    }

    public boolean updateMessageAndStatus(XpMessage xpMessage, int oldStatus, int newStatus) throws DbException {
        boolean bl;
        block9: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                Query q = entityManager.createQuery(" UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message\n SET messageId=:messageId, messageType=:messageType, schemaVersion=:schemaVersion, schemaSet=:schemaSet, protocol=:protocol, parent=:parent,\n     receiverId=:receiverId, senderId=:senderId, loginfo=:loginfo, creationTime=:creationTime, messengerId=:messengerId, status=:newStatus\n WHERE ID=:id AND status=:oldStatus\n");
                q.setParameter("messageId", (Object)xpMessage.getMessageId());
                q.setParameter("messageType", (Object)(xpMessage.getMessageType() == null ? UNKNOWN : xpMessage.getMessageType()));
                q.setParameter("schemaVersion", (Object)(xpMessage.getMessageVersion() == null ? UNKNOWN : xpMessage.getMessageVersion()));
                q.setParameter("schemaSet", (Object)(xpMessage.getSchemaSet() == null ? UNKNOWN : xpMessage.getSchemaSet()));
                q.setParameter("protocol", (Object)xpMessage.getProtocol());
                q.setParameter("parent", (Object)this.getParentMessage(xpMessage, entityManager));
                q.setParameter("receiverId", (Object)this.getReceiverId(xpMessage));
                q.setParameter("senderId", (Object)this.getSenderId(xpMessage));
                q.setParameter("loginfo", (Object)this.abbreviateLogInfo(xpMessage.getProcessingDirective("LogInfo")));
                q.setParameter("creationTime", xpMessage.getMessageTimestamp() == null ? null : Long.valueOf(xpMessage.getMessageTimestamp().getTime()));
                q.setParameter("messengerId", (Object)xpMessage.getMessengerId());
                q.setParameter("newStatus", (Object)newStatus);
                q.setParameter("id", (Object)xpMessage.getDatabaseId());
                q.setParameter("oldStatus", (Object)oldStatus);
                int result = q.executeUpdate();
                entityManager.getTransaction().commit();
                boolean bl2 = bl = result > 0;
                if (entityManager == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (this.isConstraintViolationException(e)) {
                        return false;
                    }
                    throw new DbException(13037, "could not update message data (messageDataId=" + xpMessage.getDatabaseId() + ") to database:" + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public int getStatusOfMessage(String messageId, int direction) throws DbException {
        int result = 0;
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, messageId, direction);
            if (message != null) {
                result = message.getStatus();
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13052, "Could not get the status for the message: " + messageId + ": " + String.valueOf(e));
        }
        return result;
    }

    public void updateMessageAdapterId(long messageDataId, String adapterId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Message message = this.getMessage(entityManager, messageDataId);
            if (message != null) {
                message.setAdapterId(adapterId);
                entityManager.merge((Object)message);
            } else {
                _log.error("Could not find message " + messageDataId + " to set adapterId " + adapterId);
            }
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            _log.error("Could not set the adapterId " + adapterId + " to message " + messageDataId + ": " + String.valueOf(e));
        }
    }

    public long getSeqOfLastOKMSG(long conversationDataId) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long result = -1L;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_SEQ_OF_LAST_OK_MSG);
            stmt.setLong(1, conversationDataId);
            stmt.setInt(2, 1);
            stmt.setInt(3, 3);
            stmt.setMaxRows(1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13057, "Could not get next sequence number for conversation id: " + conversationDataId + ": " + String.valueOf(e));
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    public long getNumberOfPredecessors(long convDataId, long sequenceNumber) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long result = -1L;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_NUMBER_OF_PREDECESSORS);
            stmt.setLong(1, convDataId);
            stmt.setLong(2, sequenceNumber);
            stmt.setInt(3, 1);
            stmt.setInt(4, 2);
            stmt.setInt(5, 3);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13058, "Could not get number of predecessors for conversation id '" + convDataId + "' and sequence number '" + sequenceNumber + "': " + String.valueOf(e));
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    public boolean hasFirstMSG(long conversationDatabaseId, long databaseId) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_FIRST_MSG);
            stmt.setLong(1, conversationDatabaseId);
            stmt.setLong(2, 0L);
            stmt.setLong(3, databaseId);
            stmt.setInt(4, 1);
            stmt.setMaxRows(1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = false;
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13062, new String[]{String.valueOf(conversationDatabaseId)}, "Could not check, whether messages with conversation id '" + conversationDatabaseId + "' are already saved in the database. Reason: " + String.valueOf(e));
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    public long getMaxSequence(long conversationDatabaseId, long databaseId) throws DbException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long result = -1L;
        try {
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_MAX_SEQUENCE);
            stmt.setLong(1, conversationDatabaseId);
            stmt.setLong(2, databaseId);
            stmt.setInt(3, 1);
            stmt.setMaxRows(1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13059, "Could not get max. sequence number for conversation id '" + conversationDatabaseId + "': " + String.valueOf(e));
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    public void updateSequenceNumber(long databaseId, long sequence) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery(SQL_UPDATE_SEQUENCE_NUMBER);
            q.setParameter("sequence", (Object)sequence);
            q.setParameter("id", (Object)databaseId);
            int result = q.executeUpdate();
            entityManager.getTransaction().commit();
            _log.debug("sequenceNumber od db id {} updated. {} rows changed", (Object)databaseId, (Object)result);
        }
        catch (RuntimeException e) {
            _log.error("Could not update message sequence in DB:{}", (Object)e.toString());
            throw new DbException(13060, "Could not update message sequence number for messageId " + databaseId + ": " + e.getMessage(), e);
        }
    }

    public boolean isSequenceDuplicated(long databaseId, long sequenceNumber, long conversationDatabaseId, int direction) throws DbException {
        if (sequenceNumber == -1L) {
            return false;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            int numberOfDuplicates;
            conn = ConnectionPool.getDataSource().getConnection();
            stmt = conn.prepareStatement(SQL_SELECT_NUMBER_OF_SEQUENCE_DUPLICATES);
            stmt.setLong(1, databaseId);
            stmt.setLong(2, conversationDatabaseId);
            stmt.setLong(3, sequenceNumber);
            stmt.setInt(4, direction);
            stmt.setInt(5, 4);
            rs = stmt.executeQuery();
            if (rs.next() && (numberOfDuplicates = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new DbException(13061, "Could not check for duplicates of sequence number '" + sequenceNumber + "' for conversation id '" + conversationDatabaseId + "': " + String.valueOf(e));
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        this.closeConnection(conn);
        return result;
    }

    private boolean updateMessageStatus(long messageDataId, int oldStatus, int newStatus, EntityManager entityManager) throws DbException {
        try {
            entityManager.getTransaction().begin();
            String selectAndLockSql = switch (this.getDatabaseType()) {
                case DatabaseType.ORACLE, DatabaseType.POSTGRESQL, DatabaseType.MYSQL -> "SELECT ID\nFROM MESSAGE\nWHERE ID = ? AND STATUS = ?\nFOR UPDATE SKIP LOCKED\n";
                case DatabaseType.MSSQL -> "SELECT ID\nFROM MESSAGE WITH (UPDLOCK, READPAST)\nWHERE ID = ? AND STATUS = ?\n";
                default -> "SELECT ID\nFROM MESSAGE\nWHERE ID = ? AND STATUS = ?\nFOR UPDATE\n";
            };
            List messageIds = entityManager.createNativeQuery(selectAndLockSql, Long.class).setParameter(1, (Object)messageDataId).setParameter(2, (Object)oldStatus).getResultList();
            if (messageIds.isEmpty() || messageIds.getFirst() == null) {
                entityManager.getTransaction().rollback();
                _log.debug("The message status {} of the message {} was already changed.", (Object)oldStatus, (Object)messageDataId);
                return false;
            }
            int updateCount = entityManager.createQuery("UPDATE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message\nSET status=:newStatus\nWHERE ID=:id AND status=:oldStatus\n").setParameter("newStatus", (Object)newStatus).setParameter("id", (Object)messageDataId).setParameter("oldStatus", (Object)oldStatus).executeUpdate();
            if (updateCount == 0) {
                entityManager.getTransaction().rollback();
                _log.debug("The message status {} of the message {} was already changed.", (Object)oldStatus, (Object)messageDataId);
                return false;
            }
            entityManager.getTransaction().commit();
            return true;
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            throw new DbException(-1, "could not update message status (messageDataId=" + messageDataId + ") to database:" + e.getMessage(), e);
        }
    }

    public boolean updateMessageStatus(long messageDataId, int status, EntityManager entityManager) throws SQLException {
        try {
            entityManager.getTransaction().begin();
            int result = this.updateMessageStatusInSameTransaction(messageDataId, status, entityManager);
            entityManager.getTransaction().commit();
            return result > 0;
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            throw new SQLException("could not update message status (messageDataId=" + messageDataId + ") to database:" + e.getMessage(), e);
        }
    }

    public int updateMessageStatusInSameTransaction(long messageDataId, int status, EntityManager entityManager) {
        Query q = entityManager.createQuery(SQL_UPDATE_MESSAGE_STATUS);
        q.setParameter("status", (Object)status);
        q.setParameter("id", (Object)messageDataId);
        int result = q.executeUpdate();
        return result;
    }

    public boolean updateArchiveStatus(long messageDataId, int archiveStatus) {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int updateCount = entityManager.createQuery(SQL_UPDATE_ARCHIVE_STATUS).setParameter("archiveStatus", (Object)archiveStatus).setParameter("id", (Object)messageDataId).executeUpdate();
                entityManager.getTransaction().commit();
                boolean bl2 = bl = updateCount == 1;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    _log.error("could not update archive status of message ({}) to {} in database due to a {}", (Object)messageDataId, (Object)archiveStatus, (Object)e);
                    return false;
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public void updateMessageStatus(long messageDataId, String messageId, int status) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            this.updateMessageStatus(messageDataId, status, entityManager);
        }
        catch (Exception e) {
            _log.error("Could not update status of message [{}] / mid:{} in DB due to {}: {}", (Object)messageDataId, (Object)messageId, (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    public boolean updateMessageStatus(long messageDataId, int oldStatus, int newStatus) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            boolean bl = this.updateMessageStatus(messageDataId, oldStatus, newStatus, entityManager);
            return bl;
        }
    }

    public void updatePackagingId(long messageDataId, String packagingId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery(SQL_UPDATE_PACKAGING_ID);
            q.setParameter("packagingId", (Object)packagingId);
            q.setParameter("id", (Object)messageDataId);
            q.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            _log.error("Could not update packaging id of messageId {} in DB: {}", (Object)messageDataId, (Object)e.getMessage(), (Object)e);
        }
    }

    public void updateMessageTimeStamp(long messageDataId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery(SQL_UPDATE_MESSAGE_TIMESTAMP);
            q.setParameter("messageTime", (Object)this.referenceDateTask.getReferenceCurrentTimeMillis());
            q.setParameter("id", (Object)messageDataId);
            q.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            _log.error("Could not update message time of messageId " + messageDataId + " in DB: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getMessageTime(long messageDataId) {
        Date result;
        block6: {
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            result = null;
            try {
                conn = ConnectionPool.getDataSource().getConnection();
                stmt = conn.prepareStatement(SQL_GET_MESSAGE_TIMESTAMP);
                stmt.setLong(1, messageDataId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    result = new Date(rs.getLong(1));
                }
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                _log.error("Could not get message time from DB: " + String.valueOf(e));
                break block6;
            }
            finally {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeConnection(conn);
            }
            this.closeStatement(stmt);
            this.closeConnection(conn);
        }
        return result;
    }

    public void setAckReceived(long messageDataId) {
        this.setAckReceived(messageDataId, 1);
    }

    public void removeAckReceived(long messageDataId) {
        this.setAckReceived(messageDataId, 0);
    }

    private void setAckReceived(long messageDataId, int ackReceived) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery(SQL_UPDATE_MESSAGE_ACK);
            q.setParameter("ackReceived", (Object)ackReceived);
            q.setParameter("id", (Object)messageDataId);
            q.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            _log.error("Could not update ack received flag of messageId {} in DB: {}", (Object)messageDataId, (Object)e.getMessage(), (Object)e);
        }
    }

    public List<Long> setInProcessMessagesToFailed() throws DbException {
        ArrayList<Long> interruptedMessages = new ArrayList<Long>();
        try (EntityManager entityManager = this.createNewEntityManager();){
            List messages;
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(Message.class);
            Root messageRoot = criteriaQuery.from(Message.class);
            criteriaQuery.select((Selection)messageRoot);
            long oneMonth = 2592000000L;
            criteriaQuery.where((Expression)cb.and((Expression)cb.or((Expression)cb.equal((Expression)messageRoot.get("status"), (Object)1), (Expression)cb.equal((Expression)messageRoot.get("status"), (Object)0)), (Expression)cb.greaterThan((Expression)messageRoot.get("messageTime"), (Comparable)Long.valueOf(System.currentTimeMillis() - 2592000000L))));
            do {
                messages = entityManager.createQuery(criteriaQuery).setMaxResults(200).getResultList();
                messages.forEach(message -> {
                    try {
                        this.updateMessageStatus((long)message.getId(), 4, entityManager);
                        _log.debug("[{}] Message '{}' has status 'in process' which is set to 'failed'.", (Object)message.getId(), (Object)message.getMessageId());
                        interruptedMessages.add(message.getId());
                    }
                    catch (SQLException e) {
                        _log.error("Could not set message status of message '{}' to 'failed': {}", (Object)message.getId(), (Object)e.toString());
                    }
                    entityManager.detach(message);
                });
                entityManager.clear();
            } while (!messages.isEmpty());
        }
        catch (RuntimeException e) {
            _log.error("Could not set message status to failed: {}", (Object)e.getMessage(), (Object)e);
            throw new DbException(13053, "Could not set message status to failed: " + e.getMessage(), e);
        }
        return interruptedMessages;
    }

    public Message dbConsistencyCheck() throws DbException {
        Message message;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                Conversation conversation = this._conversationDAO.getConversationData("CID-1234567890123456789@ponton-consulting.de", entityManager);
                Message message2 = new Message();
                message2.setMessageId(TEST_VALUE_MESSAGE_ID);
                message2.setFolder(TEST_VALUE_FOLDER);
                message2.setCreationTime(12345678901234567L);
                message2.setInbound(1);
                message2.setConversation(conversation);
                message2.setMessageType(TEST_VALUE_MESSAGE_TYPE);
                message2.setSchemaVersion(TEST_VALUE_SCHEMA_VERSION);
                message2.setSchemaSet(TEST_VALUE_SCHEMA_SET);
                message2.setProtocol(TEST_VALUE_PROTOCOL);
                message2.setReceiverId(TEST_VALUE_RECEIVER_ID);
                message2.setSenderId(TEST_VALUE_SENDER_ID);
                message2.setMessageTime(12345678901234567L);
                message2.setTestflag(0);
                message2.setStatus(5);
                message2.setAckReceived(0);
                message2.setAdapterId("DBTestAdapter");
                message2.setMessengerId(99);
                message2.setTtl(-1L);
                entityManager.persist((Object)message2);
                entityManager.getTransaction().commit();
                message = message2;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13030, "DB Consistency check for table 'MESSAGE' failed. Reason: " + String.valueOf(e));
                }
            }
            entityManager.close();
        }
        return message;
    }

    public void dbCleanup(long testMessageDatabaseId) throws DbException {
        this.deleteFromMessage(testMessageDatabaseId);
    }

    public int deleteFromMessage(long messageDataId) throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int i = this.deleteFromMessage(messageDataId, entityManager);
                entityManager.getTransaction().commit();
                n = i;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13033, "Could not delete message: " + messageDataId + ": " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return n;
    }

    public int deleteFromMessage(long messageDataId, EntityManager entityManager) throws DbException {
        int result = 0;
        try {
            result = entityManager.createQuery(QUERY_DELETE_MESSAGE_BY_ID).setParameter("id", (Object)messageDataId).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13033, "Could not delete message: " + messageDataId + ": " + e.getMessage(), e);
        }
        return result;
    }

    public int deleteByIds(Collection<Long> messageDataIds, EntityManager entityManager) throws DbException {
        int result = 0;
        try {
            result = entityManager.createQuery(QUERY_DELETE_MESSAGE_BY_IDS).setParameter("ids", messageDataIds).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13033, "Could not delete message by IDs: " + e.getMessage(), e);
        }
        return result;
    }

    public List<Long> init() throws DbException {
        _log.info("searching for messages with invalid state");
        List<Long> result = this.setInProcessMessagesToFailed();
        if (!result.isEmpty()) {
            _log.info("Found {} messages which are marked as in process. Status was set to failed.", (Object)result.size());
        } else {
            _log.info("No 'in process' messages found.");
        }
        return result;
    }

    public void updateSequenceInfo(XpMessage xpMessage) throws DbException {
        if (xpMessage.getSequenceNumber() == -1) {
            return;
        }
        this.updateOrCreateConversation(xpMessage);
    }

    public void updateOrCreateConversation(XpMessage xpMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Message message = this.getMessage(entityManager, xpMessage.getDatabaseId());
            if (message != null) {
                this.sequenceConversion(xpMessage, entityManager, message);
                xpMessage.setConversationDatabaseId(message.getConversation().getId());
            }
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get Message reference from Database: " + e.getMessage(), e);
        }
    }

    public static void putDbIdToThreadContext(long messageDbId) {
        ThreadContext.put((String)"dbId", (String)" #%d#".formatted(messageDbId));
    }

    public static void removeDbIdFromThreadContext() {
        ThreadContext.remove((String)"dbId");
    }

    public XpDatabaseMessage loadXpDatabaseMessage(long messageDbId) throws DbException {
        XpDatabaseMessage xpDatabaseMessage;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                xpDatabaseMessage = (XpDatabaseMessage)entityManager.find(XpDatabaseMessage.class, (Object)messageDbId);
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13039, "Could not get XpDatabaseMessage (" + messageDbId + ") from Database:" + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return xpDatabaseMessage;
    }

    public XpInboundMessage loadXpInboundMessage(long messageDbId) throws DbException {
        XpInboundMessage xpInboundMessage;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                XpInboundMessage xpInboundMessage2 = (XpInboundMessage)entityManager.find(XpInboundMessage.class, (Object)messageDbId);
                this.loadAndSetTransientIds(xpInboundMessage2, entityManager);
                xpInboundMessage = xpInboundMessage2;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13039, "Could not get XpInboundMessage (" + messageDbId + ") from Database:" + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return xpInboundMessage;
    }

    public XpOutboundMessage loadXpOutboundMessage(long messageDbId) throws DbException {
        XpOutboundMessage xpOutboundMessage;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                XpOutboundMessage xpOutboundMessage2 = (XpOutboundMessage)entityManager.find(XpOutboundMessage.class, (Object)messageDbId);
                this.loadAndSetTransientIds(xpOutboundMessage2, entityManager);
                xpOutboundMessage = xpOutboundMessage2;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13039, "Could not get XpOutboundMessage (" + messageDbId + ") from Database:" + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return xpOutboundMessage;
    }

    public XpBaseMessage saveXpMessage(XpMessage xpMessage) throws DbException {
        XpBaseMessage xpBaseMessage;
        block10: {
            if (xpMessage.getDatabaseId() == -1L) {
                _log.warn("XPMessage must be registered before saving it to the database.");
                this.registerMessage(xpMessage);
            }
            XpBaseMessage xpBaseMessage2 = xpMessage.isInbound() ? new XpInboundMessage(xpMessage) : new XpOutboundMessage(xpMessage);
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                if (!xpBaseMessage2.getAttachments().isEmpty()) {
                    entityManager.createQuery("DELETE FROM FileRef WHERE messageId = :messageId AND fileType IN (:attachmentType, :signatureType)").setParameter("messageId", (Object)xpBaseMessage2.getDatabaseId()).setParameter("attachmentType", (Object)FileType.ATTACHMENT.getDbValue()).setParameter("signatureType", (Object)FileType.SIGNATURE.getDbValue()).executeUpdate();
                }
                entityManager.merge((Object)xpBaseMessage2);
                entityManager.getTransaction().commit();
                xpBaseMessage = xpBaseMessage2;
                if (entityManager == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13040, "Could not save XpMessage (" + xpMessage.getDatabaseId() + ") to Database:" + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return xpBaseMessage;
    }

    private void loadAndSetTransientIds(XpBaseMessage xpBaseMessage, EntityManager entityManager) {
        if (Objects.isNull(xpBaseMessage)) {
            return;
        }
        xpBaseMessage.setReceiverInternalId(this.loadInternalPartnerId(xpBaseMessage.getReceiverLocalId(), entityManager));
        xpBaseMessage.setSenderInternalId(this.loadInternalPartnerId(xpBaseMessage.getSenderLocalId(), entityManager));
        xpBaseMessage.setConversationId(this.loadConversationId(xpBaseMessage.getConversationDatabaseId(), entityManager));
        if (xpBaseMessage instanceof XpInboundMessage) {
            XpInboundMessage xpInboundMessage = (XpInboundMessage)xpBaseMessage;
            xpInboundMessage.setReferenceId(this.loadReferenceMessageId(xpInboundMessage.getReferenceDatabaseId(), entityManager));
        }
    }

    private String loadInternalPartnerId(String localId, EntityManager entityManager) {
        return StringUtils.isBlank((CharSequence)localId) ? null : (String)entityManager.createQuery("FROM BackendPartnerId where partnerId = :partnerId", BackendPartnerId.class).setParameter("partnerId", (Object)localId).getResultStream().findFirst().map(BackendPartnerId::getBackendPartnerId).orElse(null);
    }

    private String loadReferenceMessageId(Long referenceId, EntityManager entityManager) {
        return Objects.isNull(referenceId) || referenceId < 0L ? null : (String)entityManager.createQuery("FROM MessageReference where id = :id", MessageReference.class).setParameter("id", (Object)referenceId).getResultStream().findFirst().map(MessageReference::getMessageId).orElse(null);
    }

    private String loadConversationId(Long conversationDbId, EntityManager entityManager) {
        return Objects.isNull(conversationDbId) || conversationDbId < 0L ? "" : entityManager.createQuery("FROM ConversationReference where id = :id", ConversationReference.class).setParameter("id", (Object)conversationDbId).getResultStream().findFirst().map(ConversationReference::getConversationId).orElse("");
    }

    public void updateMessageFolder(long messageDataId, File folder) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("UPDATE Message SET folder = :folder WHERE id = :id").setParameter("folder", (Object)this._folders.convertFolderToString(folder)).setParameter("id", (Object)messageDataId).executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            _log.error("could not update message folder of message {} in database:{}", (Object)messageDataId, (Object)e.getMessage(), (Object)e);
        }
    }
}

