/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BlockInputStream;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.hibernate.Session;

public class MessageArchiveDataDAO
extends BaseDAO {
    private static final long MAX_MESSAGE_SIZE = 0x400000L;

    public MessageArchiveDataDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public String storeMessageArchiveData(InputStream data, long messageTime) throws DbException {
        String string;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                String result = (String)((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                    String id = UUID.randomUUID().toString();
                    int index = 0;
                    try (BlockInputStream blockInputStream = new BlockInputStream(data, 0x400000L);){
                        while (blockInputStream.hasNext()) {
                            PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO MESSAGE_ARCHIVE_DATA (ID, PART ,DATA, MESSAGE_TIME) VALUES (?, ?, ?, ?)");
                            try {
                                insertStatement.setString(1, id);
                                insertStatement.setInt(2, index);
                                insertStatement.setBinaryStream(3, blockInputStream);
                                insertStatement.setLong(4, messageTime);
                                insertStatement.executeUpdate();
                                ++index;
                            }
                            finally {
                                if (insertStatement == null) continue;
                                insertStatement.close();
                            }
                        }
                        return id;
                    }
                    catch (IOException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                });
                entityManager.getTransaction().commit();
                string = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DbException(13022, "Can't archive file " + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return string;
    }

    public void readMessageArchiveFromDB(String id, OutputStream outputStream) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            ((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                boolean isAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                String dbProductName = connection.getMetaData().getDatabaseProductName();
                _log.trace("DB Product Name {}", (Object)dbProductName);
                boolean isMySQL = dbProductName.toLowerCase().contains("mysql");
                try (PreparedStatement selectStatement = connection.prepareStatement("SELECT DATA FROM MESSAGE_ARCHIVE_DATA WHERE ID = ? ORDER BY PART ASC", 1003, 1007);){
                    selectStatement.setString(1, id);
                    selectStatement.setFetchSize(isMySQL ? Integer.MIN_VALUE : 1);
                    try (ResultSet resultSet = selectStatement.executeQuery();){
                        boolean found = false;
                        while (resultSet.next()) {
                            found = true;
                            try {
                                InputStream inputStream = resultSet.getBinaryStream("DATA");
                                try {
                                    int bytesRead;
                                    byte[] buffer = new byte[8192];
                                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                                        outputStream.write(buffer, 0, bytesRead);
                                    }
                                    outputStream.flush();
                                }
                                finally {
                                    if (inputStream == null) continue;
                                    inputStream.close();
                                }
                            }
                            catch (IOException e) {
                                throw new PersistenceException("Cannot read file from archive from DB for id " + id, (Throwable)e);
                            }
                        }
                        if (!found) {
                            throw new PersistenceException("No data found for id " + id);
                        }
                    }
                }
                catch (SQLException e) {
                    throw new PersistenceException("Cannot read file from archive from DB for id " + id, (Throwable)e);
                }
                finally {
                    connection.setAutoCommit(isAutoCommit);
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new DbException(13022, "Cannot read file from archive from DB for id " + id, e);
        }
    }

    public void deleteMessageArchiveDataById(String id) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            ((Session)entityManager.unwrap(Session.class)).doReturningWork(connection -> {
                try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM MESSAGE_ARCHIVE_DATA WHERE ID = ?");){
                    deleteStatement.setString(1, id);
                    deleteStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
                return true;
            });
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            throw new DbException(13023, "Cannot delete file from archive for id " + id, e);
        }
    }

    public int deleteMessageArchiveDataOlderThan(long timestamp) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int deletedCount = entityManager.createQuery("DELETE FROM MessageArchiveData m WHERE m.messageTime < :timestamp").setParameter("timestamp", (Object)timestamp).executeUpdate();
            entityManager.getTransaction().commit();
            int n = deletedCount;
            return n;
        }
    }
}

