/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.LogMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Objects;
import java.util.StringTokenizer;

public class LogMessageDAO
extends BaseDAO {
    public static final int LOG_MSG_SEND_TRY = 0;
    public static final int LOG_ACK_SEND_TRY = 1;
    public static final int LOG_ACK_OK_CREATED = 2;
    public static final int LOG_MSG_RULE_MATCH_FOR_ADAPTER_CHANGE = 3;
    public static final int LOG_MSG_ACK_INFO = 5;
    public static final int LOG_MSG_ADD_INBOUND_QUEUE = 6;
    public static final int LOG_ACK_ERROR_CREATED = 7;
    public static final int LOG_CHANGED_ADAPTER = 8;
    public static final int LOG_MSG_VALIDATION_DISABLED = 9;
    public static final int LOG_XML_MODIFICATION_DISABLED = 10;
    public static final int LOG_ACK_TO_ADAPTER = 59;
    public static final int LOG_MSG_RECEIVED = 60;
    public static final int LOG_MSG_VALIDATED_OK = 61;
    public static final int LOG_MSG_COMPRESSED_OK = 62;
    public static final int LOG_MSG_SIGNED_OK = 63;
    public static final int LOG_MSG_ENCRYPTED_OK = 64;
    public static final int LOG_ACK_RECEIVED = 66;
    public static final int LOG_MSG_TO_ADAPTER = 67;
    public static final int LOG_MSG_FROM_ADAPTER = 68;
    public static final int LOG_MSG_DECOMPRESSED = 69;
    public static final int LOG_MSG_DECRYPTED = 70;
    public static final int LOG_MSG_SIGNATURE_OK = 71;
    public static final int LOG_MSG_XML_SIGNATURE_VERIFIED_OK = 72;
    public static final int LOG_MSG_XML_SIGNATURE_CREATED_OK = 73;
    public static final int LOG_MSG_SEND_OK = 74;
    public static final int LOG_MSG_MESSAGE_CONTENT_MATCHED = 76;
    public static final int LOG_ACK_SEND_OK = 77;
    public static final int LOG_MSG_ARCHIVED = 78;
    public static final int LOG_MSG_PACKAGE_OK = 79;
    public static final int LOG_MSG_ACK_CONVERTED = 80;
    public static final int LOG_MSG_CUSTOM_FILTER_OK = 81;
    public static final int LOG_MSG_DELIVERYRESPONSE_FROM_ADAPTER = 82;
    public static final int LOG_MSG_SMIME_SIGNATURE_VERIFIED_OK = 83;
    public static final int LOG_MSG_SMIME_SIGNATURE_CREATED_OK = 84;
    public static final int LOG_MSG_SMIME_DECRYPTION_OK = 85;
    public static final int LOG_MSG_SMIME_ENCRYPTION_OK = 86;
    public static final int LOG_MSG_SMIME_DECOMPRESSION_OK = 87;
    public static final int LOG_MSG_SMIME_COMPRESSION_OK = 88;
    public static final int LOG_ACK_IGNORED = 89;
    public static final int LOG_MSG_XML_ENCRYPTION_ENCRYPTED_OK = 90;
    public static final int LOG_MSG_XML_ENCRYPTION_DECRYPTED_OK = 91;
    public static final int LOG_CREATED_STATUS_REQUEST_FOR_MSG = 92;
    public static final int LOG_RECEIVED_STATUS_REQUEST_FOR_MSG = 93;
    public static final int LOG_CREATED_STATUS_REQUEST = 94;
    public static final int LOG_RECEIVED_STATUS_RESPONSE = 95;
    public static final int LOG_RECEIVED_STATUS_REQUEST = 96;
    public static final int LOG_CREATED_STATUS_RESPONSE = 97;
    public static final int LOG_STATUS_RESPONSE_IGNORED = 98;
    public static final int LOG_MSG_COMPLETE = 100;
    public static final int LOG_MSG_INBOUND_COMPLETED = 101;
    public static final int LOG_MSG_OUTBOUND_COMPLETED = 102;
    public static final int LOG_ACK_INBOUND_COMPLETED = 103;
    public static final int LOG_ACK_OUTBOUND_COMPLETED = 104;
    public static final int LOG_MSG_XML_MODIFICATION = 105;
    public static final int LOG_IGNORE_DUPLICATE = 106;
    public static final int LOG_NO_VIRUS_FOUND = 107;
    public static final int LOG_MSG_ACK_CONTAINS_WARNING = 201;
    public static final int LOG_MSG_ADAPTER_NOT_CONTACTED_SINCE = 203;
    public static final int LOG_MSG_CONTENT_TRIGGER_WAS_TRUE = 204;
    public static final int LOG_MSG_CERT_INSTALLED = 205;
    public static final int LOG_INTERNAL_ACK = 206;
    public static final int LOG_MSG_CUSTOM_FILTER_WARNING = 207;
    public static final int LOG_MSG_NO_ACK_EXPECTED = 208;
    public static final int LOG_MSG_NO_REF_MESSAGE_FOUND = 209;
    public static final int LOG_NO_STATUS_RESPONSE_EXPECTED = 210;
    public static final int LOG_MESSAGE_HAS_TO_WAIT_FOR_SUCCESSFUL_DELIVERY_OF_PREVIOUS_MESSAGE = 211;
    public static final int LOG_MSG_MESSAGE_MANUALLY_DELETED_FROM_QUEUE = 212;
    public static final int LOG_VIRUS_SCANNER_COMMUNICATION_PROBLEM = 213;
    public static final int LOG_MSG_MESSAGE_RESENT = 214;
    public static final int LOG_MSG_ACK_COULD_NOT_BE_PROCESSED = 215;
    public static final int LOG_MESSAGE_REQUEUE = 216;
    public static final int LOG_MSG_INBOUND_MESSAGE_DUPLICATED = 217;
    public static final int LOG_MSG_INBOUND_MESSAGE_DUPLICATED_FROM_MESSAGE = 218;
    public static final int LOG_MSG_RECEIVE_ERROR = 500;
    public static final int LOG_MSG_SEND_ERROR = 501;
    public static final int LOG_MSG_COMPRESSION_ERROR = 502;
    public static final int LOG_MSG_DECOMPRESSION_ERROR = 503;
    public static final int LOG_MSG_SIGNATURE_ERROR = 504;
    public static final int LOG_MSG_SIGNING_ERROR = 505;
    public static final int LOG_MSG_DECRYPT_ERROR = 506;
    public static final int LOG_MSG_ENCRYPT_ERROR = 507;
    public static final int LOG_MSG_XML_VALIDATION_FAILED = 508;
    public static final int LOG_MESSAGE_FILE_NOT_FOUND = 509;
    public static final int LOG_MSG_OPEN_ERROR = 510;
    public static final int LOG_MSG_SAVE_ERROR = 511;
    public static final int LOG_MSG_ACK_PARSE_ERROR = 512;
    public static final int LOG_MSG_PARSE_ERROR = 513;
    public static final int LOG_MSG_SENT_TO_ADAPTER_ERROR = 514;
    public static final int LOG_MSG_RECEIVE_FROM_ADAPTER_ERROR = 515;
    public static final int LOG_MSG_ACK_CONTAINS_ERROR = 516;
    public static final int LOG_MSG_NOTIFICATION_CONTAINS_ERROR = 517;
    public static final int LOG_MSG_RECEIVER_URL_INVALID_ERROR = 518;
    public static final int LOG_MSG_MAX_RETRIES_ERROR = 519;
    public static final int LOG_MSG_TRANSFER_ERROR = 520;
    public static final int LOG_MSG_XML_SIGNATURE_ERROR = 521;
    public static final int LOG_MSG_PACKAGE_ERROR = 522;
    public static final int LOG_MSG_XML_VALIDATION_DETAILS = 523;
    public static final int LOG_MSG_ACK_CONVERSION_PROBLEM = 524;
    public static final int LOG_MSG_ADD_INBOUND_QUEUE_ERROR = 525;
    public static final int LOG_MSG_NOT_FOUND_ERROR = 526;
    public static final int LOG_MSG_COULD_NOT_BE_PROCESSED = 527;
    public static final int LOG_MSG_ACK_NOT_EXPECTED_ERROR = 528;
    public static final int LOG_MSG_CUSTOM_FILTER = 529;
    public static final int LOG_MSG_ADAPTER_REJECTED_MESSAGE = 530;
    public static final int LOG_MSG_MESSAGE_HAD_LOCAL_TIMEOUT = 532;
    public static final int LOG_MSG_ADAPTER_DELIVERY_TIMEOUT = 533;
    public static final int LOG_MSG_SMIME_SIGNATURE_VERIFICATION_FAILED = 534;
    public static final int LOG_MSG_SMIME_SIGNATURE_ERROR = 535;
    public static final int LOG_MSG_SMIME_DECRYPTION_ERROR = 536;
    public static final int LOG_MSG_SMIME_ENCRYPTION_ERROR = 537;
    public static final int LOG_MSG_SMIME_DECOMPRESSION_ERROR = 538;
    public static final int LOG_MSG_SMIME_COMPRESSION_ERROR = 539;
    public static final int LOG_MSG_UNEXPECTED_MESSAGE_PROCESSING_INTERRUPTION = 540;
    public static final int LOG_MSG_XML_ENCRYPTION_ENCRYPT_ERROR = 541;
    public static final int LOG_MSG_XML_ENCRYPTION_DECRYPT_ERROR = 542;
    public static final int LOG_MSG_VIRUS_DETECTED_ERROR = 543;
    public static final int LOG_MSG_CONTENT_TRIGGER_ERROR = 544;
    public static final int LOG_MSG_ARCHIVING_ERROR = 545;
    private static final String VALUE_SEPARATOR = ",";
    protected static final int TEST_VALUE_ID = 1234567890;
    private static final int TEST_VALUE_TYPE = 1;
    private static final int TEST_VALUE_BEGIN_COMPONENT = 2;
    private static final int TEST_VALUE_END_COMPONENT = 3;
    private static final String TEST_VALUE_TEXT = "my.text_1234567890";
    private static final String SQL_DELETE_LOG_MESSAGE_BY_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.LogMessage lm WHERE lm.id=:id";

    public LogMessageDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public void init() throws DbException {
        URL url = this.getClass().getResource("/insert_log_messages.sql");
        assert (Objects.nonNull(url));
        _log.info("Trying to insert the messages from {}", (Object)url);
        try (EntityManager entityManager = this.createNewEntityManager();
             LineNumberReader lnr = new LineNumberReader(new InputStreamReader(url.openStream()));){
            String line;
            entityManager.getTransaction().begin();
            long count = (Long)entityManager.createQuery("select count(logMessage) from de.pontonconsulting.xmlpipe.messenger.database.hibernate.LogMessage logMessage", Long.class).getSingleResult();
            _log.info("Log Message count in the Database is not as expected. found: {}", (Object)count);
            while ((line = lnr.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, VALUE_SEPARATOR);
                if (st.countTokens() != 5) continue;
                try {
                    LogMessage logMessage;
                    int id = Integer.parseInt(st.nextToken().trim());
                    int type = Integer.parseInt(st.nextToken().trim());
                    int beginCom = Integer.parseInt(st.nextToken().trim());
                    int endCom = Integer.parseInt(st.nextToken().trim());
                    String text = st.nextToken().trim().replaceAll("'", "");
                    Object dbLogMessage = entityManager.find(LogMessage.class, (Object)id);
                    if (dbLogMessage == null) {
                        logMessage = new LogMessage(id, type, beginCom, endCom, text);
                        entityManager.persist((Object)logMessage);
                        _log.info("inserted new log message '{}'", (Object)line);
                        continue;
                    }
                    logMessage = (LogMessage)entityManager.find(LogMessage.class, (Object)id);
                    if (type != logMessage.getType() || beginCom != logMessage.getBeginComponent() || endCom != logMessage.getEndComponent() || !text.equals(logMessage.getText())) {
                        logMessage.setType(type);
                        logMessage.setBeginComponent(beginCom);
                        logMessage.setEndComponent(endCom);
                        logMessage.setText(text);
                        entityManager.persist((Object)logMessage);
                        _log.info("updated log message : {}", (Object)line);
                        continue;
                    }
                    _log.trace("log message already there: {}", (Object)line);
                }
                catch (Exception e) {
                    _log.error("could not insert/update log message '{}' {}", (Object)line, (Object)e);
                }
            }
            entityManager.getTransaction().commit();
        }
        catch (IOException | RuntimeException e) {
            _log.error("Could not update 'LOG_MESSAGE' table in database", (Throwable)e);
            throw new DbException(13067, "Could not update 'LOG_MESSAGE' table in database. Reason: " + e.getMessage(), e);
        }
    }

    public void dbConsistencyCheck() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            LogMessage logMessage = new LogMessage();
            logMessage.setId(1234567890);
            logMessage.setType(1);
            logMessage.setBeginComponent(2);
            logMessage.setEndComponent(3);
            logMessage.setText(TEST_VALUE_TEXT);
            entityManager.persist((Object)logMessage);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            _log.error("Could not add entry into 'LOG_MESSAGE' table." + String.valueOf(e));
            throw new DbException(13029, "DB Consistency check for table 'LOG_MESSAGES' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void dbCleanup() throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            this.deleteFromMessageLog(1234567890L, entityManager);
            entityManager.getTransaction().commit();
        }
        catch (EntityNotFoundException e) {
            _log.debug("Test LogMessageEntry not found");
        }
        catch (RuntimeException e) {
            _log.error("Could not delete entry 1234567890 from 'LOG_MESSAGE' table." + String.valueOf(e));
            throw new DbException(13068, "Could not delete entry from 'LOG_MESSAGE' table. Reason: " + e.getMessage(), e);
        }
    }

    private int deleteFromMessageLog(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_LOG_MESSAGE_BY_ID).setParameter("id", (Object)messageDataId).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13068, "Could not delete entry from 'LOG_MESSAGE' table. Reason: " + e.getMessage(), e);
        }
    }
}

