/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.HttpAdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpAdapterInfoDAO
extends BaseDAO {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.HttpAdapterInfoDAO");
    private static final String PARAM_ADAPTER_ID = "adapterId";

    public HttpAdapterInfoDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public List<HttpAdapterInfo> getAllHttpAdapters() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM HttpAdapterInfo ORDER BY adapterId", HttpAdapterInfo.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public HttpAdapterInfo getHttpAdapter(String adapterId) {
        HttpAdapterInfo httpAdapterInfo;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM HttpAdapterInfo WHERE adapterId = :adapterId", HttpAdapterInfo.class);
                query.setParameter(PARAM_ADAPTER_ID, (Object)adapterId);
                httpAdapterInfo = (HttpAdapterInfo)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return httpAdapterInfo;
    }

    public HttpAdapterInfo getHttpAdapterByPort(Integer port) {
        HttpAdapterInfo httpAdapterInfo;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM HttpAdapterInfo WHERE port = :port", HttpAdapterInfo.class);
                query.setParameter("port", (Object)port);
                httpAdapterInfo = (HttpAdapterInfo)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return httpAdapterInfo;
    }

    public boolean storeHttpAdapter(HttpAdapterInfo httpAdapterInfo, String username) {
        boolean isNewHttpAdapter = !this.httpAdapterExists(httpAdapterInfo.getAdapterId());
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            httpAdapterInfo.setLastChange(OffsetDateTime.now(ZoneOffset.UTC));
            httpAdapterInfo.setUsername(username);
            entityManager.merge((Object)httpAdapterInfo);
            entityManager.getTransaction().commit();
        }
        return isNewHttpAdapter;
    }

    public void importHttpAdapter(HttpAdapterInfo httpAdapterInfo) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)httpAdapterInfo);
            entityManager.getTransaction().commit();
        }
    }

    public boolean httpAdapterExists(String adapterId) {
        return Objects.nonNull(this.getLastChanged(adapterId));
    }

    public void deleteHttpAdapter(String adapterId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.createQuery("DELETE FROM HttpAdapterInfo WHERE adapterId = :adapterId").setParameter(PARAM_ADAPTER_ID, (Object)adapterId).executeUpdate();
            entityManager.getTransaction().commit();
        }
    }

    public OffsetDateTime getLastChanged(String adapterId) {
        OffsetDateTime offsetDateTime;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT lastChange FROM HttpAdapterInfo WHERE adapterId = :adapterId", OffsetDateTime.class);
                query.setParameter(PARAM_ADAPTER_ID, (Object)adapterId);
                offsetDateTime = (OffsetDateTime)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return offsetDateTime;
    }
}

