/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceException;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalTaskDAO
extends BaseDAO {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.GlobalTaskDAO");

    public GlobalTaskDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public boolean assignGlobalTasksToThisMessenger(Integer oldMessengerId, int messengerId) {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int updated = entityManager.createQuery("UPDATE GlobalTask g\nSET g.executingMessengerId = :messengerId\nWHERE (:oldMessengerId IS NULL AND g.executingMessengerId IS NULL)\n   OR (g.executingMessengerId = :oldMessengerId)\n").setParameter("messengerId", (Object)messengerId).setParameter("oldMessengerId", (Object)oldMessengerId).executeUpdate();
                entityManager.getTransaction().commit();
                boolean bl2 = bl = updated > 0;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PersistenceException e) {
                    LOG.warn("assigning global tasks to messengerId {} failed {}", (Object)messengerId, (Object)e.toString());
                    return false;
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public Optional<MessengerInfo> getGlobalTasksMessengerId() {
        Optional<MessengerInfo> optional;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                Object[] result = (Object[])entityManager.createQuery("SELECT ma.messengerId, ma.lastHeartBeat\nFROM MessengerActivation ma\nJOIN GlobalTask gt ON gt.executingMessengerId = ma.messengerId\nWHERE gt.executingMessengerId IS NOT NULL\n", Object[].class).setMaxResults(1).getSingleResult();
                optional = Optional.of(new MessengerInfo((Integer)result[0], (OffsetDateTime)result[1]));
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException | NonUniqueResultException e) {
                    return Optional.empty();
                }
            }
            entityManager.close();
        }
        return optional;
    }

    public record MessengerInfo(Integer messengerId, OffsetDateTime lastHeartBeat) {
    }
}

