/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.config.DatabaseType;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ArchiveQueue;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ArchiveQueueDAO
extends BaseDAO {
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_ON_ARCHIVING = 1;
    private final MessengerConfig messengerConfig;
    private final ReferenceDateTask referenceDateTask;

    public ArchiveQueueDAO(HibernateSessionFactory hibernateSessionFactory, IFolders folders, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
    }

    public boolean enqueue(long messageId, boolean isFailedMessage) throws DbException {
        boolean bl;
        block15: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                ArchiveQueue archiveQueue = new ArchiveQueue();
                archiveQueue.setMessageId(messageId);
                archiveQueue.setFailedMessage(isFailedMessage);
                archiveQueue.setStatus(0);
                archiveQueue.setEnqueueTime(this.referenceDateTask.getReferenceOffsetDateTime());
                entityManager.persist((Object)archiveQueue);
                entityManager.getTransaction().commit();
                bl = true;
                if (entityManager == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DbException dbException = new DbException(13013, "Can't enqueue ArchiveMessage (" + messageId + "): " + e.getMessage(), e);
                    entityManager = this.createNewEntityManager();
                    try {
                        if (Objects.nonNull(entityManager.find(ArchiveQueue.class, (Object)messageId))) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    finally {
                        if (entityManager != null) {
                            entityManager.close();
                        }
                    }
                    throw dbException;
                }
            }
            entityManager.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ArchiveQueue> getNextMessageToArchive() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            String selectAndLockSql = switch (this.getDatabaseType()) {
                case DatabaseType.ORACLE -> "SELECT MESSAGE_ID\nFROM ARCHIVE_QUEUE\nWHERE MESSAGE_ID IN\n(\n   SELECT MESSAGE_ID FROM ARCHIVE_QUEUE\n   WHERE STATUS = 0\n   ORDER BY ENQUEUE_TIME\n   FETCH FIRST 1 ROW ONLY\n)\nFOR UPDATE SKIP LOCKED\n";
                case DatabaseType.POSTGRESQL, DatabaseType.MYSQL -> "SELECT MESSAGE_ID FROM ARCHIVE_QUEUE\nWHERE STATUS = 0\nORDER BY ENQUEUE_TIME\nLIMIT 1\nFOR UPDATE SKIP LOCKED\n";
                case DatabaseType.MSSQL -> "SELECT TOP 1 MESSAGE_ID FROM ARCHIVE_QUEUE WITH (UPDLOCK, READPAST)\nWHERE STATUS = 0\nORDER BY ENQUEUE_TIME\n";
                default -> "SELECT MESSAGE_ID FROM ARCHIVE_QUEUE\nWHERE STATUS = 0\nORDER BY ENQUEUE_TIME\nLIMIT 1\nFOR UPDATE\n";
            };
            List messageIds = entityManager.createNativeQuery(selectAndLockSql, Long.class).getResultList();
            if (messageIds.isEmpty() || messageIds.getFirst() == null) {
                entityManager.getTransaction().rollback();
                _log.debug("No pending ArchiveQueue message found.");
                Optional<ArchiveQueue> optional = Optional.empty();
                return optional;
            }
            Long messageId = (Long)messageIds.getFirst();
            _log.trace("Found next message ({}) to archive", (Object)messageId);
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, messengerId = :messengerId, lastArchiveRun = :now\nWHERE status = :statusOld AND messageId = :messageId\n").setParameter("statusNew", (Object)1).setParameter("statusOld", (Object)0).setParameter("messengerId", (Object)this.messengerConfig.getMessengerId()).setParameter("now", (Object)this.referenceDateTask.getReferenceOffsetDateTime()).setParameter("messageId", (Object)messageId).executeUpdate();
            if (updateCount == 0) {
                _log.trace("ArchiveProcess of message ({}) is already started", (Object)messageId);
                entityManager.getTransaction().rollback();
                Optional<ArchiveQueue> optional = Optional.empty();
                return optional;
            }
            _log.trace("Started ArchiveProcess of message ({})", (Object)messageId);
            Optional<ArchiveQueue> archiveQueue = Optional.of((ArchiveQueue)entityManager.find(ArchiveQueue.class, (Object)messageId));
            entityManager.getTransaction().commit();
            Optional<ArchiveQueue> optional = archiveQueue;
            return optional;
        }
        catch (Exception e) {
            _log.fatal("Can't select next pending message to archive", (Throwable)e);
            return Optional.empty();
        }
    }

    public Long getArchiveQueueSize() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            Long l = (Long)entityManager.createQuery("SELECT count(*) FROM ArchiveQueue", Long.class).getSingleResult();
            return l;
        }
    }

    public int resetTimedOutArchiveQueueMessages() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND lastArchiveRun < :timeOut AND messengerId != :messengerId\n").setParameter("statusNew", (Object)0).setParameter("statusOld", (Object)1).setParameter("messengerId", (Object)this.messengerConfig.getMessengerId()).setParameter("timeOut", (Object)this.referenceDateTask.getReferenceOffsetDateTime().minusMinutes(10L)).executeUpdate();
            entityManager.getTransaction().commit();
            int n = resetCount;
            return n;
        }
    }

    public int resetOwnArchiveQueueMessages() {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND messengerId = :messengerId\n").setParameter("statusNew", (Object)0).setParameter("statusOld", (Object)1).setParameter("messengerId", (Object)this.messengerConfig.getMessengerId()).executeUpdate();
            entityManager.getTransaction().commit();
            int n = resetCount;
            return n;
        }
    }

    public boolean resetArchiveQueueMessage(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int resetCount = entityManager.createQuery("UPDATE ArchiveQueue\nSET status = :statusNew, lastArchiveRun = NULL\nWHERE status = :statusOld AND messageId = :messageId\n").setParameter("statusNew", (Object)0).setParameter("statusOld", (Object)1).setParameter("messageId", (Object)messageId).executeUpdate();
            entityManager.getTransaction().commit();
            boolean bl = resetCount == 1;
            return bl;
        }
    }

    public boolean deleteArchiveQueue(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int deleteCount = entityManager.createQuery("DELETE FROM ArchiveQueue WHERE messageId = :messageId").setParameter("messageId", (Object)messageId).executeUpdate();
            entityManager.getTransaction().commit();
            boolean bl = deleteCount == 1;
            return bl;
        }
    }
}

