/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="MESSAGE")
@DiscriminatorValue(value="0")
public class XpOutboundMessage
extends XpBaseMessage {
    private static final long serialVersionUID = -1954145990882755827L;
    @Column(name="DESTINATION_URL")
    private String destinationUrl;
    @Column(name="PACKAGING_ID")
    private String packageId;
    private transient Agreement agreement;
    private transient Communication communication;

    public XpOutboundMessage() {
    }

    public XpOutboundMessage(XpMessage xpMessage) {
        super(xpMessage);
        this.agreement = xpMessage.getAgreement();
        this.communication = xpMessage.getCommunication();
    }

    @Override
    protected void setMessageProperties(XpMessage xpMessage) {
        super.setMessageProperties(xpMessage);
        this.destinationUrl = xpMessage.getDestinationUrl();
        this.packageId = xpMessage.getMessagePackaging();
    }

    public List<Integer> getRetryIntervals() {
        List<Integer> retryIntervals;
        try {
            retryIntervals = this.getCommunication().getRetryIntervals();
        }
        catch (CommunicationNotFoundException e) {
            retryIntervals = Collections.emptyList();
        }
        if (this.isPing()) {
            retryIntervals = retryIntervals.isEmpty() ? List.of(Integer.valueOf(20)) : List.of(retryIntervals.getFirst());
        }
        return retryIntervals;
    }

    public long getRetryDelay(Integer noOfRetry) {
        List<Integer> retryIntervals = this.getRetryIntervals();
        try {
            int index = Math.clamp((long)Objects.requireNonNullElse(noOfRetry, 0).intValue(), 0, retryIntervals.size() - 1);
            return (long)retryIntervals.get(index).intValue() * 1000L;
        }
        catch (IllegalArgumentException e) {
            return 20000L;
        }
    }

    public int getMaxNumberOfRetries() {
        if (this.isPing()) {
            return 0;
        }
        try {
            return this.getCommunication().getNumberOfRetries();
        }
        catch (CommunicationNotFoundException e) {
            return 0;
        }
    }

    public String getRealUrl(boolean isMessengerPingAllEnabled) throws TransportException {
        TransportURLType transportURLType;
        try {
            transportURLType = TransportURLType.valueOf((String)this.getDestinationUrl());
        }
        catch (Exception e) {
            transportURLType = TransportURLType.FIXED;
        }
        try {
            return switch (transportURLType) {
                default -> throw new MatchException(null, null);
                case TransportURLType.PRIMARY -> this.getCommunication().getTransportURL();
                case TransportURLType.FALLBACK -> this.getCommunication().getTransportFallbackURL();
                case TransportURLType.DYNAMIC -> {
                    if (isMessengerPingAllEnabled && this.hasAgreement() && this.agreement.isPingAllEnabled()) {
                        yield this.getCommunication().getWorkingTransportURL();
                    }
                    yield this.getCommunication().getTransportURL();
                }
                case TransportURLType.FIXED -> this.getDestinationUrl();
            };
        }
        catch (CommunicationNotFoundException e) {
            return this.getDestinationUrl();
        }
    }

    public void setAgreement(Agreement agreement, String communicationPartnerId) throws CommunicationNotFoundException {
        this.communication = agreement.getCommunication(this.getSenderLocalId(), communicationPartnerId);
        this.agreement = agreement;
    }

    public boolean hasAgreement() {
        return Objects.nonNull(this.agreement);
    }

    public Communication getCommunication() throws CommunicationNotFoundException {
        return this.communication;
    }

    public String getMessagePackaging() {
        return this.packageId;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }
}

