/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.ponton.xmlpipe.rest.certificate.KeyUsage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.SubjectAlternativeName;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Entity
@Table(name="PARTNER_CERTIFICATE_DATA")
public class PartnerCertificateData
implements Serializable {
    private static final long serialVersionUID = -6439599214844010608L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="PARTNER_CERTIFICATE_DATA_ID", nullable=false)
    private BigInteger partnerCertificateDataId;
    @Column(name="PARTNER_ID", nullable=false, length=30)
    private String partnerId;
    @Column(name="CERTIFICATE", nullable=false)
    private byte[] certificate;
    @Column(name="SUBJECT_KEY_IDENTIFIER", length=50)
    private String subjectKeyIdentifier;
    @Column(name="INTERNAL_CERT_ID", length=30)
    private String internalCertId;
    @Column(name="SERIAL", length=50)
    private String serial;
    @Column(name="ISSUER", length=128)
    private String issuer;
    @Column(name="SUBJECT_DN", length=128)
    private String subjectDn;
    @Column(name="KEY_PAIR_ALGO", length=128)
    private String keyPairAlgo;
    @Column(name="KEY_USAGE", length=128)
    private String keyUsage;
    @Column(name="EXTENDED_KEY_USAGE", length=500)
    private String extendedKeyUsage;
    @Column(name="ENCRYPTED_PRIVATE_KEY")
    private byte[] encryptedPrivateKey;
    @Column(name="PRIVATE_KEY_PASSWORD")
    private byte[] privateKeyPassword;
    @Column(name="VALID_FROM", nullable=false)
    private OffsetDateTime validFrom;
    @Column(name="VALID_TO", nullable=false)
    private OffsetDateTime validTo;
    @Column(name="REVOCATION_STATUS", length=30)
    private String revocationStatus;
    @Column(name="LAST_SUCCESSFUL_REVOCATION_CHECK")
    private OffsetDateTime lastSuccessfulRevocationCheck;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="PARTNER_CERTIFICATE_DATA_ID")
    private Set<SubjectAlternativeName> subjectAlternativeNames;

    public BigInteger getPartnerCertificateDataId() {
        return this.partnerCertificateDataId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public PartnerCertificateData setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public PartnerCertificateData setCertificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    public String getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public PartnerCertificateData setSubjectKeyIdentifier(String subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        return this;
    }

    public String getInternalCertId() {
        return this.internalCertId;
    }

    public PartnerCertificateData setInternalCertId(String internalCertId) {
        this.internalCertId = internalCertId;
        return this;
    }

    public String getSerial() {
        return this.serial;
    }

    public PartnerCertificateData setSerial(String serial) {
        this.serial = serial;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public PartnerCertificateData setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public PartnerCertificateData setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
        return this;
    }

    public String getKeyPairAlgo() {
        return this.keyPairAlgo;
    }

    public PartnerCertificateData setKeyPairAlgo(String keyPairAlgo) {
        this.keyPairAlgo = keyPairAlgo;
        return this;
    }

    public List<KeyUsage> getKeyUsage() {
        return PartnerCertificateData.convertStringToKeyUsage(this.keyUsage);
    }

    public PartnerCertificateData setKeyUsage(List<KeyUsage> keyUsage) {
        this.keyUsage = PartnerCertificateData.convertKeyUsageToString(keyUsage);
        return this;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsage() {
        return PartnerCertificateData.convertStringToExtendedKeyUsage(this.extendedKeyUsage);
    }

    public PartnerCertificateData setExtendedKeyUsage(List<ExtendedKeyUsage> extendedKeyUsage) {
        this.extendedKeyUsage = PartnerCertificateData.convertExtendedKeyUsageToString(extendedKeyUsage);
        return this;
    }

    public byte[] getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public PartnerCertificateData setEncryptedPrivateKey(byte[] encryptedPrivateKey) {
        this.encryptedPrivateKey = encryptedPrivateKey;
        return this;
    }

    public byte[] getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public PartnerCertificateData setPrivateKeyPassword(byte[] privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public OffsetDateTime getValidFrom() {
        return this.validFrom;
    }

    public PartnerCertificateData setValidFrom(OffsetDateTime validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public OffsetDateTime getValidTo() {
        return this.validTo;
    }

    public PartnerCertificateData setValidTo(OffsetDateTime validTo) {
        this.validTo = validTo;
        return this;
    }

    public String getRevocationStatus() {
        return this.revocationStatus;
    }

    public PartnerCertificateData setRevocationStatus(String revocationStatus) {
        this.revocationStatus = revocationStatus;
        return this;
    }

    public OffsetDateTime getLastSuccessfulRevocationCheck() {
        return this.lastSuccessfulRevocationCheck;
    }

    public PartnerCertificateData setLastSuccessfulRevocationCheck(OffsetDateTime lastSuccessfulRevocationCheck) {
        this.lastSuccessfulRevocationCheck = lastSuccessfulRevocationCheck;
        return this;
    }

    public Set<SubjectAlternativeName> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public PartnerCertificateData setSubjectAlternativeNames(Set<SubjectAlternativeName> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    private static String convertKeyUsageToString(List<KeyUsage> usages) {
        if (usages == null || usages.isEmpty()) {
            return null;
        }
        return usages.stream().sorted().map(Enum::name).collect(Collectors.joining(","));
    }

    private static List<KeyUsage> convertStringToKeyUsage(String usageString) {
        if (usageString == null || usageString.isEmpty()) {
            return List.of();
        }
        return Arrays.stream(usageString.split(",")).map(KeyUsage::valueOf).collect(Collectors.toList());
    }

    private static String convertExtendedKeyUsageToString(List<ExtendedKeyUsage> usages) {
        if (usages == null || usages.isEmpty()) {
            return null;
        }
        return usages.stream().sorted().map(Enum::name).collect(Collectors.joining(","));
    }

    private static List<ExtendedKeyUsage> convertStringToExtendedKeyUsage(String usageString) {
        if (usageString == null || usageString.isEmpty()) {
            return List.of();
        }
        return Arrays.stream(usageString.split(",")).map(ExtendedKeyUsage::valueOf).collect(Collectors.toList());
    }
}

